/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateNetworkAnalyzerConfigurationRequest extends IotWirelessRequest implements
        ToCopyableBuilder<CreateNetworkAnalyzerConfigurationRequest.Builder, CreateNetworkAnalyzerConfigurationRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateNetworkAnalyzerConfigurationRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<TraceContent> TRACE_CONTENT_FIELD = SdkField.<TraceContent> builder(MarshallingType.SDK_POJO)
            .memberName("TraceContent").getter(getter(CreateNetworkAnalyzerConfigurationRequest::traceContent))
            .setter(setter(Builder::traceContent)).constructor(TraceContent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TraceContent").build()).build();

    private static final SdkField<List<String>> WIRELESS_DEVICES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("WirelessDevices")
            .getter(getter(CreateNetworkAnalyzerConfigurationRequest::wirelessDevices))
            .setter(setter(Builder::wirelessDevices))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WirelessDevices").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> WIRELESS_GATEWAYS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("WirelessGateways")
            .getter(getter(CreateNetworkAnalyzerConfigurationRequest::wirelessGateways))
            .setter(setter(Builder::wirelessGateways))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WirelessGateways").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateNetworkAnalyzerConfigurationRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateNetworkAnalyzerConfigurationRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientRequestToken")
            .getter(getter(CreateNetworkAnalyzerConfigurationRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<List<String>> MULTICAST_GROUPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("MulticastGroups")
            .getter(getter(CreateNetworkAnalyzerConfigurationRequest::multicastGroups))
            .setter(setter(Builder::multicastGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MulticastGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            TRACE_CONTENT_FIELD, WIRELESS_DEVICES_FIELD, WIRELESS_GATEWAYS_FIELD, DESCRIPTION_FIELD, TAGS_FIELD,
            CLIENT_REQUEST_TOKEN_FIELD, MULTICAST_GROUPS_FIELD));

    private final String name;

    private final TraceContent traceContent;

    private final List<String> wirelessDevices;

    private final List<String> wirelessGateways;

    private final String description;

    private final List<Tag> tags;

    private final String clientRequestToken;

    private final List<String> multicastGroups;

    private CreateNetworkAnalyzerConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.traceContent = builder.traceContent;
        this.wirelessDevices = builder.wirelessDevices;
        this.wirelessGateways = builder.wirelessGateways;
        this.description = builder.description;
        this.tags = builder.tags;
        this.clientRequestToken = builder.clientRequestToken;
        this.multicastGroups = builder.multicastGroups;
    }

    /**
     * Returns the value of the Name property for this object.
     * 
     * @return The value of the Name property for this object.
     */
    public final String name() {
        return name;
    }

    /**
     * Returns the value of the TraceContent property for this object.
     * 
     * @return The value of the TraceContent property for this object.
     */
    public final TraceContent traceContent() {
        return traceContent;
    }

    /**
     * For responses, this returns true if the service returned a value for the WirelessDevices property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasWirelessDevices() {
        return wirelessDevices != null && !(wirelessDevices instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Wireless device resources to add to the network analyzer configuration. Provide the <code>WirelessDeviceId</code>
     * of the resource to add in the input array.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWirelessDevices} method.
     * </p>
     * 
     * @return Wireless device resources to add to the network analyzer configuration. Provide the
     *         <code>WirelessDeviceId</code> of the resource to add in the input array.
     */
    public final List<String> wirelessDevices() {
        return wirelessDevices;
    }

    /**
     * For responses, this returns true if the service returned a value for the WirelessGateways property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasWirelessGateways() {
        return wirelessGateways != null && !(wirelessGateways instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Wireless gateway resources to add to the network analyzer configuration. Provide the
     * <code>WirelessGatewayId</code> of the resource to add in the input array.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWirelessGateways} method.
     * </p>
     * 
     * @return Wireless gateway resources to add to the network analyzer configuration. Provide the
     *         <code>WirelessGatewayId</code> of the resource to add in the input array.
     */
    public final List<String> wirelessGateways() {
        return wirelessGateways;
    }

    /**
     * Returns the value of the Description property for this object.
     * 
     * @return The value of the Description property for this object.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the Tags property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The value of the Tags property for this object.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * Returns the value of the ClientRequestToken property for this object.
     * 
     * @return The value of the ClientRequestToken property for this object.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the MulticastGroups property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMulticastGroups() {
        return multicastGroups != null && !(multicastGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Multicast Group resources to add to the network analyzer configruation. Provide the <code>MulticastGroupId</code>
     * of the resource to add in the input array.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMulticastGroups} method.
     * </p>
     * 
     * @return Multicast Group resources to add to the network analyzer configruation. Provide the
     *         <code>MulticastGroupId</code> of the resource to add in the input array.
     */
    public final List<String> multicastGroups() {
        return multicastGroups;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(traceContent());
        hashCode = 31 * hashCode + Objects.hashCode(hasWirelessDevices() ? wirelessDevices() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasWirelessGateways() ? wirelessGateways() : null);
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasMulticastGroups() ? multicastGroups() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateNetworkAnalyzerConfigurationRequest)) {
            return false;
        }
        CreateNetworkAnalyzerConfigurationRequest other = (CreateNetworkAnalyzerConfigurationRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(traceContent(), other.traceContent())
                && hasWirelessDevices() == other.hasWirelessDevices()
                && Objects.equals(wirelessDevices(), other.wirelessDevices())
                && hasWirelessGateways() == other.hasWirelessGateways()
                && Objects.equals(wirelessGateways(), other.wirelessGateways())
                && Objects.equals(description(), other.description()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(clientRequestToken(), other.clientRequestToken())
                && hasMulticastGroups() == other.hasMulticastGroups()
                && Objects.equals(multicastGroups(), other.multicastGroups());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateNetworkAnalyzerConfigurationRequest").add("Name", name())
                .add("TraceContent", traceContent()).add("WirelessDevices", hasWirelessDevices() ? wirelessDevices() : null)
                .add("WirelessGateways", hasWirelessGateways() ? wirelessGateways() : null).add("Description", description())
                .add("Tags", hasTags() ? tags() : null).add("ClientRequestToken", clientRequestToken())
                .add("MulticastGroups", hasMulticastGroups() ? multicastGroups() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "TraceContent":
            return Optional.ofNullable(clazz.cast(traceContent()));
        case "WirelessDevices":
            return Optional.ofNullable(clazz.cast(wirelessDevices()));
        case "WirelessGateways":
            return Optional.ofNullable(clazz.cast(wirelessGateways()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "ClientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        case "MulticastGroups":
            return Optional.ofNullable(clazz.cast(multicastGroups()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateNetworkAnalyzerConfigurationRequest, T> g) {
        return obj -> g.apply((CreateNetworkAnalyzerConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotWirelessRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateNetworkAnalyzerConfigurationRequest> {
        /**
         * Sets the value of the Name property for this object.
         *
         * @param name
         *        The new value for the Name property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * Sets the value of the TraceContent property for this object.
         *
         * @param traceContent
         *        The new value for the TraceContent property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder traceContent(TraceContent traceContent);

        /**
         * Sets the value of the TraceContent property for this object.
         *
         * This is a convenience method that creates an instance of the {@link TraceContent.Builder} avoiding the need
         * to create one manually via {@link TraceContent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TraceContent.Builder#build()} is called immediately and its
         * result is passed to {@link #traceContent(TraceContent)}.
         * 
         * @param traceContent
         *        a consumer that will call methods on {@link TraceContent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #traceContent(TraceContent)
         */
        default Builder traceContent(Consumer<TraceContent.Builder> traceContent) {
            return traceContent(TraceContent.builder().applyMutation(traceContent).build());
        }

        /**
         * <p>
         * Wireless device resources to add to the network analyzer configuration. Provide the
         * <code>WirelessDeviceId</code> of the resource to add in the input array.
         * </p>
         * 
         * @param wirelessDevices
         *        Wireless device resources to add to the network analyzer configuration. Provide the
         *        <code>WirelessDeviceId</code> of the resource to add in the input array.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder wirelessDevices(Collection<String> wirelessDevices);

        /**
         * <p>
         * Wireless device resources to add to the network analyzer configuration. Provide the
         * <code>WirelessDeviceId</code> of the resource to add in the input array.
         * </p>
         * 
         * @param wirelessDevices
         *        Wireless device resources to add to the network analyzer configuration. Provide the
         *        <code>WirelessDeviceId</code> of the resource to add in the input array.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder wirelessDevices(String... wirelessDevices);

        /**
         * <p>
         * Wireless gateway resources to add to the network analyzer configuration. Provide the
         * <code>WirelessGatewayId</code> of the resource to add in the input array.
         * </p>
         * 
         * @param wirelessGateways
         *        Wireless gateway resources to add to the network analyzer configuration. Provide the
         *        <code>WirelessGatewayId</code> of the resource to add in the input array.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder wirelessGateways(Collection<String> wirelessGateways);

        /**
         * <p>
         * Wireless gateway resources to add to the network analyzer configuration. Provide the
         * <code>WirelessGatewayId</code> of the resource to add in the input array.
         * </p>
         * 
         * @param wirelessGateways
         *        Wireless gateway resources to add to the network analyzer configuration. Provide the
         *        <code>WirelessGatewayId</code> of the resource to add in the input array.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder wirelessGateways(String... wirelessGateways);

        /**
         * Sets the value of the Description property for this object.
         *
         * @param description
         *        The new value for the Description property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * Sets the value of the Tags property for this object.
         *
         * @param tags
         *        The new value for the Tags property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * Sets the value of the Tags property for this object.
         *
         * @param tags
         *        The new value for the Tags property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * Sets the value of the Tags property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotwireless.model.Tag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.iotwireless.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotwireless.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotwireless.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * Sets the value of the ClientRequestToken property for this object.
         *
         * @param clientRequestToken
         *        The new value for the ClientRequestToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * <p>
         * Multicast Group resources to add to the network analyzer configruation. Provide the
         * <code>MulticastGroupId</code> of the resource to add in the input array.
         * </p>
         * 
         * @param multicastGroups
         *        Multicast Group resources to add to the network analyzer configruation. Provide the
         *        <code>MulticastGroupId</code> of the resource to add in the input array.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multicastGroups(Collection<String> multicastGroups);

        /**
         * <p>
         * Multicast Group resources to add to the network analyzer configruation. Provide the
         * <code>MulticastGroupId</code> of the resource to add in the input array.
         * </p>
         * 
         * @param multicastGroups
         *        Multicast Group resources to add to the network analyzer configruation. Provide the
         *        <code>MulticastGroupId</code> of the resource to add in the input array.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multicastGroups(String... multicastGroups);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotWirelessRequest.BuilderImpl implements Builder {
        private String name;

        private TraceContent traceContent;

        private List<String> wirelessDevices = DefaultSdkAutoConstructList.getInstance();

        private List<String> wirelessGateways = DefaultSdkAutoConstructList.getInstance();

        private String description;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String clientRequestToken;

        private List<String> multicastGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateNetworkAnalyzerConfigurationRequest model) {
            super(model);
            name(model.name);
            traceContent(model.traceContent);
            wirelessDevices(model.wirelessDevices);
            wirelessGateways(model.wirelessGateways);
            description(model.description);
            tags(model.tags);
            clientRequestToken(model.clientRequestToken);
            multicastGroups(model.multicastGroups);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final TraceContent.Builder getTraceContent() {
            return traceContent != null ? traceContent.toBuilder() : null;
        }

        public final void setTraceContent(TraceContent.BuilderImpl traceContent) {
            this.traceContent = traceContent != null ? traceContent.build() : null;
        }

        @Override
        public final Builder traceContent(TraceContent traceContent) {
            this.traceContent = traceContent;
            return this;
        }

        public final Collection<String> getWirelessDevices() {
            if (wirelessDevices instanceof SdkAutoConstructList) {
                return null;
            }
            return wirelessDevices;
        }

        public final void setWirelessDevices(Collection<String> wirelessDevices) {
            this.wirelessDevices = WirelessDeviceListCopier.copy(wirelessDevices);
        }

        @Override
        public final Builder wirelessDevices(Collection<String> wirelessDevices) {
            this.wirelessDevices = WirelessDeviceListCopier.copy(wirelessDevices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder wirelessDevices(String... wirelessDevices) {
            wirelessDevices(Arrays.asList(wirelessDevices));
            return this;
        }

        public final Collection<String> getWirelessGateways() {
            if (wirelessGateways instanceof SdkAutoConstructList) {
                return null;
            }
            return wirelessGateways;
        }

        public final void setWirelessGateways(Collection<String> wirelessGateways) {
            this.wirelessGateways = WirelessGatewayListCopier.copy(wirelessGateways);
        }

        @Override
        public final Builder wirelessGateways(Collection<String> wirelessGateways) {
            this.wirelessGateways = WirelessGatewayListCopier.copy(wirelessGateways);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder wirelessGateways(String... wirelessGateways) {
            wirelessGateways(Arrays.asList(wirelessGateways));
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final Collection<String> getMulticastGroups() {
            if (multicastGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return multicastGroups;
        }

        public final void setMulticastGroups(Collection<String> multicastGroups) {
            this.multicastGroups = NetworkAnalyzerMulticastGroupListCopier.copy(multicastGroups);
        }

        @Override
        public final Builder multicastGroups(Collection<String> multicastGroups) {
            this.multicastGroups = NetworkAnalyzerMulticastGroupListCopier.copy(multicastGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder multicastGroups(String... multicastGroups) {
            multicastGroups(Arrays.asList(multicastGroups));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateNetworkAnalyzerConfigurationRequest build() {
            return new CreateNetworkAnalyzerConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
