/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The message in the downlink queue.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DownlinkQueueMessage implements SdkPojo, Serializable,
        ToCopyableBuilder<DownlinkQueueMessage.Builder, DownlinkQueueMessage> {
    private static final SdkField<String> MESSAGE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MessageId").getter(getter(DownlinkQueueMessage::messageId)).setter(setter(Builder::messageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageId").build()).build();

    private static final SdkField<Integer> TRANSMIT_MODE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TransmitMode").getter(getter(DownlinkQueueMessage::transmitMode)).setter(setter(Builder::transmitMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransmitMode").build()).build();

    private static final SdkField<String> RECEIVED_AT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReceivedAt").getter(getter(DownlinkQueueMessage::receivedAt)).setter(setter(Builder::receivedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReceivedAt").build()).build();

    private static final SdkField<LoRaWANSendDataToDevice> LO_RA_WAN_FIELD = SdkField
            .<LoRaWANSendDataToDevice> builder(MarshallingType.SDK_POJO).memberName("LoRaWAN")
            .getter(getter(DownlinkQueueMessage::loRaWAN)).setter(setter(Builder::loRaWAN))
            .constructor(LoRaWANSendDataToDevice::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoRaWAN").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGE_ID_FIELD,
            TRANSMIT_MODE_FIELD, RECEIVED_AT_FIELD, LO_RA_WAN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String messageId;

    private final Integer transmitMode;

    private final String receivedAt;

    private final LoRaWANSendDataToDevice loRaWAN;

    private DownlinkQueueMessage(BuilderImpl builder) {
        this.messageId = builder.messageId;
        this.transmitMode = builder.transmitMode;
        this.receivedAt = builder.receivedAt;
        this.loRaWAN = builder.loRaWAN;
    }

    /**
     * <p>
     * The message ID assigned by IoT Wireless to each downlink message, which helps identify the message.
     * </p>
     * 
     * @return The message ID assigned by IoT Wireless to each downlink message, which helps identify the message.
     */
    public final String messageId() {
        return messageId;
    }

    /**
     * <p>
     * The transmit mode to use for sending data to the wireless device. This can be <code>0</code> for UM
     * (unacknowledge mode) or <code>1</code> for AM (acknowledge mode).
     * </p>
     * 
     * @return The transmit mode to use for sending data to the wireless device. This can be <code>0</code> for UM
     *         (unacknowledge mode) or <code>1</code> for AM (acknowledge mode).
     */
    public final Integer transmitMode() {
        return transmitMode;
    }

    /**
     * <p>
     * The time at which Iot Wireless received the downlink message.
     * </p>
     * 
     * @return The time at which Iot Wireless received the downlink message.
     */
    public final String receivedAt() {
        return receivedAt;
    }

    /**
     * Returns the value of the LoRaWAN property for this object.
     * 
     * @return The value of the LoRaWAN property for this object.
     */
    public final LoRaWANSendDataToDevice loRaWAN() {
        return loRaWAN;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(messageId());
        hashCode = 31 * hashCode + Objects.hashCode(transmitMode());
        hashCode = 31 * hashCode + Objects.hashCode(receivedAt());
        hashCode = 31 * hashCode + Objects.hashCode(loRaWAN());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DownlinkQueueMessage)) {
            return false;
        }
        DownlinkQueueMessage other = (DownlinkQueueMessage) obj;
        return Objects.equals(messageId(), other.messageId()) && Objects.equals(transmitMode(), other.transmitMode())
                && Objects.equals(receivedAt(), other.receivedAt()) && Objects.equals(loRaWAN(), other.loRaWAN());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DownlinkQueueMessage").add("MessageId", messageId()).add("TransmitMode", transmitMode())
                .add("ReceivedAt", receivedAt()).add("LoRaWAN", loRaWAN()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MessageId":
            return Optional.ofNullable(clazz.cast(messageId()));
        case "TransmitMode":
            return Optional.ofNullable(clazz.cast(transmitMode()));
        case "ReceivedAt":
            return Optional.ofNullable(clazz.cast(receivedAt()));
        case "LoRaWAN":
            return Optional.ofNullable(clazz.cast(loRaWAN()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DownlinkQueueMessage, T> g) {
        return obj -> g.apply((DownlinkQueueMessage) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DownlinkQueueMessage> {
        /**
         * <p>
         * The message ID assigned by IoT Wireless to each downlink message, which helps identify the message.
         * </p>
         * 
         * @param messageId
         *        The message ID assigned by IoT Wireless to each downlink message, which helps identify the message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageId(String messageId);

        /**
         * <p>
         * The transmit mode to use for sending data to the wireless device. This can be <code>0</code> for UM
         * (unacknowledge mode) or <code>1</code> for AM (acknowledge mode).
         * </p>
         * 
         * @param transmitMode
         *        The transmit mode to use for sending data to the wireless device. This can be <code>0</code> for UM
         *        (unacknowledge mode) or <code>1</code> for AM (acknowledge mode).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transmitMode(Integer transmitMode);

        /**
         * <p>
         * The time at which Iot Wireless received the downlink message.
         * </p>
         * 
         * @param receivedAt
         *        The time at which Iot Wireless received the downlink message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder receivedAt(String receivedAt);

        /**
         * Sets the value of the LoRaWAN property for this object.
         *
         * @param loRaWAN
         *        The new value for the LoRaWAN property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loRaWAN(LoRaWANSendDataToDevice loRaWAN);

        /**
         * Sets the value of the LoRaWAN property for this object.
         *
         * This is a convenience method that creates an instance of the {@link LoRaWANSendDataToDevice.Builder} avoiding
         * the need to create one manually via {@link LoRaWANSendDataToDevice#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LoRaWANSendDataToDevice.Builder#build()} is called immediately
         * and its result is passed to {@link #loRaWAN(LoRaWANSendDataToDevice)}.
         * 
         * @param loRaWAN
         *        a consumer that will call methods on {@link LoRaWANSendDataToDevice.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loRaWAN(LoRaWANSendDataToDevice)
         */
        default Builder loRaWAN(Consumer<LoRaWANSendDataToDevice.Builder> loRaWAN) {
            return loRaWAN(LoRaWANSendDataToDevice.builder().applyMutation(loRaWAN).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String messageId;

        private Integer transmitMode;

        private String receivedAt;

        private LoRaWANSendDataToDevice loRaWAN;

        private BuilderImpl() {
        }

        private BuilderImpl(DownlinkQueueMessage model) {
            messageId(model.messageId);
            transmitMode(model.transmitMode);
            receivedAt(model.receivedAt);
            loRaWAN(model.loRaWAN);
        }

        public final String getMessageId() {
            return messageId;
        }

        public final void setMessageId(String messageId) {
            this.messageId = messageId;
        }

        @Override
        public final Builder messageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        public final Integer getTransmitMode() {
            return transmitMode;
        }

        public final void setTransmitMode(Integer transmitMode) {
            this.transmitMode = transmitMode;
        }

        @Override
        public final Builder transmitMode(Integer transmitMode) {
            this.transmitMode = transmitMode;
            return this;
        }

        public final String getReceivedAt() {
            return receivedAt;
        }

        public final void setReceivedAt(String receivedAt) {
            this.receivedAt = receivedAt;
        }

        @Override
        public final Builder receivedAt(String receivedAt) {
            this.receivedAt = receivedAt;
            return this;
        }

        public final LoRaWANSendDataToDevice.Builder getLoRaWAN() {
            return loRaWAN != null ? loRaWAN.toBuilder() : null;
        }

        public final void setLoRaWAN(LoRaWANSendDataToDevice.BuilderImpl loRaWAN) {
            this.loRaWAN = loRaWAN != null ? loRaWAN.build() : null;
        }

        @Override
        public final Builder loRaWAN(LoRaWANSendDataToDevice loRaWAN) {
            this.loRaWAN = loRaWAN;
            return this;
        }

        @Override
        public DownlinkQueueMessage build() {
            return new DownlinkQueueMessage(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
