/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the Semtech GNSS solver configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SemtechGnssConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<SemtechGnssConfiguration.Builder, SemtechGnssConfiguration> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(SemtechGnssConfiguration::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> FEC_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Fec")
            .getter(getter(SemtechGnssConfiguration::fecAsString)).setter(setter(Builder::fec))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Fec").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, FEC_FIELD));

    private static final long serialVersionUID = 1L;

    private final String status;

    private final String fec;

    private SemtechGnssConfiguration(BuilderImpl builder) {
        this.status = builder.status;
        this.fec = builder.fec;
    }

    /**
     * <p>
     * The status indicating whether the solver is enabled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link PositionConfigurationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status indicating whether the solver is enabled.
     * @see PositionConfigurationStatus
     */
    public final PositionConfigurationStatus status() {
        return PositionConfigurationStatus.fromValue(status);
    }

    /**
     * <p>
     * The status indicating whether the solver is enabled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link PositionConfigurationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status indicating whether the solver is enabled.
     * @see PositionConfigurationStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Whether forward error correction is enabled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fec} will return
     * {@link PositionConfigurationFec#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fecAsString}.
     * </p>
     * 
     * @return Whether forward error correction is enabled.
     * @see PositionConfigurationFec
     */
    public final PositionConfigurationFec fec() {
        return PositionConfigurationFec.fromValue(fec);
    }

    /**
     * <p>
     * Whether forward error correction is enabled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fec} will return
     * {@link PositionConfigurationFec#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fecAsString}.
     * </p>
     * 
     * @return Whether forward error correction is enabled.
     * @see PositionConfigurationFec
     */
    public final String fecAsString() {
        return fec;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(fecAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SemtechGnssConfiguration)) {
            return false;
        }
        SemtechGnssConfiguration other = (SemtechGnssConfiguration) obj;
        return Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(fecAsString(), other.fecAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SemtechGnssConfiguration").add("Status", statusAsString()).add("Fec", fecAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "Fec":
            return Optional.ofNullable(clazz.cast(fecAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SemtechGnssConfiguration, T> g) {
        return obj -> g.apply((SemtechGnssConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SemtechGnssConfiguration> {
        /**
         * <p>
         * The status indicating whether the solver is enabled.
         * </p>
         * 
         * @param status
         *        The status indicating whether the solver is enabled.
         * @see PositionConfigurationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PositionConfigurationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status indicating whether the solver is enabled.
         * </p>
         * 
         * @param status
         *        The status indicating whether the solver is enabled.
         * @see PositionConfigurationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PositionConfigurationStatus
         */
        Builder status(PositionConfigurationStatus status);

        /**
         * <p>
         * Whether forward error correction is enabled.
         * </p>
         * 
         * @param fec
         *        Whether forward error correction is enabled.
         * @see PositionConfigurationFec
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PositionConfigurationFec
         */
        Builder fec(String fec);

        /**
         * <p>
         * Whether forward error correction is enabled.
         * </p>
         * 
         * @param fec
         *        Whether forward error correction is enabled.
         * @see PositionConfigurationFec
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PositionConfigurationFec
         */
        Builder fec(PositionConfigurationFec fec);
    }

    static final class BuilderImpl implements Builder {
        private String status;

        private String fec;

        private BuilderImpl() {
        }

        private BuilderImpl(SemtechGnssConfiguration model) {
            status(model.status);
            fec(model.fec);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(PositionConfigurationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getFec() {
            return fec;
        }

        public final void setFec(String fec) {
            this.fec = fec;
        }

        @Override
        public final Builder fec(String fec) {
            this.fec = fec;
            return this;
        }

        @Override
        public final Builder fec(PositionConfigurationFec fec) {
            this.fec(fec == null ? null : fec.toString());
            return this;
        }

        @Override
        public SemtechGnssConfiguration build() {
            return new SemtechGnssConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
