/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotwireless.model.CdmaLocalId;
import software.amazon.awssdk.services.iotwireless.model.CdmaNmrListCopier;
import software.amazon.awssdk.services.iotwireless.model.CdmaNmrObj;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CdmaObj
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CdmaObj> {
    private static final SdkField<Integer> SYSTEM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SystemId").getter(CdmaObj.getter(CdmaObj::systemId)).setter(CdmaObj.setter(Builder::systemId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SystemId").build()}).build();
    private static final SdkField<Integer> NETWORK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NetworkId").getter(CdmaObj.getter(CdmaObj::networkId)).setter(CdmaObj.setter(Builder::networkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkId").build()}).build();
    private static final SdkField<Integer> BASE_STATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("BaseStationId").getter(CdmaObj.getter(CdmaObj::baseStationId)).setter(CdmaObj.setter(Builder::baseStationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaseStationId").build()}).build();
    private static final SdkField<Integer> REGISTRATION_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RegistrationZone").getter(CdmaObj.getter(CdmaObj::registrationZone)).setter(CdmaObj.setter(Builder::registrationZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistrationZone").build()}).build();
    private static final SdkField<CdmaLocalId> CDMA_LOCAL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CdmaLocalId").getter(CdmaObj.getter(CdmaObj::cdmaLocalId)).setter(CdmaObj.setter(Builder::cdmaLocalId)).constructor(CdmaLocalId::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CdmaLocalId").build()}).build();
    private static final SdkField<Integer> PILOT_POWER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PilotPower").getter(CdmaObj.getter(CdmaObj::pilotPower)).setter(CdmaObj.setter(Builder::pilotPower)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PilotPower").build()}).build();
    private static final SdkField<Float> BASE_LAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("BaseLat").getter(CdmaObj.getter(CdmaObj::baseLat)).setter(CdmaObj.setter(Builder::baseLat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaseLat").build()}).build();
    private static final SdkField<Float> BASE_LNG_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("BaseLng").getter(CdmaObj.getter(CdmaObj::baseLng)).setter(CdmaObj.setter(Builder::baseLng)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaseLng").build()}).build();
    private static final SdkField<List<CdmaNmrObj>> CDMA_NMR_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CdmaNmr").getter(CdmaObj.getter(CdmaObj::cdmaNmr)).setter(CdmaObj.setter(Builder::cdmaNmr)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CdmaNmr").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CdmaNmrObj::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SYSTEM_ID_FIELD, NETWORK_ID_FIELD, BASE_STATION_ID_FIELD, REGISTRATION_ZONE_FIELD, CDMA_LOCAL_ID_FIELD, PILOT_POWER_FIELD, BASE_LAT_FIELD, BASE_LNG_FIELD, CDMA_NMR_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CdmaObj.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer systemId;
    private final Integer networkId;
    private final Integer baseStationId;
    private final Integer registrationZone;
    private final CdmaLocalId cdmaLocalId;
    private final Integer pilotPower;
    private final Float baseLat;
    private final Float baseLng;
    private final List<CdmaNmrObj> cdmaNmr;

    private CdmaObj(BuilderImpl builder) {
        this.systemId = builder.systemId;
        this.networkId = builder.networkId;
        this.baseStationId = builder.baseStationId;
        this.registrationZone = builder.registrationZone;
        this.cdmaLocalId = builder.cdmaLocalId;
        this.pilotPower = builder.pilotPower;
        this.baseLat = builder.baseLat;
        this.baseLng = builder.baseLng;
        this.cdmaNmr = builder.cdmaNmr;
    }

    public final Integer systemId() {
        return this.systemId;
    }

    public final Integer networkId() {
        return this.networkId;
    }

    public final Integer baseStationId() {
        return this.baseStationId;
    }

    public final Integer registrationZone() {
        return this.registrationZone;
    }

    public final CdmaLocalId cdmaLocalId() {
        return this.cdmaLocalId;
    }

    public final Integer pilotPower() {
        return this.pilotPower;
    }

    public final Float baseLat() {
        return this.baseLat;
    }

    public final Float baseLng() {
        return this.baseLng;
    }

    public final boolean hasCdmaNmr() {
        return this.cdmaNmr != null && !(this.cdmaNmr instanceof SdkAutoConstructList);
    }

    public final List<CdmaNmrObj> cdmaNmr() {
        return this.cdmaNmr;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.systemId());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkId());
        hashCode = 31 * hashCode + Objects.hashCode(this.baseStationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.registrationZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.cdmaLocalId());
        hashCode = 31 * hashCode + Objects.hashCode(this.pilotPower());
        hashCode = 31 * hashCode + Objects.hashCode(this.baseLat());
        hashCode = 31 * hashCode + Objects.hashCode(this.baseLng());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCdmaNmr() ? this.cdmaNmr() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CdmaObj)) {
            return false;
        }
        CdmaObj other = (CdmaObj)obj;
        return Objects.equals(this.systemId(), other.systemId()) && Objects.equals(this.networkId(), other.networkId()) && Objects.equals(this.baseStationId(), other.baseStationId()) && Objects.equals(this.registrationZone(), other.registrationZone()) && Objects.equals(this.cdmaLocalId(), other.cdmaLocalId()) && Objects.equals(this.pilotPower(), other.pilotPower()) && Objects.equals(this.baseLat(), other.baseLat()) && Objects.equals(this.baseLng(), other.baseLng()) && this.hasCdmaNmr() == other.hasCdmaNmr() && Objects.equals(this.cdmaNmr(), other.cdmaNmr());
    }

    public final String toString() {
        return ToString.builder((String)"CdmaObj").add("SystemId", (Object)this.systemId()).add("NetworkId", (Object)this.networkId()).add("BaseStationId", (Object)this.baseStationId()).add("RegistrationZone", (Object)this.registrationZone()).add("CdmaLocalId", (Object)this.cdmaLocalId()).add("PilotPower", (Object)this.pilotPower()).add("BaseLat", (Object)this.baseLat()).add("BaseLng", (Object)this.baseLng()).add("CdmaNmr", this.hasCdmaNmr() ? this.cdmaNmr() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SystemId": {
                return Optional.ofNullable(clazz.cast(this.systemId()));
            }
            case "NetworkId": {
                return Optional.ofNullable(clazz.cast(this.networkId()));
            }
            case "BaseStationId": {
                return Optional.ofNullable(clazz.cast(this.baseStationId()));
            }
            case "RegistrationZone": {
                return Optional.ofNullable(clazz.cast(this.registrationZone()));
            }
            case "CdmaLocalId": {
                return Optional.ofNullable(clazz.cast(this.cdmaLocalId()));
            }
            case "PilotPower": {
                return Optional.ofNullable(clazz.cast(this.pilotPower()));
            }
            case "BaseLat": {
                return Optional.ofNullable(clazz.cast(this.baseLat()));
            }
            case "BaseLng": {
                return Optional.ofNullable(clazz.cast(this.baseLng()));
            }
            case "CdmaNmr": {
                return Optional.ofNullable(clazz.cast(this.cdmaNmr()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SystemId", SYSTEM_ID_FIELD);
        map.put("NetworkId", NETWORK_ID_FIELD);
        map.put("BaseStationId", BASE_STATION_ID_FIELD);
        map.put("RegistrationZone", REGISTRATION_ZONE_FIELD);
        map.put("CdmaLocalId", CDMA_LOCAL_ID_FIELD);
        map.put("PilotPower", PILOT_POWER_FIELD);
        map.put("BaseLat", BASE_LAT_FIELD);
        map.put("BaseLng", BASE_LNG_FIELD);
        map.put("CdmaNmr", CDMA_NMR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CdmaObj, T> g) {
        return obj -> g.apply((CdmaObj)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer systemId;
        private Integer networkId;
        private Integer baseStationId;
        private Integer registrationZone;
        private CdmaLocalId cdmaLocalId;
        private Integer pilotPower;
        private Float baseLat;
        private Float baseLng;
        private List<CdmaNmrObj> cdmaNmr = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CdmaObj model) {
            this.systemId(model.systemId);
            this.networkId(model.networkId);
            this.baseStationId(model.baseStationId);
            this.registrationZone(model.registrationZone);
            this.cdmaLocalId(model.cdmaLocalId);
            this.pilotPower(model.pilotPower);
            this.baseLat(model.baseLat);
            this.baseLng(model.baseLng);
            this.cdmaNmr(model.cdmaNmr);
        }

        public final Integer getSystemId() {
            return this.systemId;
        }

        public final void setSystemId(Integer systemId) {
            this.systemId = systemId;
        }

        @Override
        public final Builder systemId(Integer systemId) {
            this.systemId = systemId;
            return this;
        }

        public final Integer getNetworkId() {
            return this.networkId;
        }

        public final void setNetworkId(Integer networkId) {
            this.networkId = networkId;
        }

        @Override
        public final Builder networkId(Integer networkId) {
            this.networkId = networkId;
            return this;
        }

        public final Integer getBaseStationId() {
            return this.baseStationId;
        }

        public final void setBaseStationId(Integer baseStationId) {
            this.baseStationId = baseStationId;
        }

        @Override
        public final Builder baseStationId(Integer baseStationId) {
            this.baseStationId = baseStationId;
            return this;
        }

        public final Integer getRegistrationZone() {
            return this.registrationZone;
        }

        public final void setRegistrationZone(Integer registrationZone) {
            this.registrationZone = registrationZone;
        }

        @Override
        public final Builder registrationZone(Integer registrationZone) {
            this.registrationZone = registrationZone;
            return this;
        }

        public final CdmaLocalId.Builder getCdmaLocalId() {
            return this.cdmaLocalId != null ? this.cdmaLocalId.toBuilder() : null;
        }

        public final void setCdmaLocalId(CdmaLocalId.BuilderImpl cdmaLocalId) {
            this.cdmaLocalId = cdmaLocalId != null ? cdmaLocalId.build() : null;
        }

        @Override
        public final Builder cdmaLocalId(CdmaLocalId cdmaLocalId) {
            this.cdmaLocalId = cdmaLocalId;
            return this;
        }

        public final Integer getPilotPower() {
            return this.pilotPower;
        }

        public final void setPilotPower(Integer pilotPower) {
            this.pilotPower = pilotPower;
        }

        @Override
        public final Builder pilotPower(Integer pilotPower) {
            this.pilotPower = pilotPower;
            return this;
        }

        public final Float getBaseLat() {
            return this.baseLat;
        }

        public final void setBaseLat(Float baseLat) {
            this.baseLat = baseLat;
        }

        @Override
        public final Builder baseLat(Float baseLat) {
            this.baseLat = baseLat;
            return this;
        }

        public final Float getBaseLng() {
            return this.baseLng;
        }

        public final void setBaseLng(Float baseLng) {
            this.baseLng = baseLng;
        }

        @Override
        public final Builder baseLng(Float baseLng) {
            this.baseLng = baseLng;
            return this;
        }

        public final List<CdmaNmrObj.Builder> getCdmaNmr() {
            List<CdmaNmrObj.Builder> result = CdmaNmrListCopier.copyToBuilder(this.cdmaNmr);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCdmaNmr(Collection<CdmaNmrObj.BuilderImpl> cdmaNmr) {
            this.cdmaNmr = CdmaNmrListCopier.copyFromBuilder(cdmaNmr);
        }

        @Override
        public final Builder cdmaNmr(Collection<CdmaNmrObj> cdmaNmr) {
            this.cdmaNmr = CdmaNmrListCopier.copy(cdmaNmr);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cdmaNmr(CdmaNmrObj ... cdmaNmr) {
            this.cdmaNmr(Arrays.asList(cdmaNmr));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cdmaNmr(Consumer<CdmaNmrObj.Builder> ... cdmaNmr) {
            this.cdmaNmr(Stream.of(cdmaNmr).map(c -> (CdmaNmrObj)((CdmaNmrObj.Builder)CdmaNmrObj.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public CdmaObj build() {
            return new CdmaObj(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CdmaObj> {
        public Builder systemId(Integer var1);

        public Builder networkId(Integer var1);

        public Builder baseStationId(Integer var1);

        public Builder registrationZone(Integer var1);

        public Builder cdmaLocalId(CdmaLocalId var1);

        default public Builder cdmaLocalId(Consumer<CdmaLocalId.Builder> cdmaLocalId) {
            return this.cdmaLocalId((CdmaLocalId)((CdmaLocalId.Builder)CdmaLocalId.builder().applyMutation(cdmaLocalId)).build());
        }

        public Builder pilotPower(Integer var1);

        public Builder baseLat(Float var1);

        public Builder baseLng(Float var1);

        public Builder cdmaNmr(Collection<CdmaNmrObj> var1);

        public Builder cdmaNmr(CdmaNmrObj ... var1);

        public Builder cdmaNmr(Consumer<CdmaNmrObj.Builder> ... var1);
    }
}

