/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotwireless.model.GsmLocalId;
import software.amazon.awssdk.services.iotwireless.model.GsmNmrListCopier;
import software.amazon.awssdk.services.iotwireless.model.GsmNmrObj;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GsmObj
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GsmObj> {
    private static final SdkField<Integer> MCC_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Mcc").getter(GsmObj.getter(GsmObj::mcc)).setter(GsmObj.setter(Builder::mcc)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mcc").build()}).build();
    private static final SdkField<Integer> MNC_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Mnc").getter(GsmObj.getter(GsmObj::mnc)).setter(GsmObj.setter(Builder::mnc)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mnc").build()}).build();
    private static final SdkField<Integer> LAC_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Lac").getter(GsmObj.getter(GsmObj::lac)).setter(GsmObj.setter(Builder::lac)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Lac").build()}).build();
    private static final SdkField<Integer> GERAN_CID_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("GeranCid").getter(GsmObj.getter(GsmObj::geranCid)).setter(GsmObj.setter(Builder::geranCid)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeranCid").build()}).build();
    private static final SdkField<GsmLocalId> GSM_LOCAL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("GsmLocalId").getter(GsmObj.getter(GsmObj::gsmLocalId)).setter(GsmObj.setter(Builder::gsmLocalId)).constructor(GsmLocalId::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GsmLocalId").build()}).build();
    private static final SdkField<Integer> GSM_TIMING_ADVANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("GsmTimingAdvance").getter(GsmObj.getter(GsmObj::gsmTimingAdvance)).setter(GsmObj.setter(Builder::gsmTimingAdvance)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GsmTimingAdvance").build()}).build();
    private static final SdkField<Integer> RX_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RxLevel").getter(GsmObj.getter(GsmObj::rxLevel)).setter(GsmObj.setter(Builder::rxLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RxLevel").build()}).build();
    private static final SdkField<List<GsmNmrObj>> GSM_NMR_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GsmNmr").getter(GsmObj.getter(GsmObj::gsmNmr)).setter(GsmObj.setter(Builder::gsmNmr)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GsmNmr").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GsmNmrObj::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MCC_FIELD, MNC_FIELD, LAC_FIELD, GERAN_CID_FIELD, GSM_LOCAL_ID_FIELD, GSM_TIMING_ADVANCE_FIELD, RX_LEVEL_FIELD, GSM_NMR_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GsmObj.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer mcc;
    private final Integer mnc;
    private final Integer lac;
    private final Integer geranCid;
    private final GsmLocalId gsmLocalId;
    private final Integer gsmTimingAdvance;
    private final Integer rxLevel;
    private final List<GsmNmrObj> gsmNmr;

    private GsmObj(BuilderImpl builder) {
        this.mcc = builder.mcc;
        this.mnc = builder.mnc;
        this.lac = builder.lac;
        this.geranCid = builder.geranCid;
        this.gsmLocalId = builder.gsmLocalId;
        this.gsmTimingAdvance = builder.gsmTimingAdvance;
        this.rxLevel = builder.rxLevel;
        this.gsmNmr = builder.gsmNmr;
    }

    public final Integer mcc() {
        return this.mcc;
    }

    public final Integer mnc() {
        return this.mnc;
    }

    public final Integer lac() {
        return this.lac;
    }

    public final Integer geranCid() {
        return this.geranCid;
    }

    public final GsmLocalId gsmLocalId() {
        return this.gsmLocalId;
    }

    public final Integer gsmTimingAdvance() {
        return this.gsmTimingAdvance;
    }

    public final Integer rxLevel() {
        return this.rxLevel;
    }

    public final boolean hasGsmNmr() {
        return this.gsmNmr != null && !(this.gsmNmr instanceof SdkAutoConstructList);
    }

    public final List<GsmNmrObj> gsmNmr() {
        return this.gsmNmr;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.mcc());
        hashCode = 31 * hashCode + Objects.hashCode(this.mnc());
        hashCode = 31 * hashCode + Objects.hashCode(this.lac());
        hashCode = 31 * hashCode + Objects.hashCode(this.geranCid());
        hashCode = 31 * hashCode + Objects.hashCode(this.gsmLocalId());
        hashCode = 31 * hashCode + Objects.hashCode(this.gsmTimingAdvance());
        hashCode = 31 * hashCode + Objects.hashCode(this.rxLevel());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGsmNmr() ? this.gsmNmr() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GsmObj)) {
            return false;
        }
        GsmObj other = (GsmObj)obj;
        return Objects.equals(this.mcc(), other.mcc()) && Objects.equals(this.mnc(), other.mnc()) && Objects.equals(this.lac(), other.lac()) && Objects.equals(this.geranCid(), other.geranCid()) && Objects.equals(this.gsmLocalId(), other.gsmLocalId()) && Objects.equals(this.gsmTimingAdvance(), other.gsmTimingAdvance()) && Objects.equals(this.rxLevel(), other.rxLevel()) && this.hasGsmNmr() == other.hasGsmNmr() && Objects.equals(this.gsmNmr(), other.gsmNmr());
    }

    public final String toString() {
        return ToString.builder((String)"GsmObj").add("Mcc", (Object)this.mcc()).add("Mnc", (Object)this.mnc()).add("Lac", (Object)this.lac()).add("GeranCid", (Object)this.geranCid()).add("GsmLocalId", (Object)this.gsmLocalId()).add("GsmTimingAdvance", (Object)this.gsmTimingAdvance()).add("RxLevel", (Object)this.rxLevel()).add("GsmNmr", this.hasGsmNmr() ? this.gsmNmr() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Mcc": {
                return Optional.ofNullable(clazz.cast(this.mcc()));
            }
            case "Mnc": {
                return Optional.ofNullable(clazz.cast(this.mnc()));
            }
            case "Lac": {
                return Optional.ofNullable(clazz.cast(this.lac()));
            }
            case "GeranCid": {
                return Optional.ofNullable(clazz.cast(this.geranCid()));
            }
            case "GsmLocalId": {
                return Optional.ofNullable(clazz.cast(this.gsmLocalId()));
            }
            case "GsmTimingAdvance": {
                return Optional.ofNullable(clazz.cast(this.gsmTimingAdvance()));
            }
            case "RxLevel": {
                return Optional.ofNullable(clazz.cast(this.rxLevel()));
            }
            case "GsmNmr": {
                return Optional.ofNullable(clazz.cast(this.gsmNmr()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Mcc", MCC_FIELD);
        map.put("Mnc", MNC_FIELD);
        map.put("Lac", LAC_FIELD);
        map.put("GeranCid", GERAN_CID_FIELD);
        map.put("GsmLocalId", GSM_LOCAL_ID_FIELD);
        map.put("GsmTimingAdvance", GSM_TIMING_ADVANCE_FIELD);
        map.put("RxLevel", RX_LEVEL_FIELD);
        map.put("GsmNmr", GSM_NMR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GsmObj, T> g) {
        return obj -> g.apply((GsmObj)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer mcc;
        private Integer mnc;
        private Integer lac;
        private Integer geranCid;
        private GsmLocalId gsmLocalId;
        private Integer gsmTimingAdvance;
        private Integer rxLevel;
        private List<GsmNmrObj> gsmNmr = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GsmObj model) {
            this.mcc(model.mcc);
            this.mnc(model.mnc);
            this.lac(model.lac);
            this.geranCid(model.geranCid);
            this.gsmLocalId(model.gsmLocalId);
            this.gsmTimingAdvance(model.gsmTimingAdvance);
            this.rxLevel(model.rxLevel);
            this.gsmNmr(model.gsmNmr);
        }

        public final Integer getMcc() {
            return this.mcc;
        }

        public final void setMcc(Integer mcc) {
            this.mcc = mcc;
        }

        @Override
        public final Builder mcc(Integer mcc) {
            this.mcc = mcc;
            return this;
        }

        public final Integer getMnc() {
            return this.mnc;
        }

        public final void setMnc(Integer mnc) {
            this.mnc = mnc;
        }

        @Override
        public final Builder mnc(Integer mnc) {
            this.mnc = mnc;
            return this;
        }

        public final Integer getLac() {
            return this.lac;
        }

        public final void setLac(Integer lac) {
            this.lac = lac;
        }

        @Override
        public final Builder lac(Integer lac) {
            this.lac = lac;
            return this;
        }

        public final Integer getGeranCid() {
            return this.geranCid;
        }

        public final void setGeranCid(Integer geranCid) {
            this.geranCid = geranCid;
        }

        @Override
        public final Builder geranCid(Integer geranCid) {
            this.geranCid = geranCid;
            return this;
        }

        public final GsmLocalId.Builder getGsmLocalId() {
            return this.gsmLocalId != null ? this.gsmLocalId.toBuilder() : null;
        }

        public final void setGsmLocalId(GsmLocalId.BuilderImpl gsmLocalId) {
            this.gsmLocalId = gsmLocalId != null ? gsmLocalId.build() : null;
        }

        @Override
        public final Builder gsmLocalId(GsmLocalId gsmLocalId) {
            this.gsmLocalId = gsmLocalId;
            return this;
        }

        public final Integer getGsmTimingAdvance() {
            return this.gsmTimingAdvance;
        }

        public final void setGsmTimingAdvance(Integer gsmTimingAdvance) {
            this.gsmTimingAdvance = gsmTimingAdvance;
        }

        @Override
        public final Builder gsmTimingAdvance(Integer gsmTimingAdvance) {
            this.gsmTimingAdvance = gsmTimingAdvance;
            return this;
        }

        public final Integer getRxLevel() {
            return this.rxLevel;
        }

        public final void setRxLevel(Integer rxLevel) {
            this.rxLevel = rxLevel;
        }

        @Override
        public final Builder rxLevel(Integer rxLevel) {
            this.rxLevel = rxLevel;
            return this;
        }

        public final List<GsmNmrObj.Builder> getGsmNmr() {
            List<GsmNmrObj.Builder> result = GsmNmrListCopier.copyToBuilder(this.gsmNmr);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGsmNmr(Collection<GsmNmrObj.BuilderImpl> gsmNmr) {
            this.gsmNmr = GsmNmrListCopier.copyFromBuilder(gsmNmr);
        }

        @Override
        public final Builder gsmNmr(Collection<GsmNmrObj> gsmNmr) {
            this.gsmNmr = GsmNmrListCopier.copy(gsmNmr);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gsmNmr(GsmNmrObj ... gsmNmr) {
            this.gsmNmr(Arrays.asList(gsmNmr));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gsmNmr(Consumer<GsmNmrObj.Builder> ... gsmNmr) {
            this.gsmNmr(Stream.of(gsmNmr).map(c -> (GsmNmrObj)((GsmNmrObj.Builder)GsmNmrObj.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public GsmObj build() {
            return new GsmObj(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GsmObj> {
        public Builder mcc(Integer var1);

        public Builder mnc(Integer var1);

        public Builder lac(Integer var1);

        public Builder geranCid(Integer var1);

        public Builder gsmLocalId(GsmLocalId var1);

        default public Builder gsmLocalId(Consumer<GsmLocalId.Builder> gsmLocalId) {
            return this.gsmLocalId((GsmLocalId)((GsmLocalId.Builder)GsmLocalId.builder().applyMutation(gsmLocalId)).build());
        }

        public Builder gsmTimingAdvance(Integer var1);

        public Builder rxLevel(Integer var1);

        public Builder gsmNmr(Collection<GsmNmrObj> var1);

        public Builder gsmNmr(GsmNmrObj ... var1);

        public Builder gsmNmr(Consumer<GsmNmrObj.Builder> ... var1);
    }
}

