/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ivs.model.IvsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutMetadataRequest
extends IvsRequest
implements ToCopyableBuilder<Builder, PutMetadataRequest> {
    private static final SdkField<String> CHANNEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("channelArn").getter(PutMetadataRequest.getter(PutMetadataRequest::channelArn)).setter(PutMetadataRequest.setter(Builder::channelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelArn").build()}).build();
    private static final SdkField<String> METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("metadata").getter(PutMetadataRequest.getter(PutMetadataRequest::metadata)).setter(PutMetadataRequest.setter(Builder::metadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadata").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_ARN_FIELD, METADATA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PutMetadataRequest.memberNameToFieldInitializer();
    private final String channelArn;
    private final String metadata;

    private PutMetadataRequest(BuilderImpl builder) {
        super(builder);
        this.channelArn = builder.channelArn;
        this.metadata = builder.metadata;
    }

    public final String channelArn() {
        return this.channelArn;
    }

    public final String metadata() {
        return this.metadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.channelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.metadata());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutMetadataRequest)) {
            return false;
        }
        PutMetadataRequest other = (PutMetadataRequest)((Object)obj);
        return Objects.equals(this.channelArn(), other.channelArn()) && Objects.equals(this.metadata(), other.metadata());
    }

    public final String toString() {
        return ToString.builder((String)"PutMetadataRequest").add("ChannelArn", (Object)this.channelArn()).add("Metadata", (Object)(this.metadata() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "channelArn": {
                return Optional.ofNullable(clazz.cast(this.channelArn()));
            }
            case "metadata": {
                return Optional.ofNullable(clazz.cast(this.metadata()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("channelArn", CHANNEL_ARN_FIELD);
        map.put("metadata", METADATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutMetadataRequest, T> g) {
        return obj -> g.apply((PutMetadataRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IvsRequest.BuilderImpl
    implements Builder {
        private String channelArn;
        private String metadata;

        private BuilderImpl() {
        }

        private BuilderImpl(PutMetadataRequest model) {
            super(model);
            this.channelArn(model.channelArn);
            this.metadata(model.metadata);
        }

        public final String getChannelArn() {
            return this.channelArn;
        }

        public final void setChannelArn(String channelArn) {
            this.channelArn = channelArn;
        }

        @Override
        public final Builder channelArn(String channelArn) {
            this.channelArn = channelArn;
            return this;
        }

        public final String getMetadata() {
            return this.metadata;
        }

        public final void setMetadata(String metadata) {
            this.metadata = metadata;
        }

        @Override
        public final Builder metadata(String metadata) {
            this.metadata = metadata;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutMetadataRequest build() {
            return new PutMetadataRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IvsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutMetadataRequest> {
        public Builder channelArn(String var1);

        public Builder metadata(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

