/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivsrealtime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ivsrealtime.model.CompositionRecordingHlsConfiguration;
import software.amazon.awssdk.services.ivsrealtime.model.RecordingConfigurationFormat;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RecordingConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RecordingConfiguration> {
    private static final SdkField<CompositionRecordingHlsConfiguration> HLS_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("hlsConfiguration").getter(RecordingConfiguration.getter(RecordingConfiguration::hlsConfiguration)).setter(RecordingConfiguration.setter(Builder::hlsConfiguration)).constructor(CompositionRecordingHlsConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hlsConfiguration").build()}).build();
    private static final SdkField<String> FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("format").getter(RecordingConfiguration.getter(RecordingConfiguration::formatAsString)).setter(RecordingConfiguration.setter(Builder::format)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("format").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HLS_CONFIGURATION_FIELD, FORMAT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RecordingConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final CompositionRecordingHlsConfiguration hlsConfiguration;
    private final String format;

    private RecordingConfiguration(BuilderImpl builder) {
        this.hlsConfiguration = builder.hlsConfiguration;
        this.format = builder.format;
    }

    public final CompositionRecordingHlsConfiguration hlsConfiguration() {
        return this.hlsConfiguration;
    }

    public final RecordingConfigurationFormat format() {
        return RecordingConfigurationFormat.fromValue(this.format);
    }

    public final String formatAsString() {
        return this.format;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hlsConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.formatAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecordingConfiguration)) {
            return false;
        }
        RecordingConfiguration other = (RecordingConfiguration)obj;
        return Objects.equals(this.hlsConfiguration(), other.hlsConfiguration()) && Objects.equals(this.formatAsString(), other.formatAsString());
    }

    public final String toString() {
        return ToString.builder((String)"RecordingConfiguration").add("HlsConfiguration", (Object)this.hlsConfiguration()).add("Format", (Object)this.formatAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "hlsConfiguration": {
                return Optional.ofNullable(clazz.cast(this.hlsConfiguration()));
            }
            case "format": {
                return Optional.ofNullable(clazz.cast(this.formatAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("hlsConfiguration", HLS_CONFIGURATION_FIELD);
        map.put("format", FORMAT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RecordingConfiguration, T> g) {
        return obj -> g.apply((RecordingConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private CompositionRecordingHlsConfiguration hlsConfiguration;
        private String format;

        private BuilderImpl() {
        }

        private BuilderImpl(RecordingConfiguration model) {
            this.hlsConfiguration(model.hlsConfiguration);
            this.format(model.format);
        }

        public final CompositionRecordingHlsConfiguration.Builder getHlsConfiguration() {
            return this.hlsConfiguration != null ? this.hlsConfiguration.toBuilder() : null;
        }

        public final void setHlsConfiguration(CompositionRecordingHlsConfiguration.BuilderImpl hlsConfiguration) {
            this.hlsConfiguration = hlsConfiguration != null ? hlsConfiguration.build() : null;
        }

        @Override
        public final Builder hlsConfiguration(CompositionRecordingHlsConfiguration hlsConfiguration) {
            this.hlsConfiguration = hlsConfiguration;
            return this;
        }

        public final String getFormat() {
            return this.format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(RecordingConfigurationFormat format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public RecordingConfiguration build() {
            return new RecordingConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RecordingConfiguration> {
        public Builder hlsConfiguration(CompositionRecordingHlsConfiguration var1);

        default public Builder hlsConfiguration(Consumer<CompositionRecordingHlsConfiguration.Builder> hlsConfiguration) {
            return this.hlsConfiguration((CompositionRecordingHlsConfiguration)((CompositionRecordingHlsConfiguration.Builder)CompositionRecordingHlsConfiguration.builder().applyMutation(hlsConfiguration)).build());
        }

        public Builder format(String var1);

        public Builder format(RecordingConfigurationFormat var1);
    }
}

