/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivsrealtime.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ivsrealtime.IvsRealTimeClient;
import software.amazon.awssdk.services.ivsrealtime.internal.UserAgentUtils;
import software.amazon.awssdk.services.ivsrealtime.model.ListParticipantReplicasRequest;
import software.amazon.awssdk.services.ivsrealtime.model.ListParticipantReplicasResponse;
import software.amazon.awssdk.services.ivsrealtime.model.ParticipantReplica;

public class ListParticipantReplicasIterable
implements SdkIterable<ListParticipantReplicasResponse> {
    private final IvsRealTimeClient client;
    private final ListParticipantReplicasRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListParticipantReplicasIterable(IvsRealTimeClient client, ListParticipantReplicasRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListParticipantReplicasResponseFetcher();
    }

    public Iterator<ListParticipantReplicasResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ParticipantReplica> replicas() {
        Function<ListParticipantReplicasResponse, Iterator> getIterator = response -> {
            if (response != null && response.replicas() != null) {
                return response.replicas().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListParticipantReplicasResponseFetcher
    implements SyncPageFetcher<ListParticipantReplicasResponse> {
        private ListParticipantReplicasResponseFetcher() {
        }

        public boolean hasNextPage(ListParticipantReplicasResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListParticipantReplicasResponse nextPage(ListParticipantReplicasResponse previousPage) {
            if (previousPage == null) {
                return ListParticipantReplicasIterable.this.client.listParticipantReplicas(ListParticipantReplicasIterable.this.firstRequest);
            }
            return ListParticipantReplicasIterable.this.client.listParticipantReplicas((ListParticipantReplicasRequest)((Object)ListParticipantReplicasIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

