/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

/**
 *
 * <p>
 * Specifies which metrics are gathered for the MSK cluster. This property has the following possible values: DEFAULT,
 * PER_BROKER, PER_TOPIC_PER_BROKER, and PER_TOPIC_PER_PARTITION. For a list of the metrics associated with each of
 * these levels of monitoring, see <a
 * href="https://docs.aws.amazon.com/msk/latest/developerguide/monitoring.html">Monitoring</a>.
 * </p>
 * 
 */
@Generated("software.amazon.awssdk:codegen")
public enum EnhancedMonitoring {
    DEFAULT("DEFAULT"),

    PER_BROKER("PER_BROKER"),

    PER_TOPIC_PER_BROKER("PER_TOPIC_PER_BROKER"),

    PER_TOPIC_PER_PARTITION("PER_TOPIC_PER_PARTITION"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, EnhancedMonitoring> VALUE_MAP = EnumUtils.uniqueIndex(EnhancedMonitoring.class,
            EnhancedMonitoring::toString);

    private final String value;

    private EnhancedMonitoring(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return EnhancedMonitoring corresponding to the value
     */
    public static EnhancedMonitoring fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link EnhancedMonitoring}s
     */
    public static Set<EnhancedMonitoring> knownValues() {
        Set<EnhancedMonitoring> knownValues = EnumSet.allOf(EnhancedMonitoring.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
