/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListClustersV2Request extends KafkaRequest implements
        ToCopyableBuilder<ListClustersV2Request.Builder, ListClustersV2Request> {
    private static final SdkField<String> CLUSTER_NAME_FILTER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterNameFilter").getter(getter(ListClustersV2Request::clusterNameFilter))
            .setter(setter(Builder::clusterNameFilter))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("clusterNameFilter").build())
            .build();

    private static final SdkField<String> CLUSTER_TYPE_FILTER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterTypeFilter").getter(getter(ListClustersV2Request::clusterTypeFilter))
            .setter(setter(Builder::clusterTypeFilter))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("clusterTypeFilter").build())
            .build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListClustersV2Request::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListClustersV2Request::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_NAME_FILTER_FIELD,
            CLUSTER_TYPE_FILTER_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final String clusterNameFilter;

    private final String clusterTypeFilter;

    private final Integer maxResults;

    private final String nextToken;

    private ListClustersV2Request(BuilderImpl builder) {
        super(builder);
        this.clusterNameFilter = builder.clusterNameFilter;
        this.clusterTypeFilter = builder.clusterTypeFilter;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     *
     * <p>
     * Specify a prefix of the names of the clusters that you want to list. The service lists all the clusters whose
     * names start with this prefix.
     * </p>
     * 
     * @return <p>
     *         Specify a prefix of the names of the clusters that you want to list. The service lists all the clusters
     *         whose names start with this prefix.
     *         </p>
     */
    public final String clusterNameFilter() {
        return clusterNameFilter;
    }

    /**
     *
     * <p>
     * Specify either PROVISIONED or SERVERLESS.
     * </p>
     * 
     * @return <p>
     *         Specify either PROVISIONED or SERVERLESS.
     *         </p>
     */
    public final String clusterTypeFilter() {
        return clusterTypeFilter;
    }

    /**
     *
     * <p>
     * The maximum number of results to return in the response. If there are more results, the response includes a
     * NextToken parameter.
     * </p>
     * 
     * @return <p>
     *         The maximum number of results to return in the response. If there are more results, the response includes
     *         a NextToken parameter.
     *         </p>
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     *
     * <p>
     * The paginated results marker. When the result of the operation is truncated, the call returns NextToken in the
     * response. To get the next batch, provide this token in your next request.
     * </p>
     * 
     * @return <p>
     *         The paginated results marker. When the result of the operation is truncated, the call returns NextToken
     *         in the response. To get the next batch, provide this token in your next request.
     *         </p>
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterNameFilter());
        hashCode = 31 * hashCode + Objects.hashCode(clusterTypeFilter());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListClustersV2Request)) {
            return false;
        }
        ListClustersV2Request other = (ListClustersV2Request) obj;
        return Objects.equals(clusterNameFilter(), other.clusterNameFilter())
                && Objects.equals(clusterTypeFilter(), other.clusterTypeFilter())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListClustersV2Request").add("ClusterNameFilter", clusterNameFilter())
                .add("ClusterTypeFilter", clusterTypeFilter()).add("MaxResults", maxResults()).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterNameFilter":
            return Optional.ofNullable(clazz.cast(clusterNameFilter()));
        case "ClusterTypeFilter":
            return Optional.ofNullable(clazz.cast(clusterTypeFilter()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListClustersV2Request, T> g) {
        return obj -> g.apply((ListClustersV2Request) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KafkaRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListClustersV2Request> {
        /**
         *
         * <p>
         * Specify a prefix of the names of the clusters that you want to list. The service lists all the clusters whose
         * names start with this prefix.
         * </p>
         * 
         * @param clusterNameFilter
         *        <p>
         *        Specify a prefix of the names of the clusters that you want to list. The service lists all the
         *        clusters whose names start with this prefix.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterNameFilter(String clusterNameFilter);

        /**
         *
         * <p>
         * Specify either PROVISIONED or SERVERLESS.
         * </p>
         * 
         * @param clusterTypeFilter
         *        <p>
         *        Specify either PROVISIONED or SERVERLESS.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterTypeFilter(String clusterTypeFilter);

        /**
         *
         * <p>
         * The maximum number of results to return in the response. If there are more results, the response includes a
         * NextToken parameter.
         * </p>
         * 
         * @param maxResults
         *        <p>
         *        The maximum number of results to return in the response. If there are more results, the response
         *        includes a NextToken parameter.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         *
         * <p>
         * The paginated results marker. When the result of the operation is truncated, the call returns NextToken in
         * the response. To get the next batch, provide this token in your next request.
         * </p>
         * 
         * @param nextToken
         *        <p>
         *        The paginated results marker. When the result of the operation is truncated, the call returns
         *        NextToken in the response. To get the next batch, provide this token in your next request.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KafkaRequest.BuilderImpl implements Builder {
        private String clusterNameFilter;

        private String clusterTypeFilter;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListClustersV2Request model) {
            super(model);
            clusterNameFilter(model.clusterNameFilter);
            clusterTypeFilter(model.clusterTypeFilter);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getClusterNameFilter() {
            return clusterNameFilter;
        }

        public final void setClusterNameFilter(String clusterNameFilter) {
            this.clusterNameFilter = clusterNameFilter;
        }

        @Override
        public final Builder clusterNameFilter(String clusterNameFilter) {
            this.clusterNameFilter = clusterNameFilter;
            return this;
        }

        public final String getClusterTypeFilter() {
            return clusterTypeFilter;
        }

        public final void setClusterTypeFilter(String clusterTypeFilter) {
            this.clusterTypeFilter = clusterTypeFilter;
        }

        @Override
        public final Builder clusterTypeFilter(String clusterTypeFilter) {
            this.clusterTypeFilter = clusterTypeFilter;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListClustersV2Request build() {
            return new ListClustersV2Request(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
