/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 *
 * <p>
 * Information about cluster attributes that can be updated via update APIs.
 * </p>
 * 
 */
@Generated("software.amazon.awssdk:codegen")
public final class MutableClusterInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<MutableClusterInfo.Builder, MutableClusterInfo> {
    private static final SdkField<List<BrokerEBSVolumeInfo>> BROKER_EBS_VOLUME_INFO_FIELD = SdkField
            .<List<BrokerEBSVolumeInfo>> builder(MarshallingType.LIST)
            .memberName("BrokerEBSVolumeInfo")
            .getter(getter(MutableClusterInfo::brokerEBSVolumeInfo))
            .setter(setter(Builder::brokerEBSVolumeInfo))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("brokerEBSVolumeInfo").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BrokerEBSVolumeInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(BrokerEBSVolumeInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ConfigurationInfo> CONFIGURATION_INFO_FIELD = SdkField
            .<ConfigurationInfo> builder(MarshallingType.SDK_POJO).memberName("ConfigurationInfo")
            .getter(getter(MutableClusterInfo::configurationInfo)).setter(setter(Builder::configurationInfo))
            .constructor(ConfigurationInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurationInfo").build()).build();

    private static final SdkField<Integer> NUMBER_OF_BROKER_NODES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("NumberOfBrokerNodes").getter(getter(MutableClusterInfo::numberOfBrokerNodes))
            .setter(setter(Builder::numberOfBrokerNodes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfBrokerNodes").build())
            .build();

    private static final SdkField<String> ENHANCED_MONITORING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EnhancedMonitoring").getter(getter(MutableClusterInfo::enhancedMonitoringAsString))
            .setter(setter(Builder::enhancedMonitoring))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enhancedMonitoring").build())
            .build();

    private static final SdkField<OpenMonitoring> OPEN_MONITORING_FIELD = SdkField
            .<OpenMonitoring> builder(MarshallingType.SDK_POJO).memberName("OpenMonitoring")
            .getter(getter(MutableClusterInfo::openMonitoring)).setter(setter(Builder::openMonitoring))
            .constructor(OpenMonitoring::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("openMonitoring").build()).build();

    private static final SdkField<String> KAFKA_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KafkaVersion").getter(getter(MutableClusterInfo::kafkaVersion)).setter(setter(Builder::kafkaVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kafkaVersion").build()).build();

    private static final SdkField<LoggingInfo> LOGGING_INFO_FIELD = SdkField.<LoggingInfo> builder(MarshallingType.SDK_POJO)
            .memberName("LoggingInfo").getter(getter(MutableClusterInfo::loggingInfo)).setter(setter(Builder::loggingInfo))
            .constructor(LoggingInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loggingInfo").build()).build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceType").getter(getter(MutableClusterInfo::instanceType)).setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceType").build()).build();

    private static final SdkField<ClientAuthentication> CLIENT_AUTHENTICATION_FIELD = SdkField
            .<ClientAuthentication> builder(MarshallingType.SDK_POJO).memberName("ClientAuthentication")
            .getter(getter(MutableClusterInfo::clientAuthentication)).setter(setter(Builder::clientAuthentication))
            .constructor(ClientAuthentication::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientAuthentication").build())
            .build();

    private static final SdkField<EncryptionInfo> ENCRYPTION_INFO_FIELD = SdkField
            .<EncryptionInfo> builder(MarshallingType.SDK_POJO).memberName("EncryptionInfo")
            .getter(getter(MutableClusterInfo::encryptionInfo)).setter(setter(Builder::encryptionInfo))
            .constructor(EncryptionInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionInfo").build()).build();

    private static final SdkField<ConnectivityInfo> CONNECTIVITY_INFO_FIELD = SdkField
            .<ConnectivityInfo> builder(MarshallingType.SDK_POJO).memberName("ConnectivityInfo")
            .getter(getter(MutableClusterInfo::connectivityInfo)).setter(setter(Builder::connectivityInfo))
            .constructor(ConnectivityInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectivityInfo").build()).build();

    private static final SdkField<String> STORAGE_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StorageMode").getter(getter(MutableClusterInfo::storageModeAsString))
            .setter(setter(Builder::storageMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageMode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BROKER_EBS_VOLUME_INFO_FIELD,
            CONFIGURATION_INFO_FIELD, NUMBER_OF_BROKER_NODES_FIELD, ENHANCED_MONITORING_FIELD, OPEN_MONITORING_FIELD,
            KAFKA_VERSION_FIELD, LOGGING_INFO_FIELD, INSTANCE_TYPE_FIELD, CLIENT_AUTHENTICATION_FIELD, ENCRYPTION_INFO_FIELD,
            CONNECTIVITY_INFO_FIELD, STORAGE_MODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<BrokerEBSVolumeInfo> brokerEBSVolumeInfo;

    private final ConfigurationInfo configurationInfo;

    private final Integer numberOfBrokerNodes;

    private final String enhancedMonitoring;

    private final OpenMonitoring openMonitoring;

    private final String kafkaVersion;

    private final LoggingInfo loggingInfo;

    private final String instanceType;

    private final ClientAuthentication clientAuthentication;

    private final EncryptionInfo encryptionInfo;

    private final ConnectivityInfo connectivityInfo;

    private final String storageMode;

    private MutableClusterInfo(BuilderImpl builder) {
        this.brokerEBSVolumeInfo = builder.brokerEBSVolumeInfo;
        this.configurationInfo = builder.configurationInfo;
        this.numberOfBrokerNodes = builder.numberOfBrokerNodes;
        this.enhancedMonitoring = builder.enhancedMonitoring;
        this.openMonitoring = builder.openMonitoring;
        this.kafkaVersion = builder.kafkaVersion;
        this.loggingInfo = builder.loggingInfo;
        this.instanceType = builder.instanceType;
        this.clientAuthentication = builder.clientAuthentication;
        this.encryptionInfo = builder.encryptionInfo;
        this.connectivityInfo = builder.connectivityInfo;
        this.storageMode = builder.storageMode;
    }

    /**
     * For responses, this returns true if the service returned a value for the BrokerEBSVolumeInfo property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBrokerEBSVolumeInfo() {
        return brokerEBSVolumeInfo != null && !(brokerEBSVolumeInfo instanceof SdkAutoConstructList);
    }

    /**
     *
     * <p>
     * Specifies the size of the EBS volume and the ID of the associated broker.
     * </p>
     * 
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBrokerEBSVolumeInfo} method.
     * </p>
     * 
     * @return <p>
     *         Specifies the size of the EBS volume and the ID of the associated broker.
     *         </p>
     */
    public final List<BrokerEBSVolumeInfo> brokerEBSVolumeInfo() {
        return brokerEBSVolumeInfo;
    }

    /**
     *
     * <p>
     * Information about the changes in the configuration of the brokers.
     * </p>
     * 
     * @return <p>
     *         Information about the changes in the configuration of the brokers.
     *         </p>
     */
    public final ConfigurationInfo configurationInfo() {
        return configurationInfo;
    }

    /**
     *
     * <p>
     * The number of broker nodes in the cluster.
     * </p>
     * 
     * @return <p>
     *         The number of broker nodes in the cluster.
     *         </p>
     */
    public final Integer numberOfBrokerNodes() {
        return numberOfBrokerNodes;
    }

    /**
     *
     * <p>
     * Specifies which Apache Kafka metrics Amazon MSK gathers and sends to Amazon CloudWatch for this cluster.
     * </p>
     * 
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #enhancedMonitoring} will return {@link EnhancedMonitoring#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #enhancedMonitoringAsString}.
     * </p>
     * 
     * @return <p>
     *         Specifies which Apache Kafka metrics Amazon MSK gathers and sends to Amazon CloudWatch for this cluster.
     *         </p>
     * @see EnhancedMonitoring
     */
    public final EnhancedMonitoring enhancedMonitoring() {
        return EnhancedMonitoring.fromValue(enhancedMonitoring);
    }

    /**
     *
     * <p>
     * Specifies which Apache Kafka metrics Amazon MSK gathers and sends to Amazon CloudWatch for this cluster.
     * </p>
     * 
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #enhancedMonitoring} will return {@link EnhancedMonitoring#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #enhancedMonitoringAsString}.
     * </p>
     * 
     * @return <p>
     *         Specifies which Apache Kafka metrics Amazon MSK gathers and sends to Amazon CloudWatch for this cluster.
     *         </p>
     * @see EnhancedMonitoring
     */
    public final String enhancedMonitoringAsString() {
        return enhancedMonitoring;
    }

    /**
     *
     * <p>
     * The settings for open monitoring.
     * </p>
     * 
     * @return <p>
     *         The settings for open monitoring.
     *         </p>
     */
    public final OpenMonitoring openMonitoring() {
        return openMonitoring;
    }

    /**
     *
     * <p>
     * The Apache Kafka version.
     * </p>
     * 
     * @return <p>
     *         The Apache Kafka version.
     *         </p>
     */
    public final String kafkaVersion() {
        return kafkaVersion;
    }

    /**
     *
     * <p>
     * You can configure your MSK cluster to send broker logs to different destination types. This is a container for
     * the configuration details related to broker logs.
     * </p>
     * 
     * @return <p>
     *         You can configure your MSK cluster to send broker logs to different destination types. This is a
     *         container for the configuration details related to broker logs.
     *         </p>
     */
    public final LoggingInfo loggingInfo() {
        return loggingInfo;
    }

    /**
     *
     * <p>
     * Information about the Amazon MSK broker type.
     * </p>
     * 
     * @return <p>
     *         Information about the Amazon MSK broker type.
     *         </p>
     */
    public final String instanceType() {
        return instanceType;
    }

    /**
     *
     * <p>
     * Includes all client authentication information.
     * </p>
     * 
     * @return <p>
     *         Includes all client authentication information.
     *         </p>
     */
    public final ClientAuthentication clientAuthentication() {
        return clientAuthentication;
    }

    /**
     *
     * <p>
     * Includes all encryption-related information.
     * </p>
     * 
     * @return <p>
     *         Includes all encryption-related information.
     *         </p>
     */
    public final EncryptionInfo encryptionInfo() {
        return encryptionInfo;
    }

    /**
     *
     * <p>
     * Information about the broker access configuration.
     * </p>
     * 
     * @return <p>
     *         Information about the broker access configuration.
     *         </p>
     */
    public final ConnectivityInfo connectivityInfo() {
        return connectivityInfo;
    }

    /**
     *
     * <p>
     * This controls storage mode for supported storage tiers.
     * </p>
     * 
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #storageMode} will
     * return {@link StorageMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #storageModeAsString}.
     * </p>
     * 
     * @return <p>
     *         This controls storage mode for supported storage tiers.
     *         </p>
     * @see StorageMode
     */
    public final StorageMode storageMode() {
        return StorageMode.fromValue(storageMode);
    }

    /**
     *
     * <p>
     * This controls storage mode for supported storage tiers.
     * </p>
     * 
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #storageMode} will
     * return {@link StorageMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #storageModeAsString}.
     * </p>
     * 
     * @return <p>
     *         This controls storage mode for supported storage tiers.
     *         </p>
     * @see StorageMode
     */
    public final String storageModeAsString() {
        return storageMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasBrokerEBSVolumeInfo() ? brokerEBSVolumeInfo() : null);
        hashCode = 31 * hashCode + Objects.hashCode(configurationInfo());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfBrokerNodes());
        hashCode = 31 * hashCode + Objects.hashCode(enhancedMonitoringAsString());
        hashCode = 31 * hashCode + Objects.hashCode(openMonitoring());
        hashCode = 31 * hashCode + Objects.hashCode(kafkaVersion());
        hashCode = 31 * hashCode + Objects.hashCode(loggingInfo());
        hashCode = 31 * hashCode + Objects.hashCode(instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(clientAuthentication());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionInfo());
        hashCode = 31 * hashCode + Objects.hashCode(connectivityInfo());
        hashCode = 31 * hashCode + Objects.hashCode(storageModeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MutableClusterInfo)) {
            return false;
        }
        MutableClusterInfo other = (MutableClusterInfo) obj;
        return hasBrokerEBSVolumeInfo() == other.hasBrokerEBSVolumeInfo()
                && Objects.equals(brokerEBSVolumeInfo(), other.brokerEBSVolumeInfo())
                && Objects.equals(configurationInfo(), other.configurationInfo())
                && Objects.equals(numberOfBrokerNodes(), other.numberOfBrokerNodes())
                && Objects.equals(enhancedMonitoringAsString(), other.enhancedMonitoringAsString())
                && Objects.equals(openMonitoring(), other.openMonitoring())
                && Objects.equals(kafkaVersion(), other.kafkaVersion()) && Objects.equals(loggingInfo(), other.loggingInfo())
                && Objects.equals(instanceType(), other.instanceType())
                && Objects.equals(clientAuthentication(), other.clientAuthentication())
                && Objects.equals(encryptionInfo(), other.encryptionInfo())
                && Objects.equals(connectivityInfo(), other.connectivityInfo())
                && Objects.equals(storageModeAsString(), other.storageModeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MutableClusterInfo")
                .add("BrokerEBSVolumeInfo", hasBrokerEBSVolumeInfo() ? brokerEBSVolumeInfo() : null)
                .add("ConfigurationInfo", configurationInfo()).add("NumberOfBrokerNodes", numberOfBrokerNodes())
                .add("EnhancedMonitoring", enhancedMonitoringAsString()).add("OpenMonitoring", openMonitoring())
                .add("KafkaVersion", kafkaVersion()).add("LoggingInfo", loggingInfo()).add("InstanceType", instanceType())
                .add("ClientAuthentication", clientAuthentication()).add("EncryptionInfo", encryptionInfo())
                .add("ConnectivityInfo", connectivityInfo()).add("StorageMode", storageModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BrokerEBSVolumeInfo":
            return Optional.ofNullable(clazz.cast(brokerEBSVolumeInfo()));
        case "ConfigurationInfo":
            return Optional.ofNullable(clazz.cast(configurationInfo()));
        case "NumberOfBrokerNodes":
            return Optional.ofNullable(clazz.cast(numberOfBrokerNodes()));
        case "EnhancedMonitoring":
            return Optional.ofNullable(clazz.cast(enhancedMonitoringAsString()));
        case "OpenMonitoring":
            return Optional.ofNullable(clazz.cast(openMonitoring()));
        case "KafkaVersion":
            return Optional.ofNullable(clazz.cast(kafkaVersion()));
        case "LoggingInfo":
            return Optional.ofNullable(clazz.cast(loggingInfo()));
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceType()));
        case "ClientAuthentication":
            return Optional.ofNullable(clazz.cast(clientAuthentication()));
        case "EncryptionInfo":
            return Optional.ofNullable(clazz.cast(encryptionInfo()));
        case "ConnectivityInfo":
            return Optional.ofNullable(clazz.cast(connectivityInfo()));
        case "StorageMode":
            return Optional.ofNullable(clazz.cast(storageModeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MutableClusterInfo, T> g) {
        return obj -> g.apply((MutableClusterInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MutableClusterInfo> {
        /**
         *
         * <p>
         * Specifies the size of the EBS volume and the ID of the associated broker.
         * </p>
         * 
         * @param brokerEBSVolumeInfo
         *        <p>
         *        Specifies the size of the EBS volume and the ID of the associated broker.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder brokerEBSVolumeInfo(Collection<BrokerEBSVolumeInfo> brokerEBSVolumeInfo);

        /**
         *
         * <p>
         * Specifies the size of the EBS volume and the ID of the associated broker.
         * </p>
         * 
         * @param brokerEBSVolumeInfo
         *        <p>
         *        Specifies the size of the EBS volume and the ID of the associated broker.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder brokerEBSVolumeInfo(BrokerEBSVolumeInfo... brokerEBSVolumeInfo);

        /**
         *
         * <p>
         * Specifies the size of the EBS volume and the ID of the associated broker.
         * </p>
         * 
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.kafka.model.BrokerEBSVolumeInfo.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.kafka.model.BrokerEBSVolumeInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.kafka.model.BrokerEBSVolumeInfo.Builder#build()} is called immediately
         * and its result is passed to {@link #brokerEBSVolumeInfo(List<BrokerEBSVolumeInfo>)}.
         * 
         * @param brokerEBSVolumeInfo
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.kafka.model.BrokerEBSVolumeInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #brokerEBSVolumeInfo(java.util.Collection<BrokerEBSVolumeInfo>)
         */
        Builder brokerEBSVolumeInfo(Consumer<BrokerEBSVolumeInfo.Builder>... brokerEBSVolumeInfo);

        /**
         *
         * <p>
         * Information about the changes in the configuration of the brokers.
         * </p>
         * 
         * @param configurationInfo
         *        <p>
         *        Information about the changes in the configuration of the brokers.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationInfo(ConfigurationInfo configurationInfo);

        /**
         *
         * <p>
         * Information about the changes in the configuration of the brokers.
         * </p>
         * 
         * This is a convenience method that creates an instance of the {@link ConfigurationInfo.Builder} avoiding the
         * need to create one manually via {@link ConfigurationInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConfigurationInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #configurationInfo(ConfigurationInfo)}.
         * 
         * @param configurationInfo
         *        a consumer that will call methods on {@link ConfigurationInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configurationInfo(ConfigurationInfo)
         */
        default Builder configurationInfo(Consumer<ConfigurationInfo.Builder> configurationInfo) {
            return configurationInfo(ConfigurationInfo.builder().applyMutation(configurationInfo).build());
        }

        /**
         *
         * <p>
         * The number of broker nodes in the cluster.
         * </p>
         * 
         * @param numberOfBrokerNodes
         *        <p>
         *        The number of broker nodes in the cluster.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfBrokerNodes(Integer numberOfBrokerNodes);

        /**
         *
         * <p>
         * Specifies which Apache Kafka metrics Amazon MSK gathers and sends to Amazon CloudWatch for this cluster.
         * </p>
         * 
         * @param enhancedMonitoring
         *        <p>
         *        Specifies which Apache Kafka metrics Amazon MSK gathers and sends to Amazon CloudWatch for this
         *        cluster.
         *        </p>
         * @see EnhancedMonitoring
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnhancedMonitoring
         */
        Builder enhancedMonitoring(String enhancedMonitoring);

        /**
         *
         * <p>
         * Specifies which Apache Kafka metrics Amazon MSK gathers and sends to Amazon CloudWatch for this cluster.
         * </p>
         * 
         * @param enhancedMonitoring
         *        <p>
         *        Specifies which Apache Kafka metrics Amazon MSK gathers and sends to Amazon CloudWatch for this
         *        cluster.
         *        </p>
         * @see EnhancedMonitoring
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnhancedMonitoring
         */
        Builder enhancedMonitoring(EnhancedMonitoring enhancedMonitoring);

        /**
         *
         * <p>
         * The settings for open monitoring.
         * </p>
         * 
         * @param openMonitoring
         *        <p>
         *        The settings for open monitoring.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder openMonitoring(OpenMonitoring openMonitoring);

        /**
         *
         * <p>
         * The settings for open monitoring.
         * </p>
         * 
         * This is a convenience method that creates an instance of the {@link OpenMonitoring.Builder} avoiding the need
         * to create one manually via {@link OpenMonitoring#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OpenMonitoring.Builder#build()} is called immediately and its
         * result is passed to {@link #openMonitoring(OpenMonitoring)}.
         * 
         * @param openMonitoring
         *        a consumer that will call methods on {@link OpenMonitoring.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #openMonitoring(OpenMonitoring)
         */
        default Builder openMonitoring(Consumer<OpenMonitoring.Builder> openMonitoring) {
            return openMonitoring(OpenMonitoring.builder().applyMutation(openMonitoring).build());
        }

        /**
         *
         * <p>
         * The Apache Kafka version.
         * </p>
         * 
         * @param kafkaVersion
         *        <p>
         *        The Apache Kafka version.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kafkaVersion(String kafkaVersion);

        /**
         *
         * <p>
         * You can configure your MSK cluster to send broker logs to different destination types. This is a container
         * for the configuration details related to broker logs.
         * </p>
         * 
         * @param loggingInfo
         *        <p>
         *        You can configure your MSK cluster to send broker logs to different destination types. This is a
         *        container for the configuration details related to broker logs.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loggingInfo(LoggingInfo loggingInfo);

        /**
         *
         * <p>
         * You can configure your MSK cluster to send broker logs to different destination types. This is a container
         * for the configuration details related to broker logs.
         * </p>
         * 
         * This is a convenience method that creates an instance of the {@link LoggingInfo.Builder} avoiding the need to
         * create one manually via {@link LoggingInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LoggingInfo.Builder#build()} is called immediately and its result
         * is passed to {@link #loggingInfo(LoggingInfo)}.
         * 
         * @param loggingInfo
         *        a consumer that will call methods on {@link LoggingInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loggingInfo(LoggingInfo)
         */
        default Builder loggingInfo(Consumer<LoggingInfo.Builder> loggingInfo) {
            return loggingInfo(LoggingInfo.builder().applyMutation(loggingInfo).build());
        }

        /**
         *
         * <p>
         * Information about the Amazon MSK broker type.
         * </p>
         * 
         * @param instanceType
         *        <p>
         *        Information about the Amazon MSK broker type.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceType(String instanceType);

        /**
         *
         * <p>
         * Includes all client authentication information.
         * </p>
         * 
         * @param clientAuthentication
         *        <p>
         *        Includes all client authentication information.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientAuthentication(ClientAuthentication clientAuthentication);

        /**
         *
         * <p>
         * Includes all client authentication information.
         * </p>
         * 
         * This is a convenience method that creates an instance of the {@link ClientAuthentication.Builder} avoiding
         * the need to create one manually via {@link ClientAuthentication#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ClientAuthentication.Builder#build()} is called immediately and
         * its result is passed to {@link #clientAuthentication(ClientAuthentication)}.
         * 
         * @param clientAuthentication
         *        a consumer that will call methods on {@link ClientAuthentication.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clientAuthentication(ClientAuthentication)
         */
        default Builder clientAuthentication(Consumer<ClientAuthentication.Builder> clientAuthentication) {
            return clientAuthentication(ClientAuthentication.builder().applyMutation(clientAuthentication).build());
        }

        /**
         *
         * <p>
         * Includes all encryption-related information.
         * </p>
         * 
         * @param encryptionInfo
         *        <p>
         *        Includes all encryption-related information.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionInfo(EncryptionInfo encryptionInfo);

        /**
         *
         * <p>
         * Includes all encryption-related information.
         * </p>
         * 
         * This is a convenience method that creates an instance of the {@link EncryptionInfo.Builder} avoiding the need
         * to create one manually via {@link EncryptionInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EncryptionInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #encryptionInfo(EncryptionInfo)}.
         * 
         * @param encryptionInfo
         *        a consumer that will call methods on {@link EncryptionInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryptionInfo(EncryptionInfo)
         */
        default Builder encryptionInfo(Consumer<EncryptionInfo.Builder> encryptionInfo) {
            return encryptionInfo(EncryptionInfo.builder().applyMutation(encryptionInfo).build());
        }

        /**
         *
         * <p>
         * Information about the broker access configuration.
         * </p>
         * 
         * @param connectivityInfo
         *        <p>
         *        Information about the broker access configuration.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectivityInfo(ConnectivityInfo connectivityInfo);

        /**
         *
         * <p>
         * Information about the broker access configuration.
         * </p>
         * 
         * This is a convenience method that creates an instance of the {@link ConnectivityInfo.Builder} avoiding the
         * need to create one manually via {@link ConnectivityInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConnectivityInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #connectivityInfo(ConnectivityInfo)}.
         * 
         * @param connectivityInfo
         *        a consumer that will call methods on {@link ConnectivityInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #connectivityInfo(ConnectivityInfo)
         */
        default Builder connectivityInfo(Consumer<ConnectivityInfo.Builder> connectivityInfo) {
            return connectivityInfo(ConnectivityInfo.builder().applyMutation(connectivityInfo).build());
        }

        /**
         *
         * <p>
         * This controls storage mode for supported storage tiers.
         * </p>
         * 
         * @param storageMode
         *        <p>
         *        This controls storage mode for supported storage tiers.
         *        </p>
         * @see StorageMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StorageMode
         */
        Builder storageMode(String storageMode);

        /**
         *
         * <p>
         * This controls storage mode for supported storage tiers.
         * </p>
         * 
         * @param storageMode
         *        <p>
         *        This controls storage mode for supported storage tiers.
         *        </p>
         * @see StorageMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StorageMode
         */
        Builder storageMode(StorageMode storageMode);
    }

    static final class BuilderImpl implements Builder {
        private List<BrokerEBSVolumeInfo> brokerEBSVolumeInfo = DefaultSdkAutoConstructList.getInstance();

        private ConfigurationInfo configurationInfo;

        private Integer numberOfBrokerNodes;

        private String enhancedMonitoring;

        private OpenMonitoring openMonitoring;

        private String kafkaVersion;

        private LoggingInfo loggingInfo;

        private String instanceType;

        private ClientAuthentication clientAuthentication;

        private EncryptionInfo encryptionInfo;

        private ConnectivityInfo connectivityInfo;

        private String storageMode;

        private BuilderImpl() {
        }

        private BuilderImpl(MutableClusterInfo model) {
            brokerEBSVolumeInfo(model.brokerEBSVolumeInfo);
            configurationInfo(model.configurationInfo);
            numberOfBrokerNodes(model.numberOfBrokerNodes);
            enhancedMonitoring(model.enhancedMonitoring);
            openMonitoring(model.openMonitoring);
            kafkaVersion(model.kafkaVersion);
            loggingInfo(model.loggingInfo);
            instanceType(model.instanceType);
            clientAuthentication(model.clientAuthentication);
            encryptionInfo(model.encryptionInfo);
            connectivityInfo(model.connectivityInfo);
            storageMode(model.storageMode);
        }

        public final List<BrokerEBSVolumeInfo.Builder> getBrokerEBSVolumeInfo() {
            List<BrokerEBSVolumeInfo.Builder> result = ___listOfBrokerEBSVolumeInfoCopier.copyToBuilder(this.brokerEBSVolumeInfo);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBrokerEBSVolumeInfo(Collection<BrokerEBSVolumeInfo.BuilderImpl> brokerEBSVolumeInfo) {
            this.brokerEBSVolumeInfo = ___listOfBrokerEBSVolumeInfoCopier.copyFromBuilder(brokerEBSVolumeInfo);
        }

        @Override
        public final Builder brokerEBSVolumeInfo(Collection<BrokerEBSVolumeInfo> brokerEBSVolumeInfo) {
            this.brokerEBSVolumeInfo = ___listOfBrokerEBSVolumeInfoCopier.copy(brokerEBSVolumeInfo);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder brokerEBSVolumeInfo(BrokerEBSVolumeInfo... brokerEBSVolumeInfo) {
            brokerEBSVolumeInfo(Arrays.asList(brokerEBSVolumeInfo));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder brokerEBSVolumeInfo(Consumer<BrokerEBSVolumeInfo.Builder>... brokerEBSVolumeInfo) {
            brokerEBSVolumeInfo(Stream.of(brokerEBSVolumeInfo).map(c -> BrokerEBSVolumeInfo.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final ConfigurationInfo.Builder getConfigurationInfo() {
            return configurationInfo != null ? configurationInfo.toBuilder() : null;
        }

        public final void setConfigurationInfo(ConfigurationInfo.BuilderImpl configurationInfo) {
            this.configurationInfo = configurationInfo != null ? configurationInfo.build() : null;
        }

        @Override
        public final Builder configurationInfo(ConfigurationInfo configurationInfo) {
            this.configurationInfo = configurationInfo;
            return this;
        }

        public final Integer getNumberOfBrokerNodes() {
            return numberOfBrokerNodes;
        }

        public final void setNumberOfBrokerNodes(Integer numberOfBrokerNodes) {
            this.numberOfBrokerNodes = numberOfBrokerNodes;
        }

        @Override
        public final Builder numberOfBrokerNodes(Integer numberOfBrokerNodes) {
            this.numberOfBrokerNodes = numberOfBrokerNodes;
            return this;
        }

        public final String getEnhancedMonitoring() {
            return enhancedMonitoring;
        }

        public final void setEnhancedMonitoring(String enhancedMonitoring) {
            this.enhancedMonitoring = enhancedMonitoring;
        }

        @Override
        public final Builder enhancedMonitoring(String enhancedMonitoring) {
            this.enhancedMonitoring = enhancedMonitoring;
            return this;
        }

        @Override
        public final Builder enhancedMonitoring(EnhancedMonitoring enhancedMonitoring) {
            this.enhancedMonitoring(enhancedMonitoring == null ? null : enhancedMonitoring.toString());
            return this;
        }

        public final OpenMonitoring.Builder getOpenMonitoring() {
            return openMonitoring != null ? openMonitoring.toBuilder() : null;
        }

        public final void setOpenMonitoring(OpenMonitoring.BuilderImpl openMonitoring) {
            this.openMonitoring = openMonitoring != null ? openMonitoring.build() : null;
        }

        @Override
        public final Builder openMonitoring(OpenMonitoring openMonitoring) {
            this.openMonitoring = openMonitoring;
            return this;
        }

        public final String getKafkaVersion() {
            return kafkaVersion;
        }

        public final void setKafkaVersion(String kafkaVersion) {
            this.kafkaVersion = kafkaVersion;
        }

        @Override
        public final Builder kafkaVersion(String kafkaVersion) {
            this.kafkaVersion = kafkaVersion;
            return this;
        }

        public final LoggingInfo.Builder getLoggingInfo() {
            return loggingInfo != null ? loggingInfo.toBuilder() : null;
        }

        public final void setLoggingInfo(LoggingInfo.BuilderImpl loggingInfo) {
            this.loggingInfo = loggingInfo != null ? loggingInfo.build() : null;
        }

        @Override
        public final Builder loggingInfo(LoggingInfo loggingInfo) {
            this.loggingInfo = loggingInfo;
            return this;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final ClientAuthentication.Builder getClientAuthentication() {
            return clientAuthentication != null ? clientAuthentication.toBuilder() : null;
        }

        public final void setClientAuthentication(ClientAuthentication.BuilderImpl clientAuthentication) {
            this.clientAuthentication = clientAuthentication != null ? clientAuthentication.build() : null;
        }

        @Override
        public final Builder clientAuthentication(ClientAuthentication clientAuthentication) {
            this.clientAuthentication = clientAuthentication;
            return this;
        }

        public final EncryptionInfo.Builder getEncryptionInfo() {
            return encryptionInfo != null ? encryptionInfo.toBuilder() : null;
        }

        public final void setEncryptionInfo(EncryptionInfo.BuilderImpl encryptionInfo) {
            this.encryptionInfo = encryptionInfo != null ? encryptionInfo.build() : null;
        }

        @Override
        public final Builder encryptionInfo(EncryptionInfo encryptionInfo) {
            this.encryptionInfo = encryptionInfo;
            return this;
        }

        public final ConnectivityInfo.Builder getConnectivityInfo() {
            return connectivityInfo != null ? connectivityInfo.toBuilder() : null;
        }

        public final void setConnectivityInfo(ConnectivityInfo.BuilderImpl connectivityInfo) {
            this.connectivityInfo = connectivityInfo != null ? connectivityInfo.build() : null;
        }

        @Override
        public final Builder connectivityInfo(ConnectivityInfo connectivityInfo) {
            this.connectivityInfo = connectivityInfo;
            return this;
        }

        public final String getStorageMode() {
            return storageMode;
        }

        public final void setStorageMode(String storageMode) {
            this.storageMode = storageMode;
        }

        @Override
        public final Builder storageMode(String storageMode) {
            this.storageMode = storageMode;
            return this;
        }

        @Override
        public final Builder storageMode(StorageMode storageMode) {
            this.storageMode(storageMode == null ? null : storageMode.toString());
            return this;
        }

        @Override
        public MutableClusterInfo build() {
            return new MutableClusterInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
