/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafka.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.kafka.KafkaAsyncClient;
import software.amazon.awssdk.services.kafka.internal.UserAgentUtils;
import software.amazon.awssdk.services.kafka.model.DescribeTopicPartitionsRequest;
import software.amazon.awssdk.services.kafka.model.DescribeTopicPartitionsResponse;
import software.amazon.awssdk.services.kafka.model.TopicPartitionInfo;

public class DescribeTopicPartitionsPublisher
implements SdkPublisher<DescribeTopicPartitionsResponse> {
    private final KafkaAsyncClient client;
    private final DescribeTopicPartitionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeTopicPartitionsPublisher(KafkaAsyncClient client, DescribeTopicPartitionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeTopicPartitionsPublisher(KafkaAsyncClient client, DescribeTopicPartitionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeTopicPartitionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeTopicPartitionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<TopicPartitionInfo> partitions() {
        Function<DescribeTopicPartitionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.partitions() != null) {
                return response.partitions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeTopicPartitionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeTopicPartitionsResponseFetcher
    implements AsyncPageFetcher<DescribeTopicPartitionsResponse> {
        private DescribeTopicPartitionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeTopicPartitionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeTopicPartitionsResponse> nextPage(DescribeTopicPartitionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeTopicPartitionsPublisher.this.client.describeTopicPartitions(DescribeTopicPartitionsPublisher.this.firstRequest);
            }
            return DescribeTopicPartitionsPublisher.this.client.describeTopicPartitions((DescribeTopicPartitionsRequest)((Object)DescribeTopicPartitionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

