/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafkaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kafkaconnect.model.Vpc;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ApacheKafkaCluster
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ApacheKafkaCluster> {
    private static final SdkField<String> BOOTSTRAP_SERVERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("bootstrapServers").getter(ApacheKafkaCluster.getter(ApacheKafkaCluster::bootstrapServers)).setter(ApacheKafkaCluster.setter(Builder::bootstrapServers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bootstrapServers").build()}).build();
    private static final SdkField<Vpc> VPC_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("vpc").getter(ApacheKafkaCluster.getter(ApacheKafkaCluster::vpc)).setter(ApacheKafkaCluster.setter(Builder::vpc)).constructor(Vpc::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpc").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOOTSTRAP_SERVERS_FIELD, VPC_FIELD));
    private static final long serialVersionUID = 1L;
    private final String bootstrapServers;
    private final Vpc vpc;

    private ApacheKafkaCluster(BuilderImpl builder) {
        this.bootstrapServers = builder.bootstrapServers;
        this.vpc = builder.vpc;
    }

    public final String bootstrapServers() {
        return this.bootstrapServers;
    }

    public final Vpc vpc() {
        return this.vpc;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bootstrapServers());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpc());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApacheKafkaCluster)) {
            return false;
        }
        ApacheKafkaCluster other = (ApacheKafkaCluster)obj;
        return Objects.equals(this.bootstrapServers(), other.bootstrapServers()) && Objects.equals(this.vpc(), other.vpc());
    }

    public final String toString() {
        return ToString.builder((String)"ApacheKafkaCluster").add("BootstrapServers", (Object)this.bootstrapServers()).add("Vpc", (Object)this.vpc()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "bootstrapServers": {
                return Optional.ofNullable(clazz.cast(this.bootstrapServers()));
            }
            case "vpc": {
                return Optional.ofNullable(clazz.cast(this.vpc()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ApacheKafkaCluster, T> g) {
        return obj -> g.apply((ApacheKafkaCluster)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String bootstrapServers;
        private Vpc vpc;

        private BuilderImpl() {
        }

        private BuilderImpl(ApacheKafkaCluster model) {
            this.bootstrapServers(model.bootstrapServers);
            this.vpc(model.vpc);
        }

        public final String getBootstrapServers() {
            return this.bootstrapServers;
        }

        public final void setBootstrapServers(String bootstrapServers) {
            this.bootstrapServers = bootstrapServers;
        }

        @Override
        public final Builder bootstrapServers(String bootstrapServers) {
            this.bootstrapServers = bootstrapServers;
            return this;
        }

        public final Vpc.Builder getVpc() {
            return this.vpc != null ? this.vpc.toBuilder() : null;
        }

        public final void setVpc(Vpc.BuilderImpl vpc) {
            this.vpc = vpc != null ? vpc.build() : null;
        }

        @Override
        public final Builder vpc(Vpc vpc) {
            this.vpc = vpc;
            return this;
        }

        public ApacheKafkaCluster build() {
            return new ApacheKafkaCluster(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ApacheKafkaCluster> {
        public Builder bootstrapServers(String var1);

        public Builder vpc(Vpc var1);

        default public Builder vpc(Consumer<Vpc.Builder> vpc) {
            return this.vpc((Vpc)((Vpc.Builder)Vpc.builder().applyMutation(vpc)).build());
        }
    }
}

