/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafkaconnect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.kafkaconnect.KafkaConnectClient;
import software.amazon.awssdk.services.kafkaconnect.internal.UserAgentUtils;
import software.amazon.awssdk.services.kafkaconnect.model.ConnectorOperationSummary;
import software.amazon.awssdk.services.kafkaconnect.model.ListConnectorOperationsRequest;
import software.amazon.awssdk.services.kafkaconnect.model.ListConnectorOperationsResponse;

public class ListConnectorOperationsIterable
implements SdkIterable<ListConnectorOperationsResponse> {
    private final KafkaConnectClient client;
    private final ListConnectorOperationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListConnectorOperationsIterable(KafkaConnectClient client, ListConnectorOperationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListConnectorOperationsResponseFetcher();
    }

    public Iterator<ListConnectorOperationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ConnectorOperationSummary> connectorOperations() {
        Function<ListConnectorOperationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.connectorOperations() != null) {
                return response.connectorOperations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListConnectorOperationsResponseFetcher
    implements SyncPageFetcher<ListConnectorOperationsResponse> {
        private ListConnectorOperationsResponseFetcher() {
        }

        public boolean hasNextPage(ListConnectorOperationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListConnectorOperationsResponse nextPage(ListConnectorOperationsResponse previousPage) {
            if (previousPage == null) {
                return ListConnectorOperationsIterable.this.client.listConnectorOperations(ListConnectorOperationsIterable.this.firstRequest);
            }
            return ListConnectorOperationsIterable.this.client.listConnectorOperations((ListConnectorOperationsRequest)((Object)ListConnectorOperationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

