/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafkaconnect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.kafkaconnect.KafkaConnectAsyncClient;
import software.amazon.awssdk.services.kafkaconnect.internal.UserAgentUtils;
import software.amazon.awssdk.services.kafkaconnect.model.ConnectorOperationSummary;
import software.amazon.awssdk.services.kafkaconnect.model.ListConnectorOperationsRequest;
import software.amazon.awssdk.services.kafkaconnect.model.ListConnectorOperationsResponse;

public class ListConnectorOperationsPublisher
implements SdkPublisher<ListConnectorOperationsResponse> {
    private final KafkaConnectAsyncClient client;
    private final ListConnectorOperationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListConnectorOperationsPublisher(KafkaConnectAsyncClient client, ListConnectorOperationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListConnectorOperationsPublisher(KafkaConnectAsyncClient client, ListConnectorOperationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListConnectorOperationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListConnectorOperationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ConnectorOperationSummary> connectorOperations() {
        Function<ListConnectorOperationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.connectorOperations() != null) {
                return response.connectorOperations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListConnectorOperationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListConnectorOperationsResponseFetcher
    implements AsyncPageFetcher<ListConnectorOperationsResponse> {
        private ListConnectorOperationsResponseFetcher() {
        }

        public boolean hasNextPage(ListConnectorOperationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListConnectorOperationsResponse> nextPage(ListConnectorOperationsResponse previousPage) {
            if (previousPage == null) {
                return ListConnectorOperationsPublisher.this.client.listConnectorOperations(ListConnectorOperationsPublisher.this.firstRequest);
            }
            return ListConnectorOperationsPublisher.this.client.listConnectorOperations((ListConnectorOperationsRequest)((Object)ListConnectorOperationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

