/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchDeleteFeaturedResultsSetRequest extends KendraRequest implements
        ToCopyableBuilder<BatchDeleteFeaturedResultsSetRequest.Builder, BatchDeleteFeaturedResultsSetRequest> {
    private static final SdkField<String> INDEX_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IndexId").getter(getter(BatchDeleteFeaturedResultsSetRequest::indexId)).setter(setter(Builder::indexId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexId").build()).build();

    private static final SdkField<List<String>> FEATURED_RESULTS_SET_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("FeaturedResultsSetIds")
            .getter(getter(BatchDeleteFeaturedResultsSetRequest::featuredResultsSetIds))
            .setter(setter(Builder::featuredResultsSetIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeaturedResultsSetIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEX_ID_FIELD,
            FEATURED_RESULTS_SET_IDS_FIELD));

    private final String indexId;

    private final List<String> featuredResultsSetIds;

    private BatchDeleteFeaturedResultsSetRequest(BuilderImpl builder) {
        super(builder);
        this.indexId = builder.indexId;
        this.featuredResultsSetIds = builder.featuredResultsSetIds;
    }

    /**
     * <p>
     * The identifier of the index used for featuring results.
     * </p>
     * 
     * @return The identifier of the index used for featuring results.
     */
    public final String indexId() {
        return indexId;
    }

    /**
     * For responses, this returns true if the service returned a value for the FeaturedResultsSetIds property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasFeaturedResultsSetIds() {
        return featuredResultsSetIds != null && !(featuredResultsSetIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The identifiers of the featured results sets that you want to delete.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFeaturedResultsSetIds} method.
     * </p>
     * 
     * @return The identifiers of the featured results sets that you want to delete.
     */
    public final List<String> featuredResultsSetIds() {
        return featuredResultsSetIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(indexId());
        hashCode = 31 * hashCode + Objects.hashCode(hasFeaturedResultsSetIds() ? featuredResultsSetIds() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDeleteFeaturedResultsSetRequest)) {
            return false;
        }
        BatchDeleteFeaturedResultsSetRequest other = (BatchDeleteFeaturedResultsSetRequest) obj;
        return Objects.equals(indexId(), other.indexId()) && hasFeaturedResultsSetIds() == other.hasFeaturedResultsSetIds()
                && Objects.equals(featuredResultsSetIds(), other.featuredResultsSetIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchDeleteFeaturedResultsSetRequest").add("IndexId", indexId())
                .add("FeaturedResultsSetIds", hasFeaturedResultsSetIds() ? featuredResultsSetIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IndexId":
            return Optional.ofNullable(clazz.cast(indexId()));
        case "FeaturedResultsSetIds":
            return Optional.ofNullable(clazz.cast(featuredResultsSetIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchDeleteFeaturedResultsSetRequest, T> g) {
        return obj -> g.apply((BatchDeleteFeaturedResultsSetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KendraRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchDeleteFeaturedResultsSetRequest> {
        /**
         * <p>
         * The identifier of the index used for featuring results.
         * </p>
         * 
         * @param indexId
         *        The identifier of the index used for featuring results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexId(String indexId);

        /**
         * <p>
         * The identifiers of the featured results sets that you want to delete.
         * </p>
         * 
         * @param featuredResultsSetIds
         *        The identifiers of the featured results sets that you want to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder featuredResultsSetIds(Collection<String> featuredResultsSetIds);

        /**
         * <p>
         * The identifiers of the featured results sets that you want to delete.
         * </p>
         * 
         * @param featuredResultsSetIds
         *        The identifiers of the featured results sets that you want to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder featuredResultsSetIds(String... featuredResultsSetIds);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KendraRequest.BuilderImpl implements Builder {
        private String indexId;

        private List<String> featuredResultsSetIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDeleteFeaturedResultsSetRequest model) {
            super(model);
            indexId(model.indexId);
            featuredResultsSetIds(model.featuredResultsSetIds);
        }

        public final String getIndexId() {
            return indexId;
        }

        public final void setIndexId(String indexId) {
            this.indexId = indexId;
        }

        @Override
        public final Builder indexId(String indexId) {
            this.indexId = indexId;
            return this;
        }

        public final Collection<String> getFeaturedResultsSetIds() {
            if (featuredResultsSetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return featuredResultsSetIds;
        }

        public final void setFeaturedResultsSetIds(Collection<String> featuredResultsSetIds) {
            this.featuredResultsSetIds = FeaturedResultsSetIdListCopier.copy(featuredResultsSetIds);
        }

        @Override
        public final Builder featuredResultsSetIds(Collection<String> featuredResultsSetIds) {
            this.featuredResultsSetIds = FeaturedResultsSetIdListCopier.copy(featuredResultsSetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder featuredResultsSetIds(String... featuredResultsSetIds) {
            featuredResultsSetIds(Arrays.asList(featuredResultsSetIds));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchDeleteFeaturedResultsSetRequest build() {
            return new BatchDeleteFeaturedResultsSetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
