/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kendra.model.GroupOrderingIdSummariesCopier;
import software.amazon.awssdk.services.kendra.model.GroupOrderingIdSummary;
import software.amazon.awssdk.services.kendra.model.KendraResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribePrincipalMappingResponse
extends KendraResponse
implements ToCopyableBuilder<Builder, DescribePrincipalMappingResponse> {
    private static final SdkField<String> INDEX_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IndexId").getter(DescribePrincipalMappingResponse.getter(DescribePrincipalMappingResponse::indexId)).setter(DescribePrincipalMappingResponse.setter(Builder::indexId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexId").build()}).build();
    private static final SdkField<String> DATA_SOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataSourceId").getter(DescribePrincipalMappingResponse.getter(DescribePrincipalMappingResponse::dataSourceId)).setter(DescribePrincipalMappingResponse.setter(Builder::dataSourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSourceId").build()}).build();
    private static final SdkField<String> GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GroupId").getter(DescribePrincipalMappingResponse.getter(DescribePrincipalMappingResponse::groupId)).setter(DescribePrincipalMappingResponse.setter(Builder::groupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupId").build()}).build();
    private static final SdkField<List<GroupOrderingIdSummary>> GROUP_ORDERING_ID_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GroupOrderingIdSummaries").getter(DescribePrincipalMappingResponse.getter(DescribePrincipalMappingResponse::groupOrderingIdSummaries)).setter(DescribePrincipalMappingResponse.setter(Builder::groupOrderingIdSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupOrderingIdSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GroupOrderingIdSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEX_ID_FIELD, DATA_SOURCE_ID_FIELD, GROUP_ID_FIELD, GROUP_ORDERING_ID_SUMMARIES_FIELD));
    private final String indexId;
    private final String dataSourceId;
    private final String groupId;
    private final List<GroupOrderingIdSummary> groupOrderingIdSummaries;

    private DescribePrincipalMappingResponse(BuilderImpl builder) {
        super(builder);
        this.indexId = builder.indexId;
        this.dataSourceId = builder.dataSourceId;
        this.groupId = builder.groupId;
        this.groupOrderingIdSummaries = builder.groupOrderingIdSummaries;
    }

    public final String indexId() {
        return this.indexId;
    }

    public final String dataSourceId() {
        return this.dataSourceId;
    }

    public final String groupId() {
        return this.groupId;
    }

    public final boolean hasGroupOrderingIdSummaries() {
        return this.groupOrderingIdSummaries != null && !(this.groupOrderingIdSummaries instanceof SdkAutoConstructList);
    }

    public final List<GroupOrderingIdSummary> groupOrderingIdSummaries() {
        return this.groupOrderingIdSummaries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.indexId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGroupOrderingIdSummaries() ? this.groupOrderingIdSummaries() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePrincipalMappingResponse)) {
            return false;
        }
        DescribePrincipalMappingResponse other = (DescribePrincipalMappingResponse)((Object)obj);
        return Objects.equals(this.indexId(), other.indexId()) && Objects.equals(this.dataSourceId(), other.dataSourceId()) && Objects.equals(this.groupId(), other.groupId()) && this.hasGroupOrderingIdSummaries() == other.hasGroupOrderingIdSummaries() && Objects.equals(this.groupOrderingIdSummaries(), other.groupOrderingIdSummaries());
    }

    public final String toString() {
        return ToString.builder((String)"DescribePrincipalMappingResponse").add("IndexId", (Object)this.indexId()).add("DataSourceId", (Object)this.dataSourceId()).add("GroupId", (Object)this.groupId()).add("GroupOrderingIdSummaries", this.hasGroupOrderingIdSummaries() ? this.groupOrderingIdSummaries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IndexId": {
                return Optional.ofNullable(clazz.cast(this.indexId()));
            }
            case "DataSourceId": {
                return Optional.ofNullable(clazz.cast(this.dataSourceId()));
            }
            case "GroupId": {
                return Optional.ofNullable(clazz.cast(this.groupId()));
            }
            case "GroupOrderingIdSummaries": {
                return Optional.ofNullable(clazz.cast(this.groupOrderingIdSummaries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribePrincipalMappingResponse, T> g) {
        return obj -> g.apply((DescribePrincipalMappingResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KendraResponse.BuilderImpl
    implements Builder {
        private String indexId;
        private String dataSourceId;
        private String groupId;
        private List<GroupOrderingIdSummary> groupOrderingIdSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePrincipalMappingResponse model) {
            super(model);
            this.indexId(model.indexId);
            this.dataSourceId(model.dataSourceId);
            this.groupId(model.groupId);
            this.groupOrderingIdSummaries(model.groupOrderingIdSummaries);
        }

        public final String getIndexId() {
            return this.indexId;
        }

        public final void setIndexId(String indexId) {
            this.indexId = indexId;
        }

        @Override
        public final Builder indexId(String indexId) {
            this.indexId = indexId;
            return this;
        }

        public final String getDataSourceId() {
            return this.dataSourceId;
        }

        public final void setDataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
        }

        @Override
        public final Builder dataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
            return this;
        }

        public final String getGroupId() {
            return this.groupId;
        }

        public final void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        @Override
        public final Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public final List<GroupOrderingIdSummary.Builder> getGroupOrderingIdSummaries() {
            List<GroupOrderingIdSummary.Builder> result = GroupOrderingIdSummariesCopier.copyToBuilder(this.groupOrderingIdSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGroupOrderingIdSummaries(Collection<GroupOrderingIdSummary.BuilderImpl> groupOrderingIdSummaries) {
            this.groupOrderingIdSummaries = GroupOrderingIdSummariesCopier.copyFromBuilder(groupOrderingIdSummaries);
        }

        @Override
        public final Builder groupOrderingIdSummaries(Collection<GroupOrderingIdSummary> groupOrderingIdSummaries) {
            this.groupOrderingIdSummaries = GroupOrderingIdSummariesCopier.copy(groupOrderingIdSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupOrderingIdSummaries(GroupOrderingIdSummary ... groupOrderingIdSummaries) {
            this.groupOrderingIdSummaries(Arrays.asList(groupOrderingIdSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupOrderingIdSummaries(Consumer<GroupOrderingIdSummary.Builder> ... groupOrderingIdSummaries) {
            this.groupOrderingIdSummaries(Stream.of(groupOrderingIdSummaries).map(c -> (GroupOrderingIdSummary)((GroupOrderingIdSummary.Builder)GroupOrderingIdSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribePrincipalMappingResponse build() {
            return new DescribePrincipalMappingResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KendraResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribePrincipalMappingResponse> {
        public Builder indexId(String var1);

        public Builder dataSourceId(String var1);

        public Builder groupId(String var1);

        public Builder groupOrderingIdSummaries(Collection<GroupOrderingIdSummary> var1);

        public Builder groupOrderingIdSummaries(GroupOrderingIdSummary ... var1);

        public Builder groupOrderingIdSummaries(Consumer<GroupOrderingIdSummary.Builder> ... var1);
    }
}

