/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kendra.model.AdditionalResultAttribute;
import software.amazon.awssdk.services.kendra.model.AdditionalResultAttributeListCopier;
import software.amazon.awssdk.services.kendra.model.DocumentAttribute;
import software.amazon.awssdk.services.kendra.model.DocumentAttributeListCopier;
import software.amazon.awssdk.services.kendra.model.QueryResultType;
import software.amazon.awssdk.services.kendra.model.TextWithHighlights;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FeaturedResultsItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FeaturedResultsItem> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(FeaturedResultsItem.getter(FeaturedResultsItem::id)).setter(FeaturedResultsItem.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(FeaturedResultsItem.getter(FeaturedResultsItem::typeAsString)).setter(FeaturedResultsItem.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<List<AdditionalResultAttribute>> ADDITIONAL_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AdditionalAttributes").getter(FeaturedResultsItem.getter(FeaturedResultsItem::additionalAttributes)).setter(FeaturedResultsItem.setter(Builder::additionalAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalAttributes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AdditionalResultAttribute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DOCUMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DocumentId").getter(FeaturedResultsItem.getter(FeaturedResultsItem::documentId)).setter(FeaturedResultsItem.setter(Builder::documentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentId").build()}).build();
    private static final SdkField<TextWithHighlights> DOCUMENT_TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DocumentTitle").getter(FeaturedResultsItem.getter(FeaturedResultsItem::documentTitle)).setter(FeaturedResultsItem.setter(Builder::documentTitle)).constructor(TextWithHighlights::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentTitle").build()}).build();
    private static final SdkField<TextWithHighlights> DOCUMENT_EXCERPT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DocumentExcerpt").getter(FeaturedResultsItem.getter(FeaturedResultsItem::documentExcerpt)).setter(FeaturedResultsItem.setter(Builder::documentExcerpt)).constructor(TextWithHighlights::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentExcerpt").build()}).build();
    private static final SdkField<String> DOCUMENT_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DocumentURI").getter(FeaturedResultsItem.getter(FeaturedResultsItem::documentURI)).setter(FeaturedResultsItem.setter(Builder::documentURI)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentURI").build()}).build();
    private static final SdkField<List<DocumentAttribute>> DOCUMENT_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DocumentAttributes").getter(FeaturedResultsItem.getter(FeaturedResultsItem::documentAttributes)).setter(FeaturedResultsItem.setter(Builder::documentAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentAttributes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DocumentAttribute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> FEEDBACK_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FeedbackToken").getter(FeaturedResultsItem.getter(FeaturedResultsItem::feedbackToken)).setter(FeaturedResultsItem.setter(Builder::feedbackToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeedbackToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, TYPE_FIELD, ADDITIONAL_ATTRIBUTES_FIELD, DOCUMENT_ID_FIELD, DOCUMENT_TITLE_FIELD, DOCUMENT_EXCERPT_FIELD, DOCUMENT_URI_FIELD, DOCUMENT_ATTRIBUTES_FIELD, FEEDBACK_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FeaturedResultsItem.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String type;
    private final List<AdditionalResultAttribute> additionalAttributes;
    private final String documentId;
    private final TextWithHighlights documentTitle;
    private final TextWithHighlights documentExcerpt;
    private final String documentURI;
    private final List<DocumentAttribute> documentAttributes;
    private final String feedbackToken;

    private FeaturedResultsItem(BuilderImpl builder) {
        this.id = builder.id;
        this.type = builder.type;
        this.additionalAttributes = builder.additionalAttributes;
        this.documentId = builder.documentId;
        this.documentTitle = builder.documentTitle;
        this.documentExcerpt = builder.documentExcerpt;
        this.documentURI = builder.documentURI;
        this.documentAttributes = builder.documentAttributes;
        this.feedbackToken = builder.feedbackToken;
    }

    public final String id() {
        return this.id;
    }

    public final QueryResultType type() {
        return QueryResultType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final boolean hasAdditionalAttributes() {
        return this.additionalAttributes != null && !(this.additionalAttributes instanceof SdkAutoConstructList);
    }

    public final List<AdditionalResultAttribute> additionalAttributes() {
        return this.additionalAttributes;
    }

    public final String documentId() {
        return this.documentId;
    }

    public final TextWithHighlights documentTitle() {
        return this.documentTitle;
    }

    public final TextWithHighlights documentExcerpt() {
        return this.documentExcerpt;
    }

    public final String documentURI() {
        return this.documentURI;
    }

    public final boolean hasDocumentAttributes() {
        return this.documentAttributes != null && !(this.documentAttributes instanceof SdkAutoConstructList);
    }

    public final List<DocumentAttribute> documentAttributes() {
        return this.documentAttributes;
    }

    public final String feedbackToken() {
        return this.feedbackToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdditionalAttributes() ? this.additionalAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.documentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentTitle());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentExcerpt());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentURI());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDocumentAttributes() ? this.documentAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.feedbackToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FeaturedResultsItem)) {
            return false;
        }
        FeaturedResultsItem other = (FeaturedResultsItem)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.typeAsString(), other.typeAsString()) && this.hasAdditionalAttributes() == other.hasAdditionalAttributes() && Objects.equals(this.additionalAttributes(), other.additionalAttributes()) && Objects.equals(this.documentId(), other.documentId()) && Objects.equals(this.documentTitle(), other.documentTitle()) && Objects.equals(this.documentExcerpt(), other.documentExcerpt()) && Objects.equals(this.documentURI(), other.documentURI()) && this.hasDocumentAttributes() == other.hasDocumentAttributes() && Objects.equals(this.documentAttributes(), other.documentAttributes()) && Objects.equals(this.feedbackToken(), other.feedbackToken());
    }

    public final String toString() {
        return ToString.builder((String)"FeaturedResultsItem").add("Id", (Object)this.id()).add("Type", (Object)this.typeAsString()).add("AdditionalAttributes", this.hasAdditionalAttributes() ? this.additionalAttributes() : null).add("DocumentId", (Object)this.documentId()).add("DocumentTitle", (Object)this.documentTitle()).add("DocumentExcerpt", (Object)this.documentExcerpt()).add("DocumentURI", (Object)this.documentURI()).add("DocumentAttributes", this.hasDocumentAttributes() ? this.documentAttributes() : null).add("FeedbackToken", (Object)this.feedbackToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "AdditionalAttributes": {
                return Optional.ofNullable(clazz.cast(this.additionalAttributes()));
            }
            case "DocumentId": {
                return Optional.ofNullable(clazz.cast(this.documentId()));
            }
            case "DocumentTitle": {
                return Optional.ofNullable(clazz.cast(this.documentTitle()));
            }
            case "DocumentExcerpt": {
                return Optional.ofNullable(clazz.cast(this.documentExcerpt()));
            }
            case "DocumentURI": {
                return Optional.ofNullable(clazz.cast(this.documentURI()));
            }
            case "DocumentAttributes": {
                return Optional.ofNullable(clazz.cast(this.documentAttributes()));
            }
            case "FeedbackToken": {
                return Optional.ofNullable(clazz.cast(this.feedbackToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Id", ID_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("AdditionalAttributes", ADDITIONAL_ATTRIBUTES_FIELD);
        map.put("DocumentId", DOCUMENT_ID_FIELD);
        map.put("DocumentTitle", DOCUMENT_TITLE_FIELD);
        map.put("DocumentExcerpt", DOCUMENT_EXCERPT_FIELD);
        map.put("DocumentURI", DOCUMENT_URI_FIELD);
        map.put("DocumentAttributes", DOCUMENT_ATTRIBUTES_FIELD);
        map.put("FeedbackToken", FEEDBACK_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FeaturedResultsItem, T> g) {
        return obj -> g.apply((FeaturedResultsItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String type;
        private List<AdditionalResultAttribute> additionalAttributes = DefaultSdkAutoConstructList.getInstance();
        private String documentId;
        private TextWithHighlights documentTitle;
        private TextWithHighlights documentExcerpt;
        private String documentURI;
        private List<DocumentAttribute> documentAttributes = DefaultSdkAutoConstructList.getInstance();
        private String feedbackToken;

        private BuilderImpl() {
        }

        private BuilderImpl(FeaturedResultsItem model) {
            this.id(model.id);
            this.type(model.type);
            this.additionalAttributes(model.additionalAttributes);
            this.documentId(model.documentId);
            this.documentTitle(model.documentTitle);
            this.documentExcerpt(model.documentExcerpt);
            this.documentURI(model.documentURI);
            this.documentAttributes(model.documentAttributes);
            this.feedbackToken(model.feedbackToken);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(QueryResultType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final List<AdditionalResultAttribute.Builder> getAdditionalAttributes() {
            List<AdditionalResultAttribute.Builder> result = AdditionalResultAttributeListCopier.copyToBuilder(this.additionalAttributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAdditionalAttributes(Collection<AdditionalResultAttribute.BuilderImpl> additionalAttributes) {
            this.additionalAttributes = AdditionalResultAttributeListCopier.copyFromBuilder(additionalAttributes);
        }

        @Override
        public final Builder additionalAttributes(Collection<AdditionalResultAttribute> additionalAttributes) {
            this.additionalAttributes = AdditionalResultAttributeListCopier.copy(additionalAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalAttributes(AdditionalResultAttribute ... additionalAttributes) {
            this.additionalAttributes(Arrays.asList(additionalAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalAttributes(Consumer<AdditionalResultAttribute.Builder> ... additionalAttributes) {
            this.additionalAttributes(Stream.of(additionalAttributes).map(c -> (AdditionalResultAttribute)((AdditionalResultAttribute.Builder)AdditionalResultAttribute.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDocumentId() {
            return this.documentId;
        }

        public final void setDocumentId(String documentId) {
            this.documentId = documentId;
        }

        @Override
        public final Builder documentId(String documentId) {
            this.documentId = documentId;
            return this;
        }

        public final TextWithHighlights.Builder getDocumentTitle() {
            return this.documentTitle != null ? this.documentTitle.toBuilder() : null;
        }

        public final void setDocumentTitle(TextWithHighlights.BuilderImpl documentTitle) {
            this.documentTitle = documentTitle != null ? documentTitle.build() : null;
        }

        @Override
        public final Builder documentTitle(TextWithHighlights documentTitle) {
            this.documentTitle = documentTitle;
            return this;
        }

        public final TextWithHighlights.Builder getDocumentExcerpt() {
            return this.documentExcerpt != null ? this.documentExcerpt.toBuilder() : null;
        }

        public final void setDocumentExcerpt(TextWithHighlights.BuilderImpl documentExcerpt) {
            this.documentExcerpt = documentExcerpt != null ? documentExcerpt.build() : null;
        }

        @Override
        public final Builder documentExcerpt(TextWithHighlights documentExcerpt) {
            this.documentExcerpt = documentExcerpt;
            return this;
        }

        public final String getDocumentURI() {
            return this.documentURI;
        }

        public final void setDocumentURI(String documentURI) {
            this.documentURI = documentURI;
        }

        @Override
        public final Builder documentURI(String documentURI) {
            this.documentURI = documentURI;
            return this;
        }

        public final List<DocumentAttribute.Builder> getDocumentAttributes() {
            List<DocumentAttribute.Builder> result = DocumentAttributeListCopier.copyToBuilder(this.documentAttributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDocumentAttributes(Collection<DocumentAttribute.BuilderImpl> documentAttributes) {
            this.documentAttributes = DocumentAttributeListCopier.copyFromBuilder(documentAttributes);
        }

        @Override
        public final Builder documentAttributes(Collection<DocumentAttribute> documentAttributes) {
            this.documentAttributes = DocumentAttributeListCopier.copy(documentAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentAttributes(DocumentAttribute ... documentAttributes) {
            this.documentAttributes(Arrays.asList(documentAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentAttributes(Consumer<DocumentAttribute.Builder> ... documentAttributes) {
            this.documentAttributes(Stream.of(documentAttributes).map(c -> (DocumentAttribute)((DocumentAttribute.Builder)DocumentAttribute.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getFeedbackToken() {
            return this.feedbackToken;
        }

        public final void setFeedbackToken(String feedbackToken) {
            this.feedbackToken = feedbackToken;
        }

        @Override
        public final Builder feedbackToken(String feedbackToken) {
            this.feedbackToken = feedbackToken;
            return this;
        }

        public FeaturedResultsItem build() {
            return new FeaturedResultsItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FeaturedResultsItem> {
        public Builder id(String var1);

        public Builder type(String var1);

        public Builder type(QueryResultType var1);

        public Builder additionalAttributes(Collection<AdditionalResultAttribute> var1);

        public Builder additionalAttributes(AdditionalResultAttribute ... var1);

        public Builder additionalAttributes(Consumer<AdditionalResultAttribute.Builder> ... var1);

        public Builder documentId(String var1);

        public Builder documentTitle(TextWithHighlights var1);

        default public Builder documentTitle(Consumer<TextWithHighlights.Builder> documentTitle) {
            return this.documentTitle((TextWithHighlights)((TextWithHighlights.Builder)TextWithHighlights.builder().applyMutation(documentTitle)).build());
        }

        public Builder documentExcerpt(TextWithHighlights var1);

        default public Builder documentExcerpt(Consumer<TextWithHighlights.Builder> documentExcerpt) {
            return this.documentExcerpt((TextWithHighlights)((TextWithHighlights.Builder)TextWithHighlights.builder().applyMutation(documentExcerpt)).build());
        }

        public Builder documentURI(String var1);

        public Builder documentAttributes(Collection<DocumentAttribute> var1);

        public Builder documentAttributes(DocumentAttribute ... var1);

        public Builder documentAttributes(Consumer<DocumentAttribute.Builder> ... var1);

        public Builder feedbackToken(String var1);
    }
}

