/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendraranking;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.kendraranking.DefaultKendraRankingBaseClientBuilder;
import software.amazon.awssdk.services.kendraranking.DefaultKendraRankingClient;
import software.amazon.awssdk.services.kendraranking.KendraRankingClient;
import software.amazon.awssdk.services.kendraranking.KendraRankingClientBuilder;
import software.amazon.awssdk.services.kendraranking.KendraRankingServiceClientConfiguration;
import software.amazon.awssdk.services.kendraranking.endpoints.KendraRankingEndpointProvider;

@SdkInternalApi
final class DefaultKendraRankingClientBuilder
extends DefaultKendraRankingBaseClientBuilder<KendraRankingClientBuilder, KendraRankingClient>
implements KendraRankingClientBuilder {
    DefaultKendraRankingClientBuilder() {
    }

    @Override
    public DefaultKendraRankingClientBuilder endpointProvider(KendraRankingEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final KendraRankingClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultKendraRankingClientBuilder.validateClientOptions(clientConfiguration);
        KendraRankingServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultKendraRankingClient client = new DefaultKendraRankingClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private KendraRankingServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return KendraRankingServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

