/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.keyspaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The optional clustering column portion of your primary key determines how the data is clustered and sorted within
 * each partition.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ClusteringKey implements SdkPojo, Serializable, ToCopyableBuilder<ClusteringKey.Builder, ClusteringKey> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(ClusteringKey::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> ORDER_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("orderBy").getter(getter(ClusteringKey::orderByAsString)).setter(setter(Builder::orderBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("orderBy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ORDER_BY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String orderBy;

    private ClusteringKey(BuilderImpl builder) {
        this.name = builder.name;
        this.orderBy = builder.orderBy;
    }

    /**
     * <p>
     * The name(s) of the clustering column(s).
     * </p>
     * 
     * @return The name(s) of the clustering column(s).
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Sets the ascendant (<code>ASC</code>) or descendant (<code>DESC</code>) order modifier.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #orderBy} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #orderByAsString}.
     * </p>
     * 
     * @return Sets the ascendant (<code>ASC</code>) or descendant (<code>DESC</code>) order modifier.
     * @see SortOrder
     */
    public final SortOrder orderBy() {
        return SortOrder.fromValue(orderBy);
    }

    /**
     * <p>
     * Sets the ascendant (<code>ASC</code>) or descendant (<code>DESC</code>) order modifier.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #orderBy} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #orderByAsString}.
     * </p>
     * 
     * @return Sets the ascendant (<code>ASC</code>) or descendant (<code>DESC</code>) order modifier.
     * @see SortOrder
     */
    public final String orderByAsString() {
        return orderBy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(orderByAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusteringKey)) {
            return false;
        }
        ClusteringKey other = (ClusteringKey) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(orderByAsString(), other.orderByAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ClusteringKey").add("Name", name()).add("OrderBy", orderByAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "orderBy":
            return Optional.ofNullable(clazz.cast(orderByAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ClusteringKey, T> g) {
        return obj -> g.apply((ClusteringKey) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ClusteringKey> {
        /**
         * <p>
         * The name(s) of the clustering column(s).
         * </p>
         * 
         * @param name
         *        The name(s) of the clustering column(s).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Sets the ascendant (<code>ASC</code>) or descendant (<code>DESC</code>) order modifier.
         * </p>
         * 
         * @param orderBy
         *        Sets the ascendant (<code>ASC</code>) or descendant (<code>DESC</code>) order modifier.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder orderBy(String orderBy);

        /**
         * <p>
         * Sets the ascendant (<code>ASC</code>) or descendant (<code>DESC</code>) order modifier.
         * </p>
         * 
         * @param orderBy
         *        Sets the ascendant (<code>ASC</code>) or descendant (<code>DESC</code>) order modifier.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder orderBy(SortOrder orderBy);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String orderBy;

        private BuilderImpl() {
        }

        private BuilderImpl(ClusteringKey model) {
            name(model.name);
            orderBy(model.orderBy);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getOrderBy() {
            return orderBy;
        }

        public final void setOrderBy(String orderBy) {
            this.orderBy = orderBy;
        }

        @Override
        public final Builder orderBy(String orderBy) {
            this.orderBy = orderBy;
            return this;
        }

        @Override
        public final Builder orderBy(SortOrder orderBy) {
            this.orderBy(orderBy == null ? null : orderBy.toString());
            return this;
        }

        @Override
        public ClusteringKey build() {
            return new ClusteringKey(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
