/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.keyspaces.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CdcStatus {
    ENABLED("ENABLED"),
    ENABLING("ENABLING"),
    DISABLED("DISABLED"),
    DISABLING("DISABLING"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CdcStatus> VALUE_MAP;
    private final String value;

    private CdcStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CdcStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CdcStatus> knownValues() {
        EnumSet<CdcStatus> knownValues = EnumSet.allOf(CdcStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CdcStatus.class, CdcStatus::toString);
    }
}

