/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.keyspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.keyspaces.model.KeyspaceSummary;
import software.amazon.awssdk.services.keyspaces.model.KeyspaceSummaryListCopier;
import software.amazon.awssdk.services.keyspaces.model.KeyspacesResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListKeyspacesResponse
extends KeyspacesResponse
implements ToCopyableBuilder<Builder, ListKeyspacesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListKeyspacesResponse.getter(ListKeyspacesResponse::nextToken)).setter(ListKeyspacesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<KeyspaceSummary>> KEYSPACES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("keyspaces").getter(ListKeyspacesResponse.getter(ListKeyspacesResponse::keyspaces)).setter(ListKeyspacesResponse.setter(Builder::keyspaces)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyspaces").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(KeyspaceSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, KEYSPACES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListKeyspacesResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<KeyspaceSummary> keyspaces;

    private ListKeyspacesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.keyspaces = builder.keyspaces;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasKeyspaces() {
        return this.keyspaces != null && !(this.keyspaces instanceof SdkAutoConstructList);
    }

    public final List<KeyspaceSummary> keyspaces() {
        return this.keyspaces;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasKeyspaces() ? this.keyspaces() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListKeyspacesResponse)) {
            return false;
        }
        ListKeyspacesResponse other = (ListKeyspacesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasKeyspaces() == other.hasKeyspaces() && Objects.equals(this.keyspaces(), other.keyspaces());
    }

    public final String toString() {
        return ToString.builder((String)"ListKeyspacesResponse").add("NextToken", (Object)this.nextToken()).add("Keyspaces", this.hasKeyspaces() ? this.keyspaces() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "keyspaces": {
                return Optional.ofNullable(clazz.cast(this.keyspaces()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("keyspaces", KEYSPACES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListKeyspacesResponse, T> g) {
        return obj -> g.apply((ListKeyspacesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KeyspacesResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<KeyspaceSummary> keyspaces = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListKeyspacesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.keyspaces(model.keyspaces);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<KeyspaceSummary.Builder> getKeyspaces() {
            List<KeyspaceSummary.Builder> result = KeyspaceSummaryListCopier.copyToBuilder(this.keyspaces);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setKeyspaces(Collection<KeyspaceSummary.BuilderImpl> keyspaces) {
            this.keyspaces = KeyspaceSummaryListCopier.copyFromBuilder(keyspaces);
        }

        @Override
        public final Builder keyspaces(Collection<KeyspaceSummary> keyspaces) {
            this.keyspaces = KeyspaceSummaryListCopier.copy(keyspaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keyspaces(KeyspaceSummary ... keyspaces) {
            this.keyspaces(Arrays.asList(keyspaces));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keyspaces(Consumer<KeyspaceSummary.Builder> ... keyspaces) {
            this.keyspaces(Stream.of(keyspaces).map(c -> (KeyspaceSummary)((KeyspaceSummary.Builder)KeyspaceSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListKeyspacesResponse build() {
            return new ListKeyspacesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends KeyspacesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListKeyspacesResponse> {
        public Builder nextToken(String var1);

        public Builder keyspaces(Collection<KeyspaceSummary> var1);

        public Builder keyspaces(KeyspaceSummary ... var1);

        public Builder keyspaces(Consumer<KeyspaceSummary.Builder> ... var1);
    }
}

