/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.keyspaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.keyspaces.model.KeyspaceStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReplicationGroupStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReplicationGroupStatus> {
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("region").getter(ReplicationGroupStatus.getter(ReplicationGroupStatus::region)).setter(ReplicationGroupStatus.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("region").build()}).build();
    private static final SdkField<String> KEYSPACE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("keyspaceStatus").getter(ReplicationGroupStatus.getter(ReplicationGroupStatus::keyspaceStatusAsString)).setter(ReplicationGroupStatus.setter(Builder::keyspaceStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyspaceStatus").build()}).build();
    private static final SdkField<String> TABLES_REPLICATION_PROGRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("tablesReplicationProgress").getter(ReplicationGroupStatus.getter(ReplicationGroupStatus::tablesReplicationProgress)).setter(ReplicationGroupStatus.setter(Builder::tablesReplicationProgress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tablesReplicationProgress").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGION_FIELD, KEYSPACE_STATUS_FIELD, TABLES_REPLICATION_PROGRESS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ReplicationGroupStatus.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String region;
    private final String keyspaceStatus;
    private final String tablesReplicationProgress;

    private ReplicationGroupStatus(BuilderImpl builder) {
        this.region = builder.region;
        this.keyspaceStatus = builder.keyspaceStatus;
        this.tablesReplicationProgress = builder.tablesReplicationProgress;
    }

    public final String region() {
        return this.region;
    }

    public final KeyspaceStatus keyspaceStatus() {
        return KeyspaceStatus.fromValue(this.keyspaceStatus);
    }

    public final String keyspaceStatusAsString() {
        return this.keyspaceStatus;
    }

    public final String tablesReplicationProgress() {
        return this.tablesReplicationProgress;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyspaceStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.tablesReplicationProgress());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicationGroupStatus)) {
            return false;
        }
        ReplicationGroupStatus other = (ReplicationGroupStatus)obj;
        return Objects.equals(this.region(), other.region()) && Objects.equals(this.keyspaceStatusAsString(), other.keyspaceStatusAsString()) && Objects.equals(this.tablesReplicationProgress(), other.tablesReplicationProgress());
    }

    public final String toString() {
        return ToString.builder((String)"ReplicationGroupStatus").add("Region", (Object)this.region()).add("KeyspaceStatus", (Object)this.keyspaceStatusAsString()).add("TablesReplicationProgress", (Object)this.tablesReplicationProgress()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
            case "keyspaceStatus": {
                return Optional.ofNullable(clazz.cast(this.keyspaceStatusAsString()));
            }
            case "tablesReplicationProgress": {
                return Optional.ofNullable(clazz.cast(this.tablesReplicationProgress()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("region", REGION_FIELD);
        map.put("keyspaceStatus", KEYSPACE_STATUS_FIELD);
        map.put("tablesReplicationProgress", TABLES_REPLICATION_PROGRESS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReplicationGroupStatus, T> g) {
        return obj -> g.apply((ReplicationGroupStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String region;
        private String keyspaceStatus;
        private String tablesReplicationProgress;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicationGroupStatus model) {
            this.region(model.region);
            this.keyspaceStatus(model.keyspaceStatus);
            this.tablesReplicationProgress(model.tablesReplicationProgress);
        }

        public final String getRegion() {
            return this.region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final String getKeyspaceStatus() {
            return this.keyspaceStatus;
        }

        public final void setKeyspaceStatus(String keyspaceStatus) {
            this.keyspaceStatus = keyspaceStatus;
        }

        @Override
        public final Builder keyspaceStatus(String keyspaceStatus) {
            this.keyspaceStatus = keyspaceStatus;
            return this;
        }

        @Override
        public final Builder keyspaceStatus(KeyspaceStatus keyspaceStatus) {
            this.keyspaceStatus(keyspaceStatus == null ? null : keyspaceStatus.toString());
            return this;
        }

        public final String getTablesReplicationProgress() {
            return this.tablesReplicationProgress;
        }

        public final void setTablesReplicationProgress(String tablesReplicationProgress) {
            this.tablesReplicationProgress = tablesReplicationProgress;
        }

        @Override
        public final Builder tablesReplicationProgress(String tablesReplicationProgress) {
            this.tablesReplicationProgress = tablesReplicationProgress;
            return this;
        }

        public ReplicationGroupStatus build() {
            return new ReplicationGroupStatus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReplicationGroupStatus> {
        public Builder region(String var1);

        public Builder keyspaceStatus(String var1);

        public Builder keyspaceStatus(KeyspaceStatus var1);

        public Builder tablesReplicationProgress(String var1);
    }
}

