/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ApplicationMode {
    STREAMING("STREAMING"),
    INTERACTIVE("INTERACTIVE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ApplicationMode> VALUE_MAP;
    private final String value;

    private ApplicationMode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ApplicationMode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ApplicationMode> knownValues() {
        EnumSet<ApplicationMode> knownValues = EnumSet.allOf(ApplicationMode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ApplicationMode.class, ApplicationMode::toString);
    }
}

