/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationOperationInfo;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationOperationInfoListCopier;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.KinesisAnalyticsV2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListApplicationOperationsResponse
extends KinesisAnalyticsV2Response
implements ToCopyableBuilder<Builder, ListApplicationOperationsResponse> {
    private static final SdkField<List<ApplicationOperationInfo>> APPLICATION_OPERATION_INFO_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ApplicationOperationInfoList").getter(ListApplicationOperationsResponse.getter(ListApplicationOperationsResponse::applicationOperationInfoList)).setter(ListApplicationOperationsResponse.setter(Builder::applicationOperationInfoList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationOperationInfoList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ApplicationOperationInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListApplicationOperationsResponse.getter(ListApplicationOperationsResponse::nextToken)).setter(ListApplicationOperationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_OPERATION_INFO_LIST_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListApplicationOperationsResponse.memberNameToFieldInitializer();
    private final List<ApplicationOperationInfo> applicationOperationInfoList;
    private final String nextToken;

    private ListApplicationOperationsResponse(BuilderImpl builder) {
        super(builder);
        this.applicationOperationInfoList = builder.applicationOperationInfoList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasApplicationOperationInfoList() {
        return this.applicationOperationInfoList != null && !(this.applicationOperationInfoList instanceof SdkAutoConstructList);
    }

    public final List<ApplicationOperationInfo> applicationOperationInfoList() {
        return this.applicationOperationInfoList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasApplicationOperationInfoList() ? this.applicationOperationInfoList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListApplicationOperationsResponse)) {
            return false;
        }
        ListApplicationOperationsResponse other = (ListApplicationOperationsResponse)((Object)obj);
        return this.hasApplicationOperationInfoList() == other.hasApplicationOperationInfoList() && Objects.equals(this.applicationOperationInfoList(), other.applicationOperationInfoList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListApplicationOperationsResponse").add("ApplicationOperationInfoList", this.hasApplicationOperationInfoList() ? this.applicationOperationInfoList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationOperationInfoList": {
                return Optional.ofNullable(clazz.cast(this.applicationOperationInfoList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ApplicationOperationInfoList", APPLICATION_OPERATION_INFO_LIST_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListApplicationOperationsResponse, T> g) {
        return obj -> g.apply((ListApplicationOperationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KinesisAnalyticsV2Response.BuilderImpl
    implements Builder {
        private List<ApplicationOperationInfo> applicationOperationInfoList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListApplicationOperationsResponse model) {
            super(model);
            this.applicationOperationInfoList(model.applicationOperationInfoList);
            this.nextToken(model.nextToken);
        }

        public final List<ApplicationOperationInfo.Builder> getApplicationOperationInfoList() {
            List<ApplicationOperationInfo.Builder> result = ApplicationOperationInfoListCopier.copyToBuilder(this.applicationOperationInfoList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setApplicationOperationInfoList(Collection<ApplicationOperationInfo.BuilderImpl> applicationOperationInfoList) {
            this.applicationOperationInfoList = ApplicationOperationInfoListCopier.copyFromBuilder(applicationOperationInfoList);
        }

        @Override
        public final Builder applicationOperationInfoList(Collection<ApplicationOperationInfo> applicationOperationInfoList) {
            this.applicationOperationInfoList = ApplicationOperationInfoListCopier.copy(applicationOperationInfoList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicationOperationInfoList(ApplicationOperationInfo ... applicationOperationInfoList) {
            this.applicationOperationInfoList(Arrays.asList(applicationOperationInfoList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicationOperationInfoList(Consumer<ApplicationOperationInfo.Builder> ... applicationOperationInfoList) {
            this.applicationOperationInfoList(Stream.of(applicationOperationInfoList).map(c -> (ApplicationOperationInfo)((ApplicationOperationInfo.Builder)ApplicationOperationInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListApplicationOperationsResponse build() {
            return new ListApplicationOperationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends KinesisAnalyticsV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListApplicationOperationsResponse> {
        public Builder applicationOperationInfoList(Collection<ApplicationOperationInfo> var1);

        public Builder applicationOperationInfoList(ApplicationOperationInfo ... var1);

        public Builder applicationOperationInfoList(Consumer<ApplicationOperationInfo.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

