/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisvideo.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that encapsulates, or contains, the media storage configuration properties.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MediaStorageConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<MediaStorageConfiguration.Builder, MediaStorageConfiguration> {
    private static final SdkField<String> STREAM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreamARN").getter(getter(MediaStorageConfiguration::streamARN)).setter(setter(Builder::streamARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamARN").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(MediaStorageConfiguration::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(STREAM_ARN_FIELD, STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String streamARN;

    private final String status;

    private MediaStorageConfiguration(BuilderImpl builder) {
        this.streamARN = builder.streamARN;
        this.status = builder.status;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the stream
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the stream
     */
    public final String streamARN() {
        return streamARN;
    }

    /**
     * <p>
     * The status of the media storage configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link MediaStorageConfigurationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the media storage configuration.
     * @see MediaStorageConfigurationStatus
     */
    public final MediaStorageConfigurationStatus status() {
        return MediaStorageConfigurationStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the media storage configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link MediaStorageConfigurationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the media storage configuration.
     * @see MediaStorageConfigurationStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(streamARN());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MediaStorageConfiguration)) {
            return false;
        }
        MediaStorageConfiguration other = (MediaStorageConfiguration) obj;
        return Objects.equals(streamARN(), other.streamARN()) && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MediaStorageConfiguration").add("StreamARN", streamARN()).add("Status", statusAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StreamARN":
            return Optional.ofNullable(clazz.cast(streamARN()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MediaStorageConfiguration, T> g) {
        return obj -> g.apply((MediaStorageConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MediaStorageConfiguration> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the stream
         * </p>
         * 
         * @param streamARN
         *        The Amazon Resource Name (ARN) of the stream
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamARN(String streamARN);

        /**
         * <p>
         * The status of the media storage configuration.
         * </p>
         * 
         * @param status
         *        The status of the media storage configuration.
         * @see MediaStorageConfigurationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MediaStorageConfigurationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the media storage configuration.
         * </p>
         * 
         * @param status
         *        The status of the media storage configuration.
         * @see MediaStorageConfigurationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MediaStorageConfigurationStatus
         */
        Builder status(MediaStorageConfigurationStatus status);
    }

    static final class BuilderImpl implements Builder {
        private String streamARN;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(MediaStorageConfiguration model) {
            streamARN(model.streamARN);
            status(model.status);
        }

        public final String getStreamARN() {
            return streamARN;
        }

        public final void setStreamARN(String streamARN) {
            this.streamARN = streamARN;
        }

        @Override
        public final Builder streamARN(String streamARN) {
            this.streamARN = streamARN;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(MediaStorageConfigurationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public MediaStorageConfiguration build() {
            return new MediaStorageConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
