/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisvideoarchivedmedia.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.Fragment;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.FragmentListCopier;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.KinesisVideoArchivedMediaResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListFragmentsResponse
extends KinesisVideoArchivedMediaResponse
implements ToCopyableBuilder<Builder, ListFragmentsResponse> {
    private static final SdkField<List<Fragment>> FRAGMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Fragments").getter(ListFragmentsResponse.getter(ListFragmentsResponse::fragments)).setter(ListFragmentsResponse.setter(Builder::fragments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Fragments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Fragment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListFragmentsResponse.getter(ListFragmentsResponse::nextToken)).setter(ListFragmentsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FRAGMENTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListFragmentsResponse.memberNameToFieldInitializer();
    private final List<Fragment> fragments;
    private final String nextToken;

    private ListFragmentsResponse(BuilderImpl builder) {
        super(builder);
        this.fragments = builder.fragments;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasFragments() {
        return this.fragments != null && !(this.fragments instanceof SdkAutoConstructList);
    }

    public final List<Fragment> fragments() {
        return this.fragments;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFragments() ? this.fragments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFragmentsResponse)) {
            return false;
        }
        ListFragmentsResponse other = (ListFragmentsResponse)((Object)obj);
        return this.hasFragments() == other.hasFragments() && Objects.equals(this.fragments(), other.fragments()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListFragmentsResponse").add("Fragments", this.hasFragments() ? this.fragments() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Fragments": {
                return Optional.ofNullable(clazz.cast(this.fragments()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Fragments", FRAGMENTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListFragmentsResponse, T> g) {
        return obj -> g.apply((ListFragmentsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KinesisVideoArchivedMediaResponse.BuilderImpl
    implements Builder {
        private List<Fragment> fragments = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFragmentsResponse model) {
            super(model);
            this.fragments(model.fragments);
            this.nextToken(model.nextToken);
        }

        public final List<Fragment.Builder> getFragments() {
            List<Fragment.Builder> result = FragmentListCopier.copyToBuilder(this.fragments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFragments(Collection<Fragment.BuilderImpl> fragments) {
            this.fragments = FragmentListCopier.copyFromBuilder(fragments);
        }

        @Override
        public final Builder fragments(Collection<Fragment> fragments) {
            this.fragments = FragmentListCopier.copy(fragments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fragments(Fragment ... fragments) {
            this.fragments(Arrays.asList(fragments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fragments(Consumer<Fragment.Builder> ... fragments) {
            this.fragments(Stream.of(fragments).map(c -> (Fragment)((Fragment.Builder)Fragment.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListFragmentsResponse build() {
            return new ListFragmentsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends KinesisVideoArchivedMediaResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListFragmentsResponse> {
        public Builder fragments(Collection<Fragment> var1);

        public Builder fragments(Fragment ... var1);

        public Builder fragments(Consumer<Fragment.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

