/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.launchwizard.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.launchwizard.model.AllowedValuesCopier;
import software.amazon.awssdk.services.launchwizard.model.DeploymentConditionalField;
import software.amazon.awssdk.services.launchwizard.model.SpecificationsConditionalDataCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeploymentSpecificationsField
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DeploymentSpecificationsField> {
    private static final SdkField<List<String>> ALLOWED_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("allowedValues").getter(DeploymentSpecificationsField.getter(DeploymentSpecificationsField::allowedValues)).setter(DeploymentSpecificationsField.setter(Builder::allowedValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowedValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<DeploymentConditionalField>> CONDITIONALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("conditionals").getter(DeploymentSpecificationsField.getter(DeploymentSpecificationsField::conditionals)).setter(DeploymentSpecificationsField.setter(Builder::conditionals)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conditionals").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DeploymentConditionalField::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(DeploymentSpecificationsField.getter(DeploymentSpecificationsField::description)).setter(DeploymentSpecificationsField.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(DeploymentSpecificationsField.getter(DeploymentSpecificationsField::name)).setter(DeploymentSpecificationsField.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> REQUIRED_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("required").getter(DeploymentSpecificationsField.getter(DeploymentSpecificationsField::required)).setter(DeploymentSpecificationsField.setter(Builder::required)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("required").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOWED_VALUES_FIELD, CONDITIONALS_FIELD, DESCRIPTION_FIELD, NAME_FIELD, REQUIRED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeploymentSpecificationsField.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> allowedValues;
    private final List<DeploymentConditionalField> conditionals;
    private final String description;
    private final String name;
    private final String required;

    private DeploymentSpecificationsField(BuilderImpl builder) {
        this.allowedValues = builder.allowedValues;
        this.conditionals = builder.conditionals;
        this.description = builder.description;
        this.name = builder.name;
        this.required = builder.required;
    }

    public final boolean hasAllowedValues() {
        return this.allowedValues != null && !(this.allowedValues instanceof SdkAutoConstructList);
    }

    public final List<String> allowedValues() {
        return this.allowedValues;
    }

    public final boolean hasConditionals() {
        return this.conditionals != null && !(this.conditionals instanceof SdkAutoConstructList);
    }

    public final List<DeploymentConditionalField> conditionals() {
        return this.conditionals;
    }

    public final String description() {
        return this.description;
    }

    public final String name() {
        return this.name;
    }

    public final String required() {
        return this.required;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAllowedValues() ? this.allowedValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConditionals() ? this.conditionals() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.required());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeploymentSpecificationsField)) {
            return false;
        }
        DeploymentSpecificationsField other = (DeploymentSpecificationsField)obj;
        return this.hasAllowedValues() == other.hasAllowedValues() && Objects.equals(this.allowedValues(), other.allowedValues()) && this.hasConditionals() == other.hasConditionals() && Objects.equals(this.conditionals(), other.conditionals()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.required(), other.required());
    }

    public final String toString() {
        return ToString.builder((String)"DeploymentSpecificationsField").add("AllowedValues", this.hasAllowedValues() ? this.allowedValues() : null).add("Conditionals", this.hasConditionals() ? this.conditionals() : null).add("Description", (Object)this.description()).add("Name", (Object)this.name()).add("Required", (Object)this.required()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "allowedValues": {
                return Optional.ofNullable(clazz.cast(this.allowedValues()));
            }
            case "conditionals": {
                return Optional.ofNullable(clazz.cast(this.conditionals()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "required": {
                return Optional.ofNullable(clazz.cast(this.required()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("allowedValues", ALLOWED_VALUES_FIELD);
        map.put("conditionals", CONDITIONALS_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("name", NAME_FIELD);
        map.put("required", REQUIRED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeploymentSpecificationsField, T> g) {
        return obj -> g.apply((DeploymentSpecificationsField)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> allowedValues = DefaultSdkAutoConstructList.getInstance();
        private List<DeploymentConditionalField> conditionals = DefaultSdkAutoConstructList.getInstance();
        private String description;
        private String name;
        private String required;

        private BuilderImpl() {
        }

        private BuilderImpl(DeploymentSpecificationsField model) {
            this.allowedValues(model.allowedValues);
            this.conditionals(model.conditionals);
            this.description(model.description);
            this.name(model.name);
            this.required(model.required);
        }

        public final Collection<String> getAllowedValues() {
            if (this.allowedValues instanceof SdkAutoConstructList) {
                return null;
            }
            return this.allowedValues;
        }

        public final void setAllowedValues(Collection<String> allowedValues) {
            this.allowedValues = AllowedValuesCopier.copy(allowedValues);
        }

        @Override
        public final Builder allowedValues(Collection<String> allowedValues) {
            this.allowedValues = AllowedValuesCopier.copy(allowedValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedValues(String ... allowedValues) {
            this.allowedValues(Arrays.asList(allowedValues));
            return this;
        }

        public final List<DeploymentConditionalField.Builder> getConditionals() {
            List<DeploymentConditionalField.Builder> result = SpecificationsConditionalDataCopier.copyToBuilder(this.conditionals);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConditionals(Collection<DeploymentConditionalField.BuilderImpl> conditionals) {
            this.conditionals = SpecificationsConditionalDataCopier.copyFromBuilder(conditionals);
        }

        @Override
        public final Builder conditionals(Collection<DeploymentConditionalField> conditionals) {
            this.conditionals = SpecificationsConditionalDataCopier.copy(conditionals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conditionals(DeploymentConditionalField ... conditionals) {
            this.conditionals(Arrays.asList(conditionals));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conditionals(Consumer<DeploymentConditionalField.Builder> ... conditionals) {
            this.conditionals(Stream.of(conditionals).map(c -> (DeploymentConditionalField)((DeploymentConditionalField.Builder)DeploymentConditionalField.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRequired() {
            return this.required;
        }

        public final void setRequired(String required) {
            this.required = required;
        }

        @Override
        public final Builder required(String required) {
            this.required = required;
            return this;
        }

        public DeploymentSpecificationsField build() {
            return new DeploymentSpecificationsField(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DeploymentSpecificationsField> {
        public Builder allowedValues(Collection<String> var1);

        public Builder allowedValues(String ... var1);

        public Builder conditionals(Collection<DeploymentConditionalField> var1);

        public Builder conditionals(DeploymentConditionalField ... var1);

        public Builder conditionals(Consumer<DeploymentConditionalField.Builder> ... var1);

        public Builder description(String var1);

        public Builder name(String var1);

        public Builder required(String var1);
    }
}

