/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.launchwizard.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.launchwizard.model.DeploymentData;
import software.amazon.awssdk.services.launchwizard.model.LaunchWizardResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDeploymentResponse
extends LaunchWizardResponse
implements ToCopyableBuilder<Builder, GetDeploymentResponse> {
    private static final SdkField<DeploymentData> DEPLOYMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("deployment").getter(GetDeploymentResponse.getter(GetDeploymentResponse::deployment)).setter(GetDeploymentResponse.setter(Builder::deployment)).constructor(DeploymentData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deployment").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPLOYMENT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetDeploymentResponse.memberNameToFieldInitializer();
    private final DeploymentData deployment;

    private GetDeploymentResponse(BuilderImpl builder) {
        super(builder);
        this.deployment = builder.deployment;
    }

    public final DeploymentData deployment() {
        return this.deployment;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.deployment());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDeploymentResponse)) {
            return false;
        }
        GetDeploymentResponse other = (GetDeploymentResponse)((Object)obj);
        return Objects.equals(this.deployment(), other.deployment());
    }

    public final String toString() {
        return ToString.builder((String)"GetDeploymentResponse").add("Deployment", (Object)this.deployment()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "deployment": {
                return Optional.ofNullable(clazz.cast(this.deployment()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<DeploymentData>> map = new HashMap<String, SdkField<DeploymentData>>();
        map.put("deployment", DEPLOYMENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetDeploymentResponse, T> g) {
        return obj -> g.apply((GetDeploymentResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LaunchWizardResponse.BuilderImpl
    implements Builder {
        private DeploymentData deployment;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDeploymentResponse model) {
            super(model);
            this.deployment(model.deployment);
        }

        public final DeploymentData.Builder getDeployment() {
            return this.deployment != null ? this.deployment.toBuilder() : null;
        }

        public final void setDeployment(DeploymentData.BuilderImpl deployment) {
            this.deployment = deployment != null ? deployment.build() : null;
        }

        @Override
        public final Builder deployment(DeploymentData deployment) {
            this.deployment = deployment;
            return this;
        }

        @Override
        public GetDeploymentResponse build() {
            return new GetDeploymentResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends LaunchWizardResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDeploymentResponse> {
        public Builder deployment(DeploymentData var1);

        default public Builder deployment(Consumer<DeploymentData.Builder> deployment) {
            return this.deployment((DeploymentData)((DeploymentData.Builder)DeploymentData.builder().applyMutation(deployment)).build());
        }
    }
}

