/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartImportRequest extends LexModelBuildingRequest implements
        ToCopyableBuilder<StartImportRequest.Builder, StartImportRequest> {
    private static final SdkField<SdkBytes> PAYLOAD_FIELD = SdkField.<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("payload").getter(getter(StartImportRequest::payload)).setter(setter(Builder::payload))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("payload").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceType").getter(getter(StartImportRequest::resourceTypeAsString))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()).build();

    private static final SdkField<String> MERGE_STRATEGY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("mergeStrategy").getter(getter(StartImportRequest::mergeStrategyAsString))
            .setter(setter(Builder::mergeStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mergeStrategy").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(StartImportRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PAYLOAD_FIELD,
            RESOURCE_TYPE_FIELD, MERGE_STRATEGY_FIELD, TAGS_FIELD));

    private final SdkBytes payload;

    private final String resourceType;

    private final String mergeStrategy;

    private final List<Tag> tags;

    private StartImportRequest(BuilderImpl builder) {
        super(builder);
        this.payload = builder.payload;
        this.resourceType = builder.resourceType;
        this.mergeStrategy = builder.mergeStrategy;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * A zip archive in binary format. The archive should contain one file, a JSON file containing the resource to
     * import. The resource should match the type specified in the <code>resourceType</code> field.
     * </p>
     * 
     * @return A zip archive in binary format. The archive should contain one file, a JSON file containing the resource
     *         to import. The resource should match the type specified in the <code>resourceType</code> field.
     */
    public final SdkBytes payload() {
        return payload;
    }

    /**
     * <p>
     * Specifies the type of resource to export. Each resource also exports any resources that it depends on.
     * </p>
     * <ul>
     * <li>
     * <p>
     * A bot exports dependent intents.
     * </p>
     * </li>
     * <li>
     * <p>
     * An intent exports dependent slot types.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return Specifies the type of resource to export. Each resource also exports any resources that it depends on.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         A bot exports dependent intents.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         An intent exports dependent slot types.
     *         </p>
     *         </li>
     * @see ResourceType
     */
    public final ResourceType resourceType() {
        return ResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * Specifies the type of resource to export. Each resource also exports any resources that it depends on.
     * </p>
     * <ul>
     * <li>
     * <p>
     * A bot exports dependent intents.
     * </p>
     * </li>
     * <li>
     * <p>
     * An intent exports dependent slot types.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return Specifies the type of resource to export. Each resource also exports any resources that it depends on.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         A bot exports dependent intents.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         An intent exports dependent slot types.
     *         </p>
     *         </li>
     * @see ResourceType
     */
    public final String resourceTypeAsString() {
        return resourceType;
    }

    /**
     * <p>
     * Specifies the action that the <code>StartImport</code> operation should take when there is an existing resource
     * with the same name.
     * </p>
     * <ul>
     * <li>
     * <p>
     * FAIL_ON_CONFLICT - The import operation is stopped on the first conflict between a resource in the import file
     * and an existing resource. The name of the resource causing the conflict is in the <code>failureReason</code>
     * field of the response to the <code>GetImport</code> operation.
     * </p>
     * <p>
     * OVERWRITE_LATEST - The import operation proceeds even if there is a conflict with an existing resource. The
     * $LASTEST version of the existing resource is overwritten with the data from the import file.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mergeStrategy}
     * will return {@link MergeStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #mergeStrategyAsString}.
     * </p>
     * 
     * @return Specifies the action that the <code>StartImport</code> operation should take when there is an existing
     *         resource with the same name.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         FAIL_ON_CONFLICT - The import operation is stopped on the first conflict between a resource in the import
     *         file and an existing resource. The name of the resource causing the conflict is in the
     *         <code>failureReason</code> field of the response to the <code>GetImport</code> operation.
     *         </p>
     *         <p>
     *         OVERWRITE_LATEST - The import operation proceeds even if there is a conflict with an existing resource.
     *         The $LASTEST version of the existing resource is overwritten with the data from the import file.
     *         </p>
     *         </li>
     * @see MergeStrategy
     */
    public final MergeStrategy mergeStrategy() {
        return MergeStrategy.fromValue(mergeStrategy);
    }

    /**
     * <p>
     * Specifies the action that the <code>StartImport</code> operation should take when there is an existing resource
     * with the same name.
     * </p>
     * <ul>
     * <li>
     * <p>
     * FAIL_ON_CONFLICT - The import operation is stopped on the first conflict between a resource in the import file
     * and an existing resource. The name of the resource causing the conflict is in the <code>failureReason</code>
     * field of the response to the <code>GetImport</code> operation.
     * </p>
     * <p>
     * OVERWRITE_LATEST - The import operation proceeds even if there is a conflict with an existing resource. The
     * $LASTEST version of the existing resource is overwritten with the data from the import file.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mergeStrategy}
     * will return {@link MergeStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #mergeStrategyAsString}.
     * </p>
     * 
     * @return Specifies the action that the <code>StartImport</code> operation should take when there is an existing
     *         resource with the same name.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         FAIL_ON_CONFLICT - The import operation is stopped on the first conflict between a resource in the import
     *         file and an existing resource. The name of the resource causing the conflict is in the
     *         <code>failureReason</code> field of the response to the <code>GetImport</code> operation.
     *         </p>
     *         <p>
     *         OVERWRITE_LATEST - The import operation proceeds even if there is a conflict with an existing resource.
     *         The $LASTEST version of the existing resource is overwritten with the data from the import file.
     *         </p>
     *         </li>
     * @see MergeStrategy
     */
    public final String mergeStrategyAsString() {
        return mergeStrategy;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of tags to add to the imported bot. You can only add tags when you import a bot, you can't add tags to an
     * intent or slot type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of tags to add to the imported bot. You can only add tags when you import a bot, you can't add
     *         tags to an intent or slot type.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(payload());
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(mergeStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartImportRequest)) {
            return false;
        }
        StartImportRequest other = (StartImportRequest) obj;
        return Objects.equals(payload(), other.payload()) && Objects.equals(resourceTypeAsString(), other.resourceTypeAsString())
                && Objects.equals(mergeStrategyAsString(), other.mergeStrategyAsString()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartImportRequest").add("Payload", payload()).add("ResourceType", resourceTypeAsString())
                .add("MergeStrategy", mergeStrategyAsString()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "payload":
            return Optional.ofNullable(clazz.cast(payload()));
        case "resourceType":
            return Optional.ofNullable(clazz.cast(resourceTypeAsString()));
        case "mergeStrategy":
            return Optional.ofNullable(clazz.cast(mergeStrategyAsString()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartImportRequest, T> g) {
        return obj -> g.apply((StartImportRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexModelBuildingRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartImportRequest> {
        /**
         * <p>
         * A zip archive in binary format. The archive should contain one file, a JSON file containing the resource to
         * import. The resource should match the type specified in the <code>resourceType</code> field.
         * </p>
         * 
         * @param payload
         *        A zip archive in binary format. The archive should contain one file, a JSON file containing the
         *        resource to import. The resource should match the type specified in the <code>resourceType</code>
         *        field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder payload(SdkBytes payload);

        /**
         * <p>
         * Specifies the type of resource to export. Each resource also exports any resources that it depends on.
         * </p>
         * <ul>
         * <li>
         * <p>
         * A bot exports dependent intents.
         * </p>
         * </li>
         * <li>
         * <p>
         * An intent exports dependent slot types.
         * </p>
         * </li>
         * </ul>
         * 
         * @param resourceType
         *        Specifies the type of resource to export. Each resource also exports any resources that it depends on.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        A bot exports dependent intents.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        An intent exports dependent slot types.
         *        </p>
         *        </li>
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * Specifies the type of resource to export. Each resource also exports any resources that it depends on.
         * </p>
         * <ul>
         * <li>
         * <p>
         * A bot exports dependent intents.
         * </p>
         * </li>
         * <li>
         * <p>
         * An intent exports dependent slot types.
         * </p>
         * </li>
         * </ul>
         * 
         * @param resourceType
         *        Specifies the type of resource to export. Each resource also exports any resources that it depends on.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        A bot exports dependent intents.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        An intent exports dependent slot types.
         *        </p>
         *        </li>
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(ResourceType resourceType);

        /**
         * <p>
         * Specifies the action that the <code>StartImport</code> operation should take when there is an existing
         * resource with the same name.
         * </p>
         * <ul>
         * <li>
         * <p>
         * FAIL_ON_CONFLICT - The import operation is stopped on the first conflict between a resource in the import
         * file and an existing resource. The name of the resource causing the conflict is in the
         * <code>failureReason</code> field of the response to the <code>GetImport</code> operation.
         * </p>
         * <p>
         * OVERWRITE_LATEST - The import operation proceeds even if there is a conflict with an existing resource. The
         * $LASTEST version of the existing resource is overwritten with the data from the import file.
         * </p>
         * </li>
         * </ul>
         * 
         * @param mergeStrategy
         *        Specifies the action that the <code>StartImport</code> operation should take when there is an existing
         *        resource with the same name.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        FAIL_ON_CONFLICT - The import operation is stopped on the first conflict between a resource in the
         *        import file and an existing resource. The name of the resource causing the conflict is in the
         *        <code>failureReason</code> field of the response to the <code>GetImport</code> operation.
         *        </p>
         *        <p>
         *        OVERWRITE_LATEST - The import operation proceeds even if there is a conflict with an existing
         *        resource. The $LASTEST version of the existing resource is overwritten with the data from the import
         *        file.
         *        </p>
         *        </li>
         * @see MergeStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MergeStrategy
         */
        Builder mergeStrategy(String mergeStrategy);

        /**
         * <p>
         * Specifies the action that the <code>StartImport</code> operation should take when there is an existing
         * resource with the same name.
         * </p>
         * <ul>
         * <li>
         * <p>
         * FAIL_ON_CONFLICT - The import operation is stopped on the first conflict between a resource in the import
         * file and an existing resource. The name of the resource causing the conflict is in the
         * <code>failureReason</code> field of the response to the <code>GetImport</code> operation.
         * </p>
         * <p>
         * OVERWRITE_LATEST - The import operation proceeds even if there is a conflict with an existing resource. The
         * $LASTEST version of the existing resource is overwritten with the data from the import file.
         * </p>
         * </li>
         * </ul>
         * 
         * @param mergeStrategy
         *        Specifies the action that the <code>StartImport</code> operation should take when there is an existing
         *        resource with the same name.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        FAIL_ON_CONFLICT - The import operation is stopped on the first conflict between a resource in the
         *        import file and an existing resource. The name of the resource causing the conflict is in the
         *        <code>failureReason</code> field of the response to the <code>GetImport</code> operation.
         *        </p>
         *        <p>
         *        OVERWRITE_LATEST - The import operation proceeds even if there is a conflict with an existing
         *        resource. The $LASTEST version of the existing resource is overwritten with the data from the import
         *        file.
         *        </p>
         *        </li>
         * @see MergeStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MergeStrategy
         */
        Builder mergeStrategy(MergeStrategy mergeStrategy);

        /**
         * <p>
         * A list of tags to add to the imported bot. You can only add tags when you import a bot, you can't add tags to
         * an intent or slot type.
         * </p>
         * 
         * @param tags
         *        A list of tags to add to the imported bot. You can only add tags when you import a bot, you can't add
         *        tags to an intent or slot type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of tags to add to the imported bot. You can only add tags when you import a bot, you can't add tags to
         * an intent or slot type.
         * </p>
         * 
         * @param tags
         *        A list of tags to add to the imported bot. You can only add tags when you import a bot, you can't add
         *        tags to an intent or slot type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of tags to add to the imported bot. You can only add tags when you import a bot, you can't add tags to
         * an intent or slot type.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lexmodelbuilding.model.Tag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.lexmodelbuilding.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lexmodelbuilding.model.Tag.Builder#build()} is called immediately and
         * its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lexmodelbuilding.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LexModelBuildingRequest.BuilderImpl implements Builder {
        private SdkBytes payload;

        private String resourceType;

        private String mergeStrategy;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartImportRequest model) {
            super(model);
            payload(model.payload);
            resourceType(model.resourceType);
            mergeStrategy(model.mergeStrategy);
            tags(model.tags);
        }

        public final ByteBuffer getPayload() {
            return payload == null ? null : payload.asByteBuffer();
        }

        public final void setPayload(ByteBuffer payload) {
            payload(payload == null ? null : SdkBytes.fromByteBuffer(payload));
        }

        @Override
        public final Builder payload(SdkBytes payload) {
            this.payload = payload;
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final String getMergeStrategy() {
            return mergeStrategy;
        }

        public final void setMergeStrategy(String mergeStrategy) {
            this.mergeStrategy = mergeStrategy;
        }

        @Override
        public final Builder mergeStrategy(String mergeStrategy) {
            this.mergeStrategy = mergeStrategy;
            return this;
        }

        @Override
        public final Builder mergeStrategy(MergeStrategy mergeStrategy) {
            this.mergeStrategy(mergeStrategy == null ? null : mergeStrategy.toString());
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartImportRequest build() {
            return new StartImportRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
