/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lexmodelsv2.LexModelsV2AsyncClient;
import software.amazon.awssdk.services.lexmodelsv2.internal.UserAgentUtils;
import software.amazon.awssdk.services.lexmodelsv2.model.ListSlotTypesRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListSlotTypesResponse;

public class ListSlotTypesPublisher
implements SdkPublisher<ListSlotTypesResponse> {
    private final LexModelsV2AsyncClient client;
    private final ListSlotTypesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSlotTypesPublisher(LexModelsV2AsyncClient client, ListSlotTypesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSlotTypesPublisher(LexModelsV2AsyncClient client, ListSlotTypesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSlotTypesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSlotTypesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListSlotTypesResponseFetcher
    implements AsyncPageFetcher<ListSlotTypesResponse> {
        private ListSlotTypesResponseFetcher() {
        }

        public boolean hasNextPage(ListSlotTypesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSlotTypesResponse> nextPage(ListSlotTypesResponse previousPage) {
            if (previousPage == null) {
                return ListSlotTypesPublisher.this.client.listSlotTypes(ListSlotTypesPublisher.this.firstRequest);
            }
            return ListSlotTypesPublisher.this.client.listSlotTypes((ListSlotTypesRequest)((Object)ListSlotTypesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

