/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lexmodelsv2.LexModelsV2Client;
import software.amazon.awssdk.services.lexmodelsv2.internal.UserAgentUtils;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBotLocalesRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBotLocalesResponse;

public class ListBotLocalesIterable
implements SdkIterable<ListBotLocalesResponse> {
    private final LexModelsV2Client client;
    private final ListBotLocalesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListBotLocalesIterable(LexModelsV2Client client, ListBotLocalesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListBotLocalesResponseFetcher();
    }

    public Iterator<ListBotLocalesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListBotLocalesResponseFetcher
    implements SyncPageFetcher<ListBotLocalesResponse> {
        private ListBotLocalesResponseFetcher() {
        }

        public boolean hasNextPage(ListBotLocalesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListBotLocalesResponse nextPage(ListBotLocalesResponse previousPage) {
            if (previousPage == null) {
                return ListBotLocalesIterable.this.client.listBotLocales(ListBotLocalesIterable.this.firstRequest);
            }
            return ListBotLocalesIterable.this.client.listBotLocales((ListBotLocalesRequest)((Object)ListBotLocalesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

