/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanager.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.licensemanager.model.LicenseDeletionStatus;
import software.amazon.awssdk.services.licensemanager.model.LicenseManagerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteLicenseResponse
extends LicenseManagerResponse
implements ToCopyableBuilder<Builder, DeleteLicenseResponse> {
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DeleteLicenseResponse.getter(DeleteLicenseResponse::statusAsString)).setter(DeleteLicenseResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> DELETION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeletionDate").getter(DeleteLicenseResponse.getter(DeleteLicenseResponse::deletionDate)).setter(DeleteLicenseResponse.setter(Builder::deletionDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, DELETION_DATE_FIELD));
    private final String status;
    private final String deletionDate;

    private DeleteLicenseResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.deletionDate = builder.deletionDate;
    }

    public final LicenseDeletionStatus status() {
        return LicenseDeletionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String deletionDate() {
        return this.deletionDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.deletionDate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteLicenseResponse)) {
            return false;
        }
        DeleteLicenseResponse other = (DeleteLicenseResponse)((Object)obj);
        return Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.deletionDate(), other.deletionDate());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteLicenseResponse").add("Status", (Object)this.statusAsString()).add("DeletionDate", (Object)this.deletionDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "DeletionDate": {
                return Optional.ofNullable(clazz.cast(this.deletionDate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteLicenseResponse, T> g) {
        return obj -> g.apply((DeleteLicenseResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LicenseManagerResponse.BuilderImpl
    implements Builder {
        private String status;
        private String deletionDate;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteLicenseResponse model) {
            super(model);
            this.status(model.status);
            this.deletionDate(model.deletionDate);
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(LicenseDeletionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getDeletionDate() {
            return this.deletionDate;
        }

        public final void setDeletionDate(String deletionDate) {
            this.deletionDate = deletionDate;
        }

        @Override
        public final Builder deletionDate(String deletionDate) {
            this.deletionDate = deletionDate;
            return this;
        }

        @Override
        public DeleteLicenseResponse build() {
            return new DeleteLicenseResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LicenseManagerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteLicenseResponse> {
        public Builder status(String var1);

        public Builder status(LicenseDeletionStatus var1);

        public Builder deletionDate(String var1);
    }
}

