/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanager.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.licensemanager.model.LicenseManagerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateLicenseAssetGroupResponse
extends LicenseManagerResponse
implements ToCopyableBuilder<Builder, CreateLicenseAssetGroupResponse> {
    private static final SdkField<String> LICENSE_ASSET_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LicenseAssetGroupArn").getter(CreateLicenseAssetGroupResponse.getter(CreateLicenseAssetGroupResponse::licenseAssetGroupArn)).setter(CreateLicenseAssetGroupResponse.setter(Builder::licenseAssetGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseAssetGroupArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(CreateLicenseAssetGroupResponse.getter(CreateLicenseAssetGroupResponse::status)).setter(CreateLicenseAssetGroupResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LICENSE_ASSET_GROUP_ARN_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateLicenseAssetGroupResponse.memberNameToFieldInitializer();
    private final String licenseAssetGroupArn;
    private final String status;

    private CreateLicenseAssetGroupResponse(BuilderImpl builder) {
        super(builder);
        this.licenseAssetGroupArn = builder.licenseAssetGroupArn;
        this.status = builder.status;
    }

    public final String licenseAssetGroupArn() {
        return this.licenseAssetGroupArn;
    }

    public final String status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseAssetGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLicenseAssetGroupResponse)) {
            return false;
        }
        CreateLicenseAssetGroupResponse other = (CreateLicenseAssetGroupResponse)((Object)obj);
        return Objects.equals(this.licenseAssetGroupArn(), other.licenseAssetGroupArn()) && Objects.equals(this.status(), other.status());
    }

    public final String toString() {
        return ToString.builder((String)"CreateLicenseAssetGroupResponse").add("LicenseAssetGroupArn", (Object)this.licenseAssetGroupArn()).add("Status", (Object)this.status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LicenseAssetGroupArn": {
                return Optional.ofNullable(clazz.cast(this.licenseAssetGroupArn()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("LicenseAssetGroupArn", LICENSE_ASSET_GROUP_ARN_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateLicenseAssetGroupResponse, T> g) {
        return obj -> g.apply((CreateLicenseAssetGroupResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LicenseManagerResponse.BuilderImpl
    implements Builder {
        private String licenseAssetGroupArn;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLicenseAssetGroupResponse model) {
            super(model);
            this.licenseAssetGroupArn(model.licenseAssetGroupArn);
            this.status(model.status);
        }

        public final String getLicenseAssetGroupArn() {
            return this.licenseAssetGroupArn;
        }

        public final void setLicenseAssetGroupArn(String licenseAssetGroupArn) {
            this.licenseAssetGroupArn = licenseAssetGroupArn;
        }

        @Override
        public final Builder licenseAssetGroupArn(String licenseAssetGroupArn) {
            this.licenseAssetGroupArn = licenseAssetGroupArn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public CreateLicenseAssetGroupResponse build() {
            return new CreateLicenseAssetGroupResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends LicenseManagerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateLicenseAssetGroupResponse> {
        public Builder licenseAssetGroupArn(String var1);

        public Builder status(String var1);
    }
}

