/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.licensemanager.model.Asset;
import software.amazon.awssdk.services.licensemanager.model.AssetListCopier;
import software.amazon.awssdk.services.licensemanager.model.LicenseManagerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAssetsForLicenseAssetGroupResponse
extends LicenseManagerResponse
implements ToCopyableBuilder<Builder, ListAssetsForLicenseAssetGroupResponse> {
    private static final SdkField<List<Asset>> ASSETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Assets").getter(ListAssetsForLicenseAssetGroupResponse.getter(ListAssetsForLicenseAssetGroupResponse::assets)).setter(ListAssetsForLicenseAssetGroupResponse.setter(Builder::assets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Assets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Asset::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListAssetsForLicenseAssetGroupResponse.getter(ListAssetsForLicenseAssetGroupResponse::nextToken)).setter(ListAssetsForLicenseAssetGroupResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSETS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListAssetsForLicenseAssetGroupResponse.memberNameToFieldInitializer();
    private final List<Asset> assets;
    private final String nextToken;

    private ListAssetsForLicenseAssetGroupResponse(BuilderImpl builder) {
        super(builder);
        this.assets = builder.assets;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAssets() {
        return this.assets != null && !(this.assets instanceof SdkAutoConstructList);
    }

    public final List<Asset> assets() {
        return this.assets;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssets() ? this.assets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAssetsForLicenseAssetGroupResponse)) {
            return false;
        }
        ListAssetsForLicenseAssetGroupResponse other = (ListAssetsForLicenseAssetGroupResponse)((Object)obj);
        return this.hasAssets() == other.hasAssets() && Objects.equals(this.assets(), other.assets()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListAssetsForLicenseAssetGroupResponse").add("Assets", this.hasAssets() ? this.assets() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Assets": {
                return Optional.ofNullable(clazz.cast(this.assets()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Assets", ASSETS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAssetsForLicenseAssetGroupResponse, T> g) {
        return obj -> g.apply((ListAssetsForLicenseAssetGroupResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LicenseManagerResponse.BuilderImpl
    implements Builder {
        private List<Asset> assets = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAssetsForLicenseAssetGroupResponse model) {
            super(model);
            this.assets(model.assets);
            this.nextToken(model.nextToken);
        }

        public final List<Asset.Builder> getAssets() {
            List<Asset.Builder> result = AssetListCopier.copyToBuilder(this.assets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssets(Collection<Asset.BuilderImpl> assets) {
            this.assets = AssetListCopier.copyFromBuilder(assets);
        }

        @Override
        public final Builder assets(Collection<Asset> assets) {
            this.assets = AssetListCopier.copy(assets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assets(Asset ... assets) {
            this.assets(Arrays.asList(assets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assets(Consumer<Asset.Builder> ... assets) {
            this.assets(Stream.of(assets).map(c -> (Asset)((Asset.Builder)Asset.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAssetsForLicenseAssetGroupResponse build() {
            return new ListAssetsForLicenseAssetGroupResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends LicenseManagerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAssetsForLicenseAssetGroupResponse> {
        public Builder assets(Collection<Asset> var1);

        public Builder assets(Asset ... var1);

        public Builder assets(Consumer<Asset.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

