/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.licensemanager.model.LicenseAssetRuleset;
import software.amazon.awssdk.services.licensemanager.model.LicenseAssetRulesetListCopier;
import software.amazon.awssdk.services.licensemanager.model.LicenseManagerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListLicenseAssetRulesetsResponse
extends LicenseManagerResponse
implements ToCopyableBuilder<Builder, ListLicenseAssetRulesetsResponse> {
    private static final SdkField<List<LicenseAssetRuleset>> LICENSE_ASSET_RULESETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LicenseAssetRulesets").getter(ListLicenseAssetRulesetsResponse.getter(ListLicenseAssetRulesetsResponse::licenseAssetRulesets)).setter(ListLicenseAssetRulesetsResponse.setter(Builder::licenseAssetRulesets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseAssetRulesets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LicenseAssetRuleset::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListLicenseAssetRulesetsResponse.getter(ListLicenseAssetRulesetsResponse::nextToken)).setter(ListLicenseAssetRulesetsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LICENSE_ASSET_RULESETS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListLicenseAssetRulesetsResponse.memberNameToFieldInitializer();
    private final List<LicenseAssetRuleset> licenseAssetRulesets;
    private final String nextToken;

    private ListLicenseAssetRulesetsResponse(BuilderImpl builder) {
        super(builder);
        this.licenseAssetRulesets = builder.licenseAssetRulesets;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasLicenseAssetRulesets() {
        return this.licenseAssetRulesets != null && !(this.licenseAssetRulesets instanceof SdkAutoConstructList);
    }

    public final List<LicenseAssetRuleset> licenseAssetRulesets() {
        return this.licenseAssetRulesets;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLicenseAssetRulesets() ? this.licenseAssetRulesets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLicenseAssetRulesetsResponse)) {
            return false;
        }
        ListLicenseAssetRulesetsResponse other = (ListLicenseAssetRulesetsResponse)((Object)obj);
        return this.hasLicenseAssetRulesets() == other.hasLicenseAssetRulesets() && Objects.equals(this.licenseAssetRulesets(), other.licenseAssetRulesets()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListLicenseAssetRulesetsResponse").add("LicenseAssetRulesets", this.hasLicenseAssetRulesets() ? this.licenseAssetRulesets() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LicenseAssetRulesets": {
                return Optional.ofNullable(clazz.cast(this.licenseAssetRulesets()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("LicenseAssetRulesets", LICENSE_ASSET_RULESETS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListLicenseAssetRulesetsResponse, T> g) {
        return obj -> g.apply((ListLicenseAssetRulesetsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LicenseManagerResponse.BuilderImpl
    implements Builder {
        private List<LicenseAssetRuleset> licenseAssetRulesets = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListLicenseAssetRulesetsResponse model) {
            super(model);
            this.licenseAssetRulesets(model.licenseAssetRulesets);
            this.nextToken(model.nextToken);
        }

        public final List<LicenseAssetRuleset.Builder> getLicenseAssetRulesets() {
            List<LicenseAssetRuleset.Builder> result = LicenseAssetRulesetListCopier.copyToBuilder(this.licenseAssetRulesets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLicenseAssetRulesets(Collection<LicenseAssetRuleset.BuilderImpl> licenseAssetRulesets) {
            this.licenseAssetRulesets = LicenseAssetRulesetListCopier.copyFromBuilder(licenseAssetRulesets);
        }

        @Override
        public final Builder licenseAssetRulesets(Collection<LicenseAssetRuleset> licenseAssetRulesets) {
            this.licenseAssetRulesets = LicenseAssetRulesetListCopier.copy(licenseAssetRulesets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenseAssetRulesets(LicenseAssetRuleset ... licenseAssetRulesets) {
            this.licenseAssetRulesets(Arrays.asList(licenseAssetRulesets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenseAssetRulesets(Consumer<LicenseAssetRuleset.Builder> ... licenseAssetRulesets) {
            this.licenseAssetRulesets(Stream.of(licenseAssetRulesets).map(c -> (LicenseAssetRuleset)((LicenseAssetRuleset.Builder)LicenseAssetRuleset.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListLicenseAssetRulesetsResponse build() {
            return new ListLicenseAssetRulesetsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends LicenseManagerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListLicenseAssetRulesetsResponse> {
        public Builder licenseAssetRulesets(Collection<LicenseAssetRuleset> var1);

        public Builder licenseAssetRulesets(LicenseAssetRuleset ... var1);

        public Builder licenseAssetRulesets(Consumer<LicenseAssetRuleset.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

