/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AttachCertificateToDistributionRequest extends LightsailRequest implements
        ToCopyableBuilder<AttachCertificateToDistributionRequest.Builder, AttachCertificateToDistributionRequest> {
    private static final SdkField<String> DISTRIBUTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("distributionName").getter(getter(AttachCertificateToDistributionRequest::distributionName))
            .setter(setter(Builder::distributionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("distributionName").build()).build();

    private static final SdkField<String> CERTIFICATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("certificateName").getter(getter(AttachCertificateToDistributionRequest::certificateName))
            .setter(setter(Builder::certificateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISTRIBUTION_NAME_FIELD,
            CERTIFICATE_NAME_FIELD));

    private final String distributionName;

    private final String certificateName;

    private AttachCertificateToDistributionRequest(BuilderImpl builder) {
        super(builder);
        this.distributionName = builder.distributionName;
        this.certificateName = builder.certificateName;
    }

    /**
     * <p>
     * The name of the distribution that the certificate will be attached to.
     * </p>
     * <p>
     * Use the <code>GetDistributions</code> action to get a list of distribution names that you can specify.
     * </p>
     * 
     * @return The name of the distribution that the certificate will be attached to.</p>
     *         <p>
     *         Use the <code>GetDistributions</code> action to get a list of distribution names that you can specify.
     */
    public final String distributionName() {
        return distributionName;
    }

    /**
     * <p>
     * The name of the certificate to attach to a distribution.
     * </p>
     * <p>
     * Only certificates with a status of <code>ISSUED</code> can be attached to a distribution.
     * </p>
     * <p>
     * Use the <code>GetCertificates</code> action to get a list of certificate names that you can specify.
     * </p>
     * <note>
     * <p>
     * This is the name of the certificate resource type and is used only to reference the certificate in other API
     * actions. It can be different than the domain name of the certificate. For example, your certificate name might be
     * <code>WordPress-Blog-Certificate</code> and the domain name of the certificate might be <code>example.com</code>.
     * </p>
     * </note>
     * 
     * @return The name of the certificate to attach to a distribution.</p>
     *         <p>
     *         Only certificates with a status of <code>ISSUED</code> can be attached to a distribution.
     *         </p>
     *         <p>
     *         Use the <code>GetCertificates</code> action to get a list of certificate names that you can specify.
     *         </p>
     *         <note>
     *         <p>
     *         This is the name of the certificate resource type and is used only to reference the certificate in other
     *         API actions. It can be different than the domain name of the certificate. For example, your certificate
     *         name might be <code>WordPress-Blog-Certificate</code> and the domain name of the certificate might be
     *         <code>example.com</code>.
     *         </p>
     */
    public final String certificateName() {
        return certificateName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(distributionName());
        hashCode = 31 * hashCode + Objects.hashCode(certificateName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttachCertificateToDistributionRequest)) {
            return false;
        }
        AttachCertificateToDistributionRequest other = (AttachCertificateToDistributionRequest) obj;
        return Objects.equals(distributionName(), other.distributionName())
                && Objects.equals(certificateName(), other.certificateName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AttachCertificateToDistributionRequest").add("DistributionName", distributionName())
                .add("CertificateName", certificateName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "distributionName":
            return Optional.ofNullable(clazz.cast(distributionName()));
        case "certificateName":
            return Optional.ofNullable(clazz.cast(certificateName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AttachCertificateToDistributionRequest, T> g) {
        return obj -> g.apply((AttachCertificateToDistributionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, AttachCertificateToDistributionRequest> {
        /**
         * <p>
         * The name of the distribution that the certificate will be attached to.
         * </p>
         * <p>
         * Use the <code>GetDistributions</code> action to get a list of distribution names that you can specify.
         * </p>
         * 
         * @param distributionName
         *        The name of the distribution that the certificate will be attached to.</p>
         *        <p>
         *        Use the <code>GetDistributions</code> action to get a list of distribution names that you can specify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder distributionName(String distributionName);

        /**
         * <p>
         * The name of the certificate to attach to a distribution.
         * </p>
         * <p>
         * Only certificates with a status of <code>ISSUED</code> can be attached to a distribution.
         * </p>
         * <p>
         * Use the <code>GetCertificates</code> action to get a list of certificate names that you can specify.
         * </p>
         * <note>
         * <p>
         * This is the name of the certificate resource type and is used only to reference the certificate in other API
         * actions. It can be different than the domain name of the certificate. For example, your certificate name
         * might be <code>WordPress-Blog-Certificate</code> and the domain name of the certificate might be
         * <code>example.com</code>.
         * </p>
         * </note>
         * 
         * @param certificateName
         *        The name of the certificate to attach to a distribution.</p>
         *        <p>
         *        Only certificates with a status of <code>ISSUED</code> can be attached to a distribution.
         *        </p>
         *        <p>
         *        Use the <code>GetCertificates</code> action to get a list of certificate names that you can specify.
         *        </p>
         *        <note>
         *        <p>
         *        This is the name of the certificate resource type and is used only to reference the certificate in
         *        other API actions. It can be different than the domain name of the certificate. For example, your
         *        certificate name might be <code>WordPress-Blog-Certificate</code> and the domain name of the
         *        certificate might be <code>example.com</code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateName(String certificateName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LightsailRequest.BuilderImpl implements Builder {
        private String distributionName;

        private String certificateName;

        private BuilderImpl() {
        }

        private BuilderImpl(AttachCertificateToDistributionRequest model) {
            super(model);
            distributionName(model.distributionName);
            certificateName(model.certificateName);
        }

        public final String getDistributionName() {
            return distributionName;
        }

        public final void setDistributionName(String distributionName) {
            this.distributionName = distributionName;
        }

        @Override
        public final Builder distributionName(String distributionName) {
            this.distributionName = distributionName;
            return this;
        }

        public final String getCertificateName() {
            return certificateName;
        }

        public final void setCertificateName(String certificateName) {
            this.certificateName = certificateName;
        }

        @Override
        public final Builder certificateName(String certificateName) {
            this.certificateName = certificateName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AttachCertificateToDistributionRequest build() {
            return new AttachCertificateToDistributionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
