/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteInstanceRequest extends LightsailRequest implements
        ToCopyableBuilder<DeleteInstanceRequest.Builder, DeleteInstanceRequest> {
    private static final SdkField<String> INSTANCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("instanceName").getter(getter(DeleteInstanceRequest::instanceName)).setter(setter(Builder::instanceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceName").build()).build();

    private static final SdkField<Boolean> FORCE_DELETE_ADD_ONS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("forceDeleteAddOns").getter(getter(DeleteInstanceRequest::forceDeleteAddOns))
            .setter(setter(Builder::forceDeleteAddOns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("forceDeleteAddOns").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_NAME_FIELD,
            FORCE_DELETE_ADD_ONS_FIELD));

    private final String instanceName;

    private final Boolean forceDeleteAddOns;

    private DeleteInstanceRequest(BuilderImpl builder) {
        super(builder);
        this.instanceName = builder.instanceName;
        this.forceDeleteAddOns = builder.forceDeleteAddOns;
    }

    /**
     * <p>
     * The name of the instance to delete.
     * </p>
     * 
     * @return The name of the instance to delete.
     */
    public final String instanceName() {
        return instanceName;
    }

    /**
     * <p>
     * A Boolean value to indicate whether to delete all add-ons for the instance.
     * </p>
     * 
     * @return A Boolean value to indicate whether to delete all add-ons for the instance.
     */
    public final Boolean forceDeleteAddOns() {
        return forceDeleteAddOns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceName());
        hashCode = 31 * hashCode + Objects.hashCode(forceDeleteAddOns());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteInstanceRequest)) {
            return false;
        }
        DeleteInstanceRequest other = (DeleteInstanceRequest) obj;
        return Objects.equals(instanceName(), other.instanceName())
                && Objects.equals(forceDeleteAddOns(), other.forceDeleteAddOns());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteInstanceRequest").add("InstanceName", instanceName())
                .add("ForceDeleteAddOns", forceDeleteAddOns()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "instanceName":
            return Optional.ofNullable(clazz.cast(instanceName()));
        case "forceDeleteAddOns":
            return Optional.ofNullable(clazz.cast(forceDeleteAddOns()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteInstanceRequest, T> g) {
        return obj -> g.apply((DeleteInstanceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteInstanceRequest> {
        /**
         * <p>
         * The name of the instance to delete.
         * </p>
         * 
         * @param instanceName
         *        The name of the instance to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceName(String instanceName);

        /**
         * <p>
         * A Boolean value to indicate whether to delete all add-ons for the instance.
         * </p>
         * 
         * @param forceDeleteAddOns
         *        A Boolean value to indicate whether to delete all add-ons for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forceDeleteAddOns(Boolean forceDeleteAddOns);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LightsailRequest.BuilderImpl implements Builder {
        private String instanceName;

        private Boolean forceDeleteAddOns;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteInstanceRequest model) {
            super(model);
            instanceName(model.instanceName);
            forceDeleteAddOns(model.forceDeleteAddOns);
        }

        public final String getInstanceName() {
            return instanceName;
        }

        public final void setInstanceName(String instanceName) {
            this.instanceName = instanceName;
        }

        @Override
        public final Builder instanceName(String instanceName) {
            this.instanceName = instanceName;
            return this;
        }

        public final Boolean getForceDeleteAddOns() {
            return forceDeleteAddOns;
        }

        public final void setForceDeleteAddOns(Boolean forceDeleteAddOns) {
            this.forceDeleteAddOns = forceDeleteAddOns;
        }

        @Override
        public final Builder forceDeleteAddOns(Boolean forceDeleteAddOns) {
            this.forceDeleteAddOns = forceDeleteAddOns;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteInstanceRequest build() {
            return new DeleteInstanceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
