/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the settings of a public endpoint for an Amazon Lightsail container service.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EndpointRequest implements SdkPojo, Serializable, ToCopyableBuilder<EndpointRequest.Builder, EndpointRequest> {
    private static final SdkField<String> CONTAINER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("containerName").getter(getter(EndpointRequest::containerName)).setter(setter(Builder::containerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerName").build()).build();

    private static final SdkField<Integer> CONTAINER_PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("containerPort").getter(getter(EndpointRequest::containerPort)).setter(setter(Builder::containerPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerPort").build()).build();

    private static final SdkField<ContainerServiceHealthCheckConfig> HEALTH_CHECK_FIELD = SdkField
            .<ContainerServiceHealthCheckConfig> builder(MarshallingType.SDK_POJO).memberName("healthCheck")
            .getter(getter(EndpointRequest::healthCheck)).setter(setter(Builder::healthCheck))
            .constructor(ContainerServiceHealthCheckConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("healthCheck").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINER_NAME_FIELD,
            CONTAINER_PORT_FIELD, HEALTH_CHECK_FIELD));

    private static final long serialVersionUID = 1L;

    private final String containerName;

    private final Integer containerPort;

    private final ContainerServiceHealthCheckConfig healthCheck;

    private EndpointRequest(BuilderImpl builder) {
        this.containerName = builder.containerName;
        this.containerPort = builder.containerPort;
        this.healthCheck = builder.healthCheck;
    }

    /**
     * <p>
     * The name of the container for the endpoint.
     * </p>
     * 
     * @return The name of the container for the endpoint.
     */
    public final String containerName() {
        return containerName;
    }

    /**
     * <p>
     * The port of the container to which traffic is forwarded to.
     * </p>
     * 
     * @return The port of the container to which traffic is forwarded to.
     */
    public final Integer containerPort() {
        return containerPort;
    }

    /**
     * <p>
     * An object that describes the health check configuration of the container.
     * </p>
     * 
     * @return An object that describes the health check configuration of the container.
     */
    public final ContainerServiceHealthCheckConfig healthCheck() {
        return healthCheck;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(containerName());
        hashCode = 31 * hashCode + Objects.hashCode(containerPort());
        hashCode = 31 * hashCode + Objects.hashCode(healthCheck());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EndpointRequest)) {
            return false;
        }
        EndpointRequest other = (EndpointRequest) obj;
        return Objects.equals(containerName(), other.containerName()) && Objects.equals(containerPort(), other.containerPort())
                && Objects.equals(healthCheck(), other.healthCheck());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EndpointRequest").add("ContainerName", containerName()).add("ContainerPort", containerPort())
                .add("HealthCheck", healthCheck()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "containerName":
            return Optional.ofNullable(clazz.cast(containerName()));
        case "containerPort":
            return Optional.ofNullable(clazz.cast(containerPort()));
        case "healthCheck":
            return Optional.ofNullable(clazz.cast(healthCheck()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EndpointRequest, T> g) {
        return obj -> g.apply((EndpointRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EndpointRequest> {
        /**
         * <p>
         * The name of the container for the endpoint.
         * </p>
         * 
         * @param containerName
         *        The name of the container for the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerName(String containerName);

        /**
         * <p>
         * The port of the container to which traffic is forwarded to.
         * </p>
         * 
         * @param containerPort
         *        The port of the container to which traffic is forwarded to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerPort(Integer containerPort);

        /**
         * <p>
         * An object that describes the health check configuration of the container.
         * </p>
         * 
         * @param healthCheck
         *        An object that describes the health check configuration of the container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthCheck(ContainerServiceHealthCheckConfig healthCheck);

        /**
         * <p>
         * An object that describes the health check configuration of the container.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ContainerServiceHealthCheckConfig.Builder} avoiding the need to create one manually via
         * {@link ContainerServiceHealthCheckConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ContainerServiceHealthCheckConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #healthCheck(ContainerServiceHealthCheckConfig)}.
         * 
         * @param healthCheck
         *        a consumer that will call methods on {@link ContainerServiceHealthCheckConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #healthCheck(ContainerServiceHealthCheckConfig)
         */
        default Builder healthCheck(Consumer<ContainerServiceHealthCheckConfig.Builder> healthCheck) {
            return healthCheck(ContainerServiceHealthCheckConfig.builder().applyMutation(healthCheck).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String containerName;

        private Integer containerPort;

        private ContainerServiceHealthCheckConfig healthCheck;

        private BuilderImpl() {
        }

        private BuilderImpl(EndpointRequest model) {
            containerName(model.containerName);
            containerPort(model.containerPort);
            healthCheck(model.healthCheck);
        }

        public final String getContainerName() {
            return containerName;
        }

        public final void setContainerName(String containerName) {
            this.containerName = containerName;
        }

        @Override
        public final Builder containerName(String containerName) {
            this.containerName = containerName;
            return this;
        }

        public final Integer getContainerPort() {
            return containerPort;
        }

        public final void setContainerPort(Integer containerPort) {
            this.containerPort = containerPort;
        }

        @Override
        public final Builder containerPort(Integer containerPort) {
            this.containerPort = containerPort;
            return this;
        }

        public final ContainerServiceHealthCheckConfig.Builder getHealthCheck() {
            return healthCheck != null ? healthCheck.toBuilder() : null;
        }

        public final void setHealthCheck(ContainerServiceHealthCheckConfig.BuilderImpl healthCheck) {
            this.healthCheck = healthCheck != null ? healthCheck.build() : null;
        }

        @Override
        public final Builder healthCheck(ContainerServiceHealthCheckConfig healthCheck) {
            this.healthCheck = healthCheck;
            return this;
        }

        @Override
        public EndpointRequest build() {
            return new EndpointRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
