/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetBlueprintsRequest extends LightsailRequest implements
        ToCopyableBuilder<GetBlueprintsRequest.Builder, GetBlueprintsRequest> {
    private static final SdkField<Boolean> INCLUDE_INACTIVE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("includeInactive").getter(getter(GetBlueprintsRequest::includeInactive))
            .setter(setter(Builder::includeInactive))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includeInactive").build()).build();

    private static final SdkField<String> PAGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("pageToken").getter(getter(GetBlueprintsRequest::pageToken)).setter(setter(Builder::pageToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pageToken").build()).build();

    private static final SdkField<String> APP_CATEGORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("appCategory").getter(getter(GetBlueprintsRequest::appCategoryAsString))
            .setter(setter(Builder::appCategory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appCategory").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INCLUDE_INACTIVE_FIELD,
            PAGE_TOKEN_FIELD, APP_CATEGORY_FIELD));

    private final Boolean includeInactive;

    private final String pageToken;

    private final String appCategory;

    private GetBlueprintsRequest(BuilderImpl builder) {
        super(builder);
        this.includeInactive = builder.includeInactive;
        this.pageToken = builder.pageToken;
        this.appCategory = builder.appCategory;
    }

    /**
     * <p>
     * A Boolean value that indicates whether to include inactive (unavailable) blueprints in the response of your
     * request.
     * </p>
     * 
     * @return A Boolean value that indicates whether to include inactive (unavailable) blueprints in the response of
     *         your request.
     */
    public final Boolean includeInactive() {
        return includeInactive;
    }

    /**
     * <p>
     * The token to advance to the next page of results from your request.
     * </p>
     * <p>
     * To get a page token, perform an initial <code>GetBlueprints</code> request. If your results are paginated, the
     * response will return a next page token that you can specify as the page token in a subsequent request.
     * </p>
     * 
     * @return The token to advance to the next page of results from your request.</p>
     *         <p>
     *         To get a page token, perform an initial <code>GetBlueprints</code> request. If your results are
     *         paginated, the response will return a next page token that you can specify as the page token in a
     *         subsequent request.
     */
    public final String pageToken() {
        return pageToken;
    }

    /**
     * <p>
     * Returns a list of blueprints that are specific to Lightsail for Research.
     * </p>
     * <important>
     * <p>
     * You must use this parameter to view Lightsail for Research blueprints.
     * </p>
     * </important>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #appCategory} will
     * return {@link AppCategory#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #appCategoryAsString}.
     * </p>
     * 
     * @return Returns a list of blueprints that are specific to Lightsail for Research.</p> <important>
     *         <p>
     *         You must use this parameter to view Lightsail for Research blueprints.
     *         </p>
     * @see AppCategory
     */
    public final AppCategory appCategory() {
        return AppCategory.fromValue(appCategory);
    }

    /**
     * <p>
     * Returns a list of blueprints that are specific to Lightsail for Research.
     * </p>
     * <important>
     * <p>
     * You must use this parameter to view Lightsail for Research blueprints.
     * </p>
     * </important>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #appCategory} will
     * return {@link AppCategory#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #appCategoryAsString}.
     * </p>
     * 
     * @return Returns a list of blueprints that are specific to Lightsail for Research.</p> <important>
     *         <p>
     *         You must use this parameter to view Lightsail for Research blueprints.
     *         </p>
     * @see AppCategory
     */
    public final String appCategoryAsString() {
        return appCategory;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(includeInactive());
        hashCode = 31 * hashCode + Objects.hashCode(pageToken());
        hashCode = 31 * hashCode + Objects.hashCode(appCategoryAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBlueprintsRequest)) {
            return false;
        }
        GetBlueprintsRequest other = (GetBlueprintsRequest) obj;
        return Objects.equals(includeInactive(), other.includeInactive()) && Objects.equals(pageToken(), other.pageToken())
                && Objects.equals(appCategoryAsString(), other.appCategoryAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetBlueprintsRequest").add("IncludeInactive", includeInactive()).add("PageToken", pageToken())
                .add("AppCategory", appCategoryAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "includeInactive":
            return Optional.ofNullable(clazz.cast(includeInactive()));
        case "pageToken":
            return Optional.ofNullable(clazz.cast(pageToken()));
        case "appCategory":
            return Optional.ofNullable(clazz.cast(appCategoryAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetBlueprintsRequest, T> g) {
        return obj -> g.apply((GetBlueprintsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetBlueprintsRequest> {
        /**
         * <p>
         * A Boolean value that indicates whether to include inactive (unavailable) blueprints in the response of your
         * request.
         * </p>
         * 
         * @param includeInactive
         *        A Boolean value that indicates whether to include inactive (unavailable) blueprints in the response of
         *        your request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeInactive(Boolean includeInactive);

        /**
         * <p>
         * The token to advance to the next page of results from your request.
         * </p>
         * <p>
         * To get a page token, perform an initial <code>GetBlueprints</code> request. If your results are paginated,
         * the response will return a next page token that you can specify as the page token in a subsequent request.
         * </p>
         * 
         * @param pageToken
         *        The token to advance to the next page of results from your request.</p>
         *        <p>
         *        To get a page token, perform an initial <code>GetBlueprints</code> request. If your results are
         *        paginated, the response will return a next page token that you can specify as the page token in a
         *        subsequent request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pageToken(String pageToken);

        /**
         * <p>
         * Returns a list of blueprints that are specific to Lightsail for Research.
         * </p>
         * <important>
         * <p>
         * You must use this parameter to view Lightsail for Research blueprints.
         * </p>
         * </important>
         * 
         * @param appCategory
         *        Returns a list of blueprints that are specific to Lightsail for Research.</p> <important>
         *        <p>
         *        You must use this parameter to view Lightsail for Research blueprints.
         *        </p>
         * @see AppCategory
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AppCategory
         */
        Builder appCategory(String appCategory);

        /**
         * <p>
         * Returns a list of blueprints that are specific to Lightsail for Research.
         * </p>
         * <important>
         * <p>
         * You must use this parameter to view Lightsail for Research blueprints.
         * </p>
         * </important>
         * 
         * @param appCategory
         *        Returns a list of blueprints that are specific to Lightsail for Research.</p> <important>
         *        <p>
         *        You must use this parameter to view Lightsail for Research blueprints.
         *        </p>
         * @see AppCategory
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AppCategory
         */
        Builder appCategory(AppCategory appCategory);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LightsailRequest.BuilderImpl implements Builder {
        private Boolean includeInactive;

        private String pageToken;

        private String appCategory;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBlueprintsRequest model) {
            super(model);
            includeInactive(model.includeInactive);
            pageToken(model.pageToken);
            appCategory(model.appCategory);
        }

        public final Boolean getIncludeInactive() {
            return includeInactive;
        }

        public final void setIncludeInactive(Boolean includeInactive) {
            this.includeInactive = includeInactive;
        }

        @Override
        public final Builder includeInactive(Boolean includeInactive) {
            this.includeInactive = includeInactive;
            return this;
        }

        public final String getPageToken() {
            return pageToken;
        }

        public final void setPageToken(String pageToken) {
            this.pageToken = pageToken;
        }

        @Override
        public final Builder pageToken(String pageToken) {
            this.pageToken = pageToken;
            return this;
        }

        public final String getAppCategory() {
            return appCategory;
        }

        public final void setAppCategory(String appCategory) {
            this.appCategory = appCategory;
        }

        @Override
        public final Builder appCategory(String appCategory) {
            this.appCategory = appCategory;
            return this;
        }

        @Override
        public final Builder appCategory(AppCategory appCategory) {
            this.appCategory(appCategory == null ? null : appCategory.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetBlueprintsRequest build() {
            return new GetBlueprintsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
