/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetInstanceAccessDetailsResponse extends LightsailResponse implements
        ToCopyableBuilder<GetInstanceAccessDetailsResponse.Builder, GetInstanceAccessDetailsResponse> {
    private static final SdkField<InstanceAccessDetails> ACCESS_DETAILS_FIELD = SdkField
            .<InstanceAccessDetails> builder(MarshallingType.SDK_POJO).memberName("accessDetails")
            .getter(getter(GetInstanceAccessDetailsResponse::accessDetails)).setter(setter(Builder::accessDetails))
            .constructor(InstanceAccessDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessDetails").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_DETAILS_FIELD));

    private final InstanceAccessDetails accessDetails;

    private GetInstanceAccessDetailsResponse(BuilderImpl builder) {
        super(builder);
        this.accessDetails = builder.accessDetails;
    }

    /**
     * <p>
     * An array of key-value pairs containing information about a get instance access request.
     * </p>
     * 
     * @return An array of key-value pairs containing information about a get instance access request.
     */
    public final InstanceAccessDetails accessDetails() {
        return accessDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accessDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInstanceAccessDetailsResponse)) {
            return false;
        }
        GetInstanceAccessDetailsResponse other = (GetInstanceAccessDetailsResponse) obj;
        return Objects.equals(accessDetails(), other.accessDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetInstanceAccessDetailsResponse").add("AccessDetails", accessDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accessDetails":
            return Optional.ofNullable(clazz.cast(accessDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetInstanceAccessDetailsResponse, T> g) {
        return obj -> g.apply((GetInstanceAccessDetailsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetInstanceAccessDetailsResponse> {
        /**
         * <p>
         * An array of key-value pairs containing information about a get instance access request.
         * </p>
         * 
         * @param accessDetails
         *        An array of key-value pairs containing information about a get instance access request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessDetails(InstanceAccessDetails accessDetails);

        /**
         * <p>
         * An array of key-value pairs containing information about a get instance access request.
         * </p>
         * This is a convenience method that creates an instance of the {@link InstanceAccessDetails.Builder} avoiding
         * the need to create one manually via {@link InstanceAccessDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InstanceAccessDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #accessDetails(InstanceAccessDetails)}.
         * 
         * @param accessDetails
         *        a consumer that will call methods on {@link InstanceAccessDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accessDetails(InstanceAccessDetails)
         */
        default Builder accessDetails(Consumer<InstanceAccessDetails.Builder> accessDetails) {
            return accessDetails(InstanceAccessDetails.builder().applyMutation(accessDetails).build());
        }
    }

    static final class BuilderImpl extends LightsailResponse.BuilderImpl implements Builder {
        private InstanceAccessDetails accessDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(GetInstanceAccessDetailsResponse model) {
            super(model);
            accessDetails(model.accessDetails);
        }

        public final InstanceAccessDetails.Builder getAccessDetails() {
            return accessDetails != null ? accessDetails.toBuilder() : null;
        }

        public final void setAccessDetails(InstanceAccessDetails.BuilderImpl accessDetails) {
            this.accessDetails = accessDetails != null ? accessDetails.build() : null;
        }

        @Override
        public final Builder accessDetails(InstanceAccessDetails accessDetails) {
            this.accessDetails = accessDetails;
            return this;
        }

        @Override
        public GetInstanceAccessDetailsResponse build() {
            return new GetInstanceAccessDetailsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
