/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateDomainEntryRequest extends LightsailRequest implements
        ToCopyableBuilder<UpdateDomainEntryRequest.Builder, UpdateDomainEntryRequest> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainName").getter(getter(UpdateDomainEntryRequest::domainName)).setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainName").build()).build();

    private static final SdkField<DomainEntry> DOMAIN_ENTRY_FIELD = SdkField.<DomainEntry> builder(MarshallingType.SDK_POJO)
            .memberName("domainEntry").getter(getter(UpdateDomainEntryRequest::domainEntry)).setter(setter(Builder::domainEntry))
            .constructor(DomainEntry::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainEntry").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD,
            DOMAIN_ENTRY_FIELD));

    private final String domainName;

    private final DomainEntry domainEntry;

    private UpdateDomainEntryRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.domainEntry = builder.domainEntry;
    }

    /**
     * <p>
     * The name of the domain recordset to update.
     * </p>
     * 
     * @return The name of the domain recordset to update.
     */
    public final String domainName() {
        return domainName;
    }

    /**
     * <p>
     * An array of key-value pairs containing information about the domain entry.
     * </p>
     * 
     * @return An array of key-value pairs containing information about the domain entry.
     */
    public final DomainEntry domainEntry() {
        return domainEntry;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(domainEntry());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDomainEntryRequest)) {
            return false;
        }
        UpdateDomainEntryRequest other = (UpdateDomainEntryRequest) obj;
        return Objects.equals(domainName(), other.domainName()) && Objects.equals(domainEntry(), other.domainEntry());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateDomainEntryRequest").add("DomainName", domainName()).add("DomainEntry", domainEntry())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "domainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "domainEntry":
            return Optional.ofNullable(clazz.cast(domainEntry()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDomainEntryRequest, T> g) {
        return obj -> g.apply((UpdateDomainEntryRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateDomainEntryRequest> {
        /**
         * <p>
         * The name of the domain recordset to update.
         * </p>
         * 
         * @param domainName
         *        The name of the domain recordset to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * An array of key-value pairs containing information about the domain entry.
         * </p>
         * 
         * @param domainEntry
         *        An array of key-value pairs containing information about the domain entry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainEntry(DomainEntry domainEntry);

        /**
         * <p>
         * An array of key-value pairs containing information about the domain entry.
         * </p>
         * This is a convenience method that creates an instance of the {@link DomainEntry.Builder} avoiding the need to
         * create one manually via {@link DomainEntry#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DomainEntry.Builder#build()} is called immediately and its result
         * is passed to {@link #domainEntry(DomainEntry)}.
         * 
         * @param domainEntry
         *        a consumer that will call methods on {@link DomainEntry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #domainEntry(DomainEntry)
         */
        default Builder domainEntry(Consumer<DomainEntry.Builder> domainEntry) {
            return domainEntry(DomainEntry.builder().applyMutation(domainEntry).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LightsailRequest.BuilderImpl implements Builder {
        private String domainName;

        private DomainEntry domainEntry;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDomainEntryRequest model) {
            super(model);
            domainName(model.domainName);
            domainEntry(model.domainEntry);
        }

        public final String getDomainName() {
            return domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final DomainEntry.Builder getDomainEntry() {
            return domainEntry != null ? domainEntry.toBuilder() : null;
        }

        public final void setDomainEntry(DomainEntry.BuilderImpl domainEntry) {
            this.domainEntry = domainEntry != null ? domainEntry.build() : null;
        }

        @Override
        public final Builder domainEntry(DomainEntry domainEntry) {
            this.domainEntry = domainEntry;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDomainEntryRequest build() {
            return new UpdateDomainEntryRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
