/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lightsail.model.LightsailRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteDiskRequest
extends LightsailRequest
implements ToCopyableBuilder<Builder, DeleteDiskRequest> {
    private static final SdkField<String> DISK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("diskName").getter(DeleteDiskRequest.getter(DeleteDiskRequest::diskName)).setter(DeleteDiskRequest.setter(Builder::diskName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("diskName").build()}).build();
    private static final SdkField<Boolean> FORCE_DELETE_ADD_ONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("forceDeleteAddOns").getter(DeleteDiskRequest.getter(DeleteDiskRequest::forceDeleteAddOns)).setter(DeleteDiskRequest.setter(Builder::forceDeleteAddOns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("forceDeleteAddOns").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISK_NAME_FIELD, FORCE_DELETE_ADD_ONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeleteDiskRequest.memberNameToFieldInitializer();
    private final String diskName;
    private final Boolean forceDeleteAddOns;

    private DeleteDiskRequest(BuilderImpl builder) {
        super(builder);
        this.diskName = builder.diskName;
        this.forceDeleteAddOns = builder.forceDeleteAddOns;
    }

    public final String diskName() {
        return this.diskName;
    }

    public final Boolean forceDeleteAddOns() {
        return this.forceDeleteAddOns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.diskName());
        hashCode = 31 * hashCode + Objects.hashCode(this.forceDeleteAddOns());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteDiskRequest)) {
            return false;
        }
        DeleteDiskRequest other = (DeleteDiskRequest)((Object)obj);
        return Objects.equals(this.diskName(), other.diskName()) && Objects.equals(this.forceDeleteAddOns(), other.forceDeleteAddOns());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteDiskRequest").add("DiskName", (Object)this.diskName()).add("ForceDeleteAddOns", (Object)this.forceDeleteAddOns()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "diskName": {
                return Optional.ofNullable(clazz.cast(this.diskName()));
            }
            case "forceDeleteAddOns": {
                return Optional.ofNullable(clazz.cast(this.forceDeleteAddOns()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("diskName", DISK_NAME_FIELD);
        map.put("forceDeleteAddOns", FORCE_DELETE_ADD_ONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteDiskRequest, T> g) {
        return obj -> g.apply((DeleteDiskRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LightsailRequest.BuilderImpl
    implements Builder {
        private String diskName;
        private Boolean forceDeleteAddOns;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteDiskRequest model) {
            super(model);
            this.diskName(model.diskName);
            this.forceDeleteAddOns(model.forceDeleteAddOns);
        }

        public final String getDiskName() {
            return this.diskName;
        }

        public final void setDiskName(String diskName) {
            this.diskName = diskName;
        }

        @Override
        public final Builder diskName(String diskName) {
            this.diskName = diskName;
            return this;
        }

        public final Boolean getForceDeleteAddOns() {
            return this.forceDeleteAddOns;
        }

        public final void setForceDeleteAddOns(Boolean forceDeleteAddOns) {
            this.forceDeleteAddOns = forceDeleteAddOns;
        }

        @Override
        public final Builder forceDeleteAddOns(Boolean forceDeleteAddOns) {
            this.forceDeleteAddOns = forceDeleteAddOns;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteDiskRequest build() {
            return new DeleteDiskRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends LightsailRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteDiskRequest> {
        public Builder diskName(String var1);

        public Builder forceDeleteAddOns(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

