/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lightsail.model.LightsailRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetAlarmsRequest
extends LightsailRequest
implements ToCopyableBuilder<Builder, GetAlarmsRequest> {
    private static final SdkField<String> ALARM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("alarmName").getter(GetAlarmsRequest.getter(GetAlarmsRequest::alarmName)).setter(GetAlarmsRequest.setter(Builder::alarmName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alarmName").build()}).build();
    private static final SdkField<String> PAGE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("pageToken").getter(GetAlarmsRequest.getter(GetAlarmsRequest::pageToken)).setter(GetAlarmsRequest.setter(Builder::pageToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pageToken").build()}).build();
    private static final SdkField<String> MONITORED_RESOURCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("monitoredResourceName").getter(GetAlarmsRequest.getter(GetAlarmsRequest::monitoredResourceName)).setter(GetAlarmsRequest.setter(Builder::monitoredResourceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("monitoredResourceName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALARM_NAME_FIELD, PAGE_TOKEN_FIELD, MONITORED_RESOURCE_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetAlarmsRequest.memberNameToFieldInitializer();
    private final String alarmName;
    private final String pageToken;
    private final String monitoredResourceName;

    private GetAlarmsRequest(BuilderImpl builder) {
        super(builder);
        this.alarmName = builder.alarmName;
        this.pageToken = builder.pageToken;
        this.monitoredResourceName = builder.monitoredResourceName;
    }

    public final String alarmName() {
        return this.alarmName;
    }

    public final String pageToken() {
        return this.pageToken;
    }

    public final String monitoredResourceName() {
        return this.monitoredResourceName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.alarmName());
        hashCode = 31 * hashCode + Objects.hashCode(this.pageToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.monitoredResourceName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAlarmsRequest)) {
            return false;
        }
        GetAlarmsRequest other = (GetAlarmsRequest)((Object)obj);
        return Objects.equals(this.alarmName(), other.alarmName()) && Objects.equals(this.pageToken(), other.pageToken()) && Objects.equals(this.monitoredResourceName(), other.monitoredResourceName());
    }

    public final String toString() {
        return ToString.builder((String)"GetAlarmsRequest").add("AlarmName", (Object)this.alarmName()).add("PageToken", (Object)this.pageToken()).add("MonitoredResourceName", (Object)this.monitoredResourceName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "alarmName": {
                return Optional.ofNullable(clazz.cast(this.alarmName()));
            }
            case "pageToken": {
                return Optional.ofNullable(clazz.cast(this.pageToken()));
            }
            case "monitoredResourceName": {
                return Optional.ofNullable(clazz.cast(this.monitoredResourceName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("alarmName", ALARM_NAME_FIELD);
        map.put("pageToken", PAGE_TOKEN_FIELD);
        map.put("monitoredResourceName", MONITORED_RESOURCE_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetAlarmsRequest, T> g) {
        return obj -> g.apply((GetAlarmsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LightsailRequest.BuilderImpl
    implements Builder {
        private String alarmName;
        private String pageToken;
        private String monitoredResourceName;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAlarmsRequest model) {
            super(model);
            this.alarmName(model.alarmName);
            this.pageToken(model.pageToken);
            this.monitoredResourceName(model.monitoredResourceName);
        }

        public final String getAlarmName() {
            return this.alarmName;
        }

        public final void setAlarmName(String alarmName) {
            this.alarmName = alarmName;
        }

        @Override
        public final Builder alarmName(String alarmName) {
            this.alarmName = alarmName;
            return this;
        }

        public final String getPageToken() {
            return this.pageToken;
        }

        public final void setPageToken(String pageToken) {
            this.pageToken = pageToken;
        }

        @Override
        public final Builder pageToken(String pageToken) {
            this.pageToken = pageToken;
            return this;
        }

        public final String getMonitoredResourceName() {
            return this.monitoredResourceName;
        }

        public final void setMonitoredResourceName(String monitoredResourceName) {
            this.monitoredResourceName = monitoredResourceName;
        }

        @Override
        public final Builder monitoredResourceName(String monitoredResourceName) {
            this.monitoredResourceName = monitoredResourceName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetAlarmsRequest build() {
            return new GetAlarmsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends LightsailRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetAlarmsRequest> {
        public Builder alarmName(String var1);

        public Builder pageToken(String var1);

        public Builder monitoredResourceName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

