/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lightsail.model.AccountLevelBpaSync;
import software.amazon.awssdk.services.lightsail.model.Bucket;
import software.amazon.awssdk.services.lightsail.model.BucketListCopier;
import software.amazon.awssdk.services.lightsail.model.LightsailResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetBucketsResponse
extends LightsailResponse
implements ToCopyableBuilder<Builder, GetBucketsResponse> {
    private static final SdkField<List<Bucket>> BUCKETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("buckets").getter(GetBucketsResponse.getter(GetBucketsResponse::buckets)).setter(GetBucketsResponse.setter(Builder::buckets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("buckets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Bucket::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextPageToken").getter(GetBucketsResponse.getter(GetBucketsResponse::nextPageToken)).setter(GetBucketsResponse.setter(Builder::nextPageToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextPageToken").build()}).build();
    private static final SdkField<AccountLevelBpaSync> ACCOUNT_LEVEL_BPA_SYNC_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("accountLevelBpaSync").getter(GetBucketsResponse.getter(GetBucketsResponse::accountLevelBpaSync)).setter(GetBucketsResponse.setter(Builder::accountLevelBpaSync)).constructor(AccountLevelBpaSync::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountLevelBpaSync").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKETS_FIELD, NEXT_PAGE_TOKEN_FIELD, ACCOUNT_LEVEL_BPA_SYNC_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetBucketsResponse.memberNameToFieldInitializer();
    private final List<Bucket> buckets;
    private final String nextPageToken;
    private final AccountLevelBpaSync accountLevelBpaSync;

    private GetBucketsResponse(BuilderImpl builder) {
        super(builder);
        this.buckets = builder.buckets;
        this.nextPageToken = builder.nextPageToken;
        this.accountLevelBpaSync = builder.accountLevelBpaSync;
    }

    public final boolean hasBuckets() {
        return this.buckets != null && !(this.buckets instanceof SdkAutoConstructList);
    }

    public final List<Bucket> buckets() {
        return this.buckets;
    }

    public final String nextPageToken() {
        return this.nextPageToken;
    }

    public final AccountLevelBpaSync accountLevelBpaSync() {
        return this.accountLevelBpaSync;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBuckets() ? this.buckets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPageToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountLevelBpaSync());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBucketsResponse)) {
            return false;
        }
        GetBucketsResponse other = (GetBucketsResponse)((Object)obj);
        return this.hasBuckets() == other.hasBuckets() && Objects.equals(this.buckets(), other.buckets()) && Objects.equals(this.nextPageToken(), other.nextPageToken()) && Objects.equals(this.accountLevelBpaSync(), other.accountLevelBpaSync());
    }

    public final String toString() {
        return ToString.builder((String)"GetBucketsResponse").add("Buckets", this.hasBuckets() ? this.buckets() : null).add("NextPageToken", (Object)this.nextPageToken()).add("AccountLevelBpaSync", (Object)this.accountLevelBpaSync()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "buckets": {
                return Optional.ofNullable(clazz.cast(this.buckets()));
            }
            case "nextPageToken": {
                return Optional.ofNullable(clazz.cast(this.nextPageToken()));
            }
            case "accountLevelBpaSync": {
                return Optional.ofNullable(clazz.cast(this.accountLevelBpaSync()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("buckets", BUCKETS_FIELD);
        map.put("nextPageToken", NEXT_PAGE_TOKEN_FIELD);
        map.put("accountLevelBpaSync", ACCOUNT_LEVEL_BPA_SYNC_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetBucketsResponse, T> g) {
        return obj -> g.apply((GetBucketsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LightsailResponse.BuilderImpl
    implements Builder {
        private List<Bucket> buckets = DefaultSdkAutoConstructList.getInstance();
        private String nextPageToken;
        private AccountLevelBpaSync accountLevelBpaSync;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBucketsResponse model) {
            super(model);
            this.buckets(model.buckets);
            this.nextPageToken(model.nextPageToken);
            this.accountLevelBpaSync(model.accountLevelBpaSync);
        }

        public final List<Bucket.Builder> getBuckets() {
            List<Bucket.Builder> result = BucketListCopier.copyToBuilder(this.buckets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBuckets(Collection<Bucket.BuilderImpl> buckets) {
            this.buckets = BucketListCopier.copyFromBuilder(buckets);
        }

        @Override
        public final Builder buckets(Collection<Bucket> buckets) {
            this.buckets = BucketListCopier.copy(buckets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder buckets(Bucket ... buckets) {
            this.buckets(Arrays.asList(buckets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder buckets(Consumer<Bucket.Builder> ... buckets) {
            this.buckets(Stream.of(buckets).map(c -> (Bucket)((Bucket.Builder)Bucket.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final AccountLevelBpaSync.Builder getAccountLevelBpaSync() {
            return this.accountLevelBpaSync != null ? this.accountLevelBpaSync.toBuilder() : null;
        }

        public final void setAccountLevelBpaSync(AccountLevelBpaSync.BuilderImpl accountLevelBpaSync) {
            this.accountLevelBpaSync = accountLevelBpaSync != null ? accountLevelBpaSync.build() : null;
        }

        @Override
        public final Builder accountLevelBpaSync(AccountLevelBpaSync accountLevelBpaSync) {
            this.accountLevelBpaSync = accountLevelBpaSync;
            return this;
        }

        @Override
        public GetBucketsResponse build() {
            return new GetBucketsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends LightsailResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetBucketsResponse> {
        public Builder buckets(Collection<Bucket> var1);

        public Builder buckets(Bucket ... var1);

        public Builder buckets(Consumer<Bucket.Builder> ... var1);

        public Builder nextPageToken(String var1);

        public Builder accountLevelBpaSync(AccountLevelBpaSync var1);

        default public Builder accountLevelBpaSync(Consumer<AccountLevelBpaSync.Builder> accountLevelBpaSync) {
            return this.accountLevelBpaSync((AccountLevelBpaSync)((AccountLevelBpaSync.Builder)AccountLevelBpaSync.builder().applyMutation(accountLevelBpaSync)).build());
        }
    }
}

