/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.location.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the political view for the style.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MapConfigurationUpdate implements SdkPojo, Serializable,
        ToCopyableBuilder<MapConfigurationUpdate.Builder, MapConfigurationUpdate> {
    private static final SdkField<String> POLITICAL_VIEW_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PoliticalView").getter(getter(MapConfigurationUpdate::politicalView))
            .setter(setter(Builder::politicalView))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoliticalView").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLITICAL_VIEW_FIELD));

    private static final long serialVersionUID = 1L;

    private final String politicalView;

    private MapConfigurationUpdate(BuilderImpl builder) {
        this.politicalView = builder.politicalView;
    }

    /**
     * <p>
     * Specifies the political view for the style. Set to an empty string to not use a political view, or, for styles
     * that support specific political views, you can choose a view, such as <code>IND</code> for the Indian view.
     * </p>
     * <note>
     * <p>
     * Not all map resources or styles support political view styles. See <a
     * href="https://docs.aws.amazon.com/location/latest/developerguide/map-concepts.html#political-views">Political
     * views</a> for more information.
     * </p>
     * </note>
     * 
     * @return Specifies the political view for the style. Set to an empty string to not use a political view, or, for
     *         styles that support specific political views, you can choose a view, such as <code>IND</code> for the
     *         Indian view.</p> <note>
     *         <p>
     *         Not all map resources or styles support political view styles. See <a
     *         href="https://docs.aws.amazon.com/location/latest/developerguide/map-concepts.html#political-views"
     *         >Political views</a> for more information.
     *         </p>
     */
    public final String politicalView() {
        return politicalView;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(politicalView());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MapConfigurationUpdate)) {
            return false;
        }
        MapConfigurationUpdate other = (MapConfigurationUpdate) obj;
        return Objects.equals(politicalView(), other.politicalView());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MapConfigurationUpdate").add("PoliticalView", politicalView()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PoliticalView":
            return Optional.ofNullable(clazz.cast(politicalView()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MapConfigurationUpdate, T> g) {
        return obj -> g.apply((MapConfigurationUpdate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MapConfigurationUpdate> {
        /**
         * <p>
         * Specifies the political view for the style. Set to an empty string to not use a political view, or, for
         * styles that support specific political views, you can choose a view, such as <code>IND</code> for the Indian
         * view.
         * </p>
         * <note>
         * <p>
         * Not all map resources or styles support political view styles. See <a
         * href="https://docs.aws.amazon.com/location/latest/developerguide/map-concepts.html#political-views">Political
         * views</a> for more information.
         * </p>
         * </note>
         * 
         * @param politicalView
         *        Specifies the political view for the style. Set to an empty string to not use a political view, or,
         *        for styles that support specific political views, you can choose a view, such as <code>IND</code> for
         *        the Indian view.</p> <note>
         *        <p>
         *        Not all map resources or styles support political view styles. See <a
         *        href="https://docs.aws.amazon.com/location/latest/developerguide/map-concepts.html#political-views"
         *        >Political views</a> for more information.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder politicalView(String politicalView);
    }

    static final class BuilderImpl implements Builder {
        private String politicalView;

        private BuilderImpl() {
        }

        private BuilderImpl(MapConfigurationUpdate model) {
            politicalView(model.politicalView);
        }

        public final String getPoliticalView() {
            return politicalView;
        }

        public final void setPoliticalView(String politicalView) {
            this.politicalView = politicalView;
        }

        @Override
        public final Builder politicalView(String politicalView) {
            this.politicalView = politicalView;
            return this;
        }

        @Override
        public MapConfigurationUpdate build() {
            return new MapConfigurationUpdate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
