/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.location.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a time zone. Includes the name of the time zone and the offset from UTC in seconds.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TimeZone implements SdkPojo, Serializable, ToCopyableBuilder<TimeZone.Builder, TimeZone> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(TimeZone::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<Integer> OFFSET_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Offset").getter(getter(TimeZone::offset)).setter(setter(Builder::offset))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Offset").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, OFFSET_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final Integer offset;

    private TimeZone(BuilderImpl builder) {
        this.name = builder.name;
        this.offset = builder.offset;
    }

    /**
     * <p>
     * The name of the time zone, following the <a href="https://www.iana.org/time-zones"> IANA time zone standard</a>.
     * For example, <code>America/Los_Angeles</code>.
     * </p>
     * 
     * @return The name of the time zone, following the <a href="https://www.iana.org/time-zones"> IANA time zone
     *         standard</a>. For example, <code>America/Los_Angeles</code>.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The time zone's offset, in seconds, from UTC.
     * </p>
     * 
     * @return The time zone's offset, in seconds, from UTC.
     */
    public final Integer offset() {
        return offset;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(offset());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimeZone)) {
            return false;
        }
        TimeZone other = (TimeZone) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(offset(), other.offset());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TimeZone").add("Name", name()).add("Offset", offset()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Offset":
            return Optional.ofNullable(clazz.cast(offset()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TimeZone, T> g) {
        return obj -> g.apply((TimeZone) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TimeZone> {
        /**
         * <p>
         * The name of the time zone, following the <a href="https://www.iana.org/time-zones"> IANA time zone
         * standard</a>. For example, <code>America/Los_Angeles</code>.
         * </p>
         * 
         * @param name
         *        The name of the time zone, following the <a href="https://www.iana.org/time-zones"> IANA time zone
         *        standard</a>. For example, <code>America/Los_Angeles</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The time zone's offset, in seconds, from UTC.
         * </p>
         * 
         * @param offset
         *        The time zone's offset, in seconds, from UTC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offset(Integer offset);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private Integer offset;

        private BuilderImpl() {
        }

        private BuilderImpl(TimeZone model) {
            name(model.name);
            offset(model.offset);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Integer getOffset() {
            return offset;
        }

        public final void setOffset(Integer offset) {
            this.offset = offset;
        }

        @Override
        public final Builder offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        @Override
        public TimeZone build() {
            return new TimeZone(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
