/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutequipment.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDataIngestionJobResponse extends LookoutEquipmentResponse implements
        ToCopyableBuilder<DescribeDataIngestionJobResponse.Builder, DescribeDataIngestionJobResponse> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("JobId")
            .getter(getter(DescribeDataIngestionJobResponse::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobId").build()).build();

    private static final SdkField<String> DATASET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatasetArn").getter(getter(DescribeDataIngestionJobResponse::datasetArn))
            .setter(setter(Builder::datasetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetArn").build()).build();

    private static final SdkField<IngestionInputConfiguration> INGESTION_INPUT_CONFIGURATION_FIELD = SdkField
            .<IngestionInputConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("IngestionInputConfiguration")
            .getter(getter(DescribeDataIngestionJobResponse::ingestionInputConfiguration))
            .setter(setter(Builder::ingestionInputConfiguration))
            .constructor(IngestionInputConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IngestionInputConfiguration")
                    .build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(DescribeDataIngestionJobResponse::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt").getter(getter(DescribeDataIngestionJobResponse::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DescribeDataIngestionJobResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> FAILED_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailedReason").getter(getter(DescribeDataIngestionJobResponse::failedReason))
            .setter(setter(Builder::failedReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailedReason").build()).build();

    private static final SdkField<DataQualitySummary> DATA_QUALITY_SUMMARY_FIELD = SdkField
            .<DataQualitySummary> builder(MarshallingType.SDK_POJO).memberName("DataQualitySummary")
            .getter(getter(DescribeDataIngestionJobResponse::dataQualitySummary)).setter(setter(Builder::dataQualitySummary))
            .constructor(DataQualitySummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataQualitySummary").build())
            .build();

    private static final SdkField<IngestedFilesSummary> INGESTED_FILES_SUMMARY_FIELD = SdkField
            .<IngestedFilesSummary> builder(MarshallingType.SDK_POJO).memberName("IngestedFilesSummary")
            .getter(getter(DescribeDataIngestionJobResponse::ingestedFilesSummary)).setter(setter(Builder::ingestedFilesSummary))
            .constructor(IngestedFilesSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IngestedFilesSummary").build())
            .build();

    private static final SdkField<String> STATUS_DETAIL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusDetail").getter(getter(DescribeDataIngestionJobResponse::statusDetail))
            .setter(setter(Builder::statusDetail))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusDetail").build()).build();

    private static final SdkField<Long> INGESTED_DATA_SIZE_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("IngestedDataSize").getter(getter(DescribeDataIngestionJobResponse::ingestedDataSize))
            .setter(setter(Builder::ingestedDataSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IngestedDataSize").build()).build();

    private static final SdkField<Instant> DATA_START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("DataStartTime").getter(getter(DescribeDataIngestionJobResponse::dataStartTime))
            .setter(setter(Builder::dataStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataStartTime").build()).build();

    private static final SdkField<Instant> DATA_END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("DataEndTime").getter(getter(DescribeDataIngestionJobResponse::dataEndTime))
            .setter(setter(Builder::dataEndTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataEndTime").build()).build();

    private static final SdkField<String> SOURCE_DATASET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceDatasetArn").getter(getter(DescribeDataIngestionJobResponse::sourceDatasetArn))
            .setter(setter(Builder::sourceDatasetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceDatasetArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD,
            DATASET_ARN_FIELD, INGESTION_INPUT_CONFIGURATION_FIELD, ROLE_ARN_FIELD, CREATED_AT_FIELD, STATUS_FIELD,
            FAILED_REASON_FIELD, DATA_QUALITY_SUMMARY_FIELD, INGESTED_FILES_SUMMARY_FIELD, STATUS_DETAIL_FIELD,
            INGESTED_DATA_SIZE_FIELD, DATA_START_TIME_FIELD, DATA_END_TIME_FIELD, SOURCE_DATASET_ARN_FIELD));

    private final String jobId;

    private final String datasetArn;

    private final IngestionInputConfiguration ingestionInputConfiguration;

    private final String roleArn;

    private final Instant createdAt;

    private final String status;

    private final String failedReason;

    private final DataQualitySummary dataQualitySummary;

    private final IngestedFilesSummary ingestedFilesSummary;

    private final String statusDetail;

    private final Long ingestedDataSize;

    private final Instant dataStartTime;

    private final Instant dataEndTime;

    private final String sourceDatasetArn;

    private DescribeDataIngestionJobResponse(BuilderImpl builder) {
        super(builder);
        this.jobId = builder.jobId;
        this.datasetArn = builder.datasetArn;
        this.ingestionInputConfiguration = builder.ingestionInputConfiguration;
        this.roleArn = builder.roleArn;
        this.createdAt = builder.createdAt;
        this.status = builder.status;
        this.failedReason = builder.failedReason;
        this.dataQualitySummary = builder.dataQualitySummary;
        this.ingestedFilesSummary = builder.ingestedFilesSummary;
        this.statusDetail = builder.statusDetail;
        this.ingestedDataSize = builder.ingestedDataSize;
        this.dataStartTime = builder.dataStartTime;
        this.dataEndTime = builder.dataEndTime;
        this.sourceDatasetArn = builder.sourceDatasetArn;
    }

    /**
     * <p>
     * Indicates the job ID of the data ingestion job.
     * </p>
     * 
     * @return Indicates the job ID of the data ingestion job.
     */
    public final String jobId() {
        return jobId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the dataset being used in the data ingestion job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the dataset being used in the data ingestion job.
     */
    public final String datasetArn() {
        return datasetArn;
    }

    /**
     * <p>
     * Specifies the S3 location configuration for the data input for the data ingestion job.
     * </p>
     * 
     * @return Specifies the S3 location configuration for the data input for the data ingestion job.
     */
    public final IngestionInputConfiguration ingestionInputConfiguration() {
        return ingestionInputConfiguration;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an IAM role with permission to access the data source being ingested.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an IAM role with permission to access the data source being ingested.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The time at which the data ingestion job was created.
     * </p>
     * 
     * @return The time at which the data ingestion job was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * Indicates the status of the <code>DataIngestionJob</code> operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link IngestionJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Indicates the status of the <code>DataIngestionJob</code> operation.
     * @see IngestionJobStatus
     */
    public final IngestionJobStatus status() {
        return IngestionJobStatus.fromValue(status);
    }

    /**
     * <p>
     * Indicates the status of the <code>DataIngestionJob</code> operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link IngestionJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Indicates the status of the <code>DataIngestionJob</code> operation.
     * @see IngestionJobStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Specifies the reason for failure when a data ingestion job has failed.
     * </p>
     * 
     * @return Specifies the reason for failure when a data ingestion job has failed.
     */
    public final String failedReason() {
        return failedReason;
    }

    /**
     * <p>
     * Gives statistics about a completed ingestion job. These statistics primarily relate to quantifying incorrect data
     * such as MissingCompleteSensorData, MissingSensorData, UnsupportedDateFormats, InsufficientSensorData, and
     * DuplicateTimeStamps.
     * </p>
     * 
     * @return Gives statistics about a completed ingestion job. These statistics primarily relate to quantifying
     *         incorrect data such as MissingCompleteSensorData, MissingSensorData, UnsupportedDateFormats,
     *         InsufficientSensorData, and DuplicateTimeStamps.
     */
    public final DataQualitySummary dataQualitySummary() {
        return dataQualitySummary;
    }

    /**
     * Returns the value of the IngestedFilesSummary property for this object.
     * 
     * @return The value of the IngestedFilesSummary property for this object.
     */
    public final IngestedFilesSummary ingestedFilesSummary() {
        return ingestedFilesSummary;
    }

    /**
     * <p>
     * Provides details about status of the ingestion job that is currently in progress.
     * </p>
     * 
     * @return Provides details about status of the ingestion job that is currently in progress.
     */
    public final String statusDetail() {
        return statusDetail;
    }

    /**
     * <p>
     * Indicates the size of the ingested dataset.
     * </p>
     * 
     * @return Indicates the size of the ingested dataset.
     */
    public final Long ingestedDataSize() {
        return ingestedDataSize;
    }

    /**
     * <p>
     * Indicates the earliest timestamp corresponding to data that was successfully ingested during this specific
     * ingestion job.
     * </p>
     * 
     * @return Indicates the earliest timestamp corresponding to data that was successfully ingested during this
     *         specific ingestion job.
     */
    public final Instant dataStartTime() {
        return dataStartTime;
    }

    /**
     * <p>
     * Indicates the latest timestamp corresponding to data that was successfully ingested during this specific
     * ingestion job.
     * </p>
     * 
     * @return Indicates the latest timestamp corresponding to data that was successfully ingested during this specific
     *         ingestion job.
     */
    public final Instant dataEndTime() {
        return dataEndTime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the source dataset from which the data used for the data ingestion job was
     * imported from.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the source dataset from which the data used for the data ingestion job
     *         was imported from.
     */
    public final String sourceDatasetArn() {
        return sourceDatasetArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(datasetArn());
        hashCode = 31 * hashCode + Objects.hashCode(ingestionInputConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(failedReason());
        hashCode = 31 * hashCode + Objects.hashCode(dataQualitySummary());
        hashCode = 31 * hashCode + Objects.hashCode(ingestedFilesSummary());
        hashCode = 31 * hashCode + Objects.hashCode(statusDetail());
        hashCode = 31 * hashCode + Objects.hashCode(ingestedDataSize());
        hashCode = 31 * hashCode + Objects.hashCode(dataStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(dataEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(sourceDatasetArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDataIngestionJobResponse)) {
            return false;
        }
        DescribeDataIngestionJobResponse other = (DescribeDataIngestionJobResponse) obj;
        return Objects.equals(jobId(), other.jobId()) && Objects.equals(datasetArn(), other.datasetArn())
                && Objects.equals(ingestionInputConfiguration(), other.ingestionInputConfiguration())
                && Objects.equals(roleArn(), other.roleArn()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(failedReason(), other.failedReason())
                && Objects.equals(dataQualitySummary(), other.dataQualitySummary())
                && Objects.equals(ingestedFilesSummary(), other.ingestedFilesSummary())
                && Objects.equals(statusDetail(), other.statusDetail())
                && Objects.equals(ingestedDataSize(), other.ingestedDataSize())
                && Objects.equals(dataStartTime(), other.dataStartTime()) && Objects.equals(dataEndTime(), other.dataEndTime())
                && Objects.equals(sourceDatasetArn(), other.sourceDatasetArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeDataIngestionJobResponse").add("JobId", jobId()).add("DatasetArn", datasetArn())
                .add("IngestionInputConfiguration", ingestionInputConfiguration()).add("RoleArn", roleArn())
                .add("CreatedAt", createdAt()).add("Status", statusAsString()).add("FailedReason", failedReason())
                .add("DataQualitySummary", dataQualitySummary()).add("IngestedFilesSummary", ingestedFilesSummary())
                .add("StatusDetail", statusDetail()).add("IngestedDataSize", ingestedDataSize())
                .add("DataStartTime", dataStartTime()).add("DataEndTime", dataEndTime())
                .add("SourceDatasetArn", sourceDatasetArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "DatasetArn":
            return Optional.ofNullable(clazz.cast(datasetArn()));
        case "IngestionInputConfiguration":
            return Optional.ofNullable(clazz.cast(ingestionInputConfiguration()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "FailedReason":
            return Optional.ofNullable(clazz.cast(failedReason()));
        case "DataQualitySummary":
            return Optional.ofNullable(clazz.cast(dataQualitySummary()));
        case "IngestedFilesSummary":
            return Optional.ofNullable(clazz.cast(ingestedFilesSummary()));
        case "StatusDetail":
            return Optional.ofNullable(clazz.cast(statusDetail()));
        case "IngestedDataSize":
            return Optional.ofNullable(clazz.cast(ingestedDataSize()));
        case "DataStartTime":
            return Optional.ofNullable(clazz.cast(dataStartTime()));
        case "DataEndTime":
            return Optional.ofNullable(clazz.cast(dataEndTime()));
        case "SourceDatasetArn":
            return Optional.ofNullable(clazz.cast(sourceDatasetArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDataIngestionJobResponse, T> g) {
        return obj -> g.apply((DescribeDataIngestionJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LookoutEquipmentResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeDataIngestionJobResponse> {
        /**
         * <p>
         * Indicates the job ID of the data ingestion job.
         * </p>
         * 
         * @param jobId
         *        Indicates the job ID of the data ingestion job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the dataset being used in the data ingestion job.
         * </p>
         * 
         * @param datasetArn
         *        The Amazon Resource Name (ARN) of the dataset being used in the data ingestion job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetArn(String datasetArn);

        /**
         * <p>
         * Specifies the S3 location configuration for the data input for the data ingestion job.
         * </p>
         * 
         * @param ingestionInputConfiguration
         *        Specifies the S3 location configuration for the data input for the data ingestion job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ingestionInputConfiguration(IngestionInputConfiguration ingestionInputConfiguration);

        /**
         * <p>
         * Specifies the S3 location configuration for the data input for the data ingestion job.
         * </p>
         * This is a convenience method that creates an instance of the {@link IngestionInputConfiguration.Builder}
         * avoiding the need to create one manually via {@link IngestionInputConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IngestionInputConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #ingestionInputConfiguration(IngestionInputConfiguration)}.
         * 
         * @param ingestionInputConfiguration
         *        a consumer that will call methods on {@link IngestionInputConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ingestionInputConfiguration(IngestionInputConfiguration)
         */
        default Builder ingestionInputConfiguration(Consumer<IngestionInputConfiguration.Builder> ingestionInputConfiguration) {
            return ingestionInputConfiguration(IngestionInputConfiguration.builder().applyMutation(ingestionInputConfiguration)
                    .build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of an IAM role with permission to access the data source being ingested.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of an IAM role with permission to access the data source being
         *        ingested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The time at which the data ingestion job was created.
         * </p>
         * 
         * @param createdAt
         *        The time at which the data ingestion job was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * Indicates the status of the <code>DataIngestionJob</code> operation.
         * </p>
         * 
         * @param status
         *        Indicates the status of the <code>DataIngestionJob</code> operation.
         * @see IngestionJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IngestionJobStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Indicates the status of the <code>DataIngestionJob</code> operation.
         * </p>
         * 
         * @param status
         *        Indicates the status of the <code>DataIngestionJob</code> operation.
         * @see IngestionJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IngestionJobStatus
         */
        Builder status(IngestionJobStatus status);

        /**
         * <p>
         * Specifies the reason for failure when a data ingestion job has failed.
         * </p>
         * 
         * @param failedReason
         *        Specifies the reason for failure when a data ingestion job has failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedReason(String failedReason);

        /**
         * <p>
         * Gives statistics about a completed ingestion job. These statistics primarily relate to quantifying incorrect
         * data such as MissingCompleteSensorData, MissingSensorData, UnsupportedDateFormats, InsufficientSensorData,
         * and DuplicateTimeStamps.
         * </p>
         * 
         * @param dataQualitySummary
         *        Gives statistics about a completed ingestion job. These statistics primarily relate to quantifying
         *        incorrect data such as MissingCompleteSensorData, MissingSensorData, UnsupportedDateFormats,
         *        InsufficientSensorData, and DuplicateTimeStamps.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataQualitySummary(DataQualitySummary dataQualitySummary);

        /**
         * <p>
         * Gives statistics about a completed ingestion job. These statistics primarily relate to quantifying incorrect
         * data such as MissingCompleteSensorData, MissingSensorData, UnsupportedDateFormats, InsufficientSensorData,
         * and DuplicateTimeStamps.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataQualitySummary.Builder} avoiding the
         * need to create one manually via {@link DataQualitySummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataQualitySummary.Builder#build()} is called immediately and its
         * result is passed to {@link #dataQualitySummary(DataQualitySummary)}.
         * 
         * @param dataQualitySummary
         *        a consumer that will call methods on {@link DataQualitySummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataQualitySummary(DataQualitySummary)
         */
        default Builder dataQualitySummary(Consumer<DataQualitySummary.Builder> dataQualitySummary) {
            return dataQualitySummary(DataQualitySummary.builder().applyMutation(dataQualitySummary).build());
        }

        /**
         * Sets the value of the IngestedFilesSummary property for this object.
         *
         * @param ingestedFilesSummary
         *        The new value for the IngestedFilesSummary property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ingestedFilesSummary(IngestedFilesSummary ingestedFilesSummary);

        /**
         * Sets the value of the IngestedFilesSummary property for this object.
         *
         * This is a convenience method that creates an instance of the {@link IngestedFilesSummary.Builder} avoiding
         * the need to create one manually via {@link IngestedFilesSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IngestedFilesSummary.Builder#build()} is called immediately and
         * its result is passed to {@link #ingestedFilesSummary(IngestedFilesSummary)}.
         * 
         * @param ingestedFilesSummary
         *        a consumer that will call methods on {@link IngestedFilesSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ingestedFilesSummary(IngestedFilesSummary)
         */
        default Builder ingestedFilesSummary(Consumer<IngestedFilesSummary.Builder> ingestedFilesSummary) {
            return ingestedFilesSummary(IngestedFilesSummary.builder().applyMutation(ingestedFilesSummary).build());
        }

        /**
         * <p>
         * Provides details about status of the ingestion job that is currently in progress.
         * </p>
         * 
         * @param statusDetail
         *        Provides details about status of the ingestion job that is currently in progress.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusDetail(String statusDetail);

        /**
         * <p>
         * Indicates the size of the ingested dataset.
         * </p>
         * 
         * @param ingestedDataSize
         *        Indicates the size of the ingested dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ingestedDataSize(Long ingestedDataSize);

        /**
         * <p>
         * Indicates the earliest timestamp corresponding to data that was successfully ingested during this specific
         * ingestion job.
         * </p>
         * 
         * @param dataStartTime
         *        Indicates the earliest timestamp corresponding to data that was successfully ingested during this
         *        specific ingestion job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataStartTime(Instant dataStartTime);

        /**
         * <p>
         * Indicates the latest timestamp corresponding to data that was successfully ingested during this specific
         * ingestion job.
         * </p>
         * 
         * @param dataEndTime
         *        Indicates the latest timestamp corresponding to data that was successfully ingested during this
         *        specific ingestion job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataEndTime(Instant dataEndTime);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the source dataset from which the data used for the data ingestion job was
         * imported from.
         * </p>
         * 
         * @param sourceDatasetArn
         *        The Amazon Resource Name (ARN) of the source dataset from which the data used for the data ingestion
         *        job was imported from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceDatasetArn(String sourceDatasetArn);
    }

    static final class BuilderImpl extends LookoutEquipmentResponse.BuilderImpl implements Builder {
        private String jobId;

        private String datasetArn;

        private IngestionInputConfiguration ingestionInputConfiguration;

        private String roleArn;

        private Instant createdAt;

        private String status;

        private String failedReason;

        private DataQualitySummary dataQualitySummary;

        private IngestedFilesSummary ingestedFilesSummary;

        private String statusDetail;

        private Long ingestedDataSize;

        private Instant dataStartTime;

        private Instant dataEndTime;

        private String sourceDatasetArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDataIngestionJobResponse model) {
            super(model);
            jobId(model.jobId);
            datasetArn(model.datasetArn);
            ingestionInputConfiguration(model.ingestionInputConfiguration);
            roleArn(model.roleArn);
            createdAt(model.createdAt);
            status(model.status);
            failedReason(model.failedReason);
            dataQualitySummary(model.dataQualitySummary);
            ingestedFilesSummary(model.ingestedFilesSummary);
            statusDetail(model.statusDetail);
            ingestedDataSize(model.ingestedDataSize);
            dataStartTime(model.dataStartTime);
            dataEndTime(model.dataEndTime);
            sourceDatasetArn(model.sourceDatasetArn);
        }

        public final String getJobId() {
            return jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getDatasetArn() {
            return datasetArn;
        }

        public final void setDatasetArn(String datasetArn) {
            this.datasetArn = datasetArn;
        }

        @Override
        public final Builder datasetArn(String datasetArn) {
            this.datasetArn = datasetArn;
            return this;
        }

        public final IngestionInputConfiguration.Builder getIngestionInputConfiguration() {
            return ingestionInputConfiguration != null ? ingestionInputConfiguration.toBuilder() : null;
        }

        public final void setIngestionInputConfiguration(IngestionInputConfiguration.BuilderImpl ingestionInputConfiguration) {
            this.ingestionInputConfiguration = ingestionInputConfiguration != null ? ingestionInputConfiguration.build() : null;
        }

        @Override
        public final Builder ingestionInputConfiguration(IngestionInputConfiguration ingestionInputConfiguration) {
            this.ingestionInputConfiguration = ingestionInputConfiguration;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(IngestionJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getFailedReason() {
            return failedReason;
        }

        public final void setFailedReason(String failedReason) {
            this.failedReason = failedReason;
        }

        @Override
        public final Builder failedReason(String failedReason) {
            this.failedReason = failedReason;
            return this;
        }

        public final DataQualitySummary.Builder getDataQualitySummary() {
            return dataQualitySummary != null ? dataQualitySummary.toBuilder() : null;
        }

        public final void setDataQualitySummary(DataQualitySummary.BuilderImpl dataQualitySummary) {
            this.dataQualitySummary = dataQualitySummary != null ? dataQualitySummary.build() : null;
        }

        @Override
        public final Builder dataQualitySummary(DataQualitySummary dataQualitySummary) {
            this.dataQualitySummary = dataQualitySummary;
            return this;
        }

        public final IngestedFilesSummary.Builder getIngestedFilesSummary() {
            return ingestedFilesSummary != null ? ingestedFilesSummary.toBuilder() : null;
        }

        public final void setIngestedFilesSummary(IngestedFilesSummary.BuilderImpl ingestedFilesSummary) {
            this.ingestedFilesSummary = ingestedFilesSummary != null ? ingestedFilesSummary.build() : null;
        }

        @Override
        public final Builder ingestedFilesSummary(IngestedFilesSummary ingestedFilesSummary) {
            this.ingestedFilesSummary = ingestedFilesSummary;
            return this;
        }

        public final String getStatusDetail() {
            return statusDetail;
        }

        public final void setStatusDetail(String statusDetail) {
            this.statusDetail = statusDetail;
        }

        @Override
        public final Builder statusDetail(String statusDetail) {
            this.statusDetail = statusDetail;
            return this;
        }

        public final Long getIngestedDataSize() {
            return ingestedDataSize;
        }

        public final void setIngestedDataSize(Long ingestedDataSize) {
            this.ingestedDataSize = ingestedDataSize;
        }

        @Override
        public final Builder ingestedDataSize(Long ingestedDataSize) {
            this.ingestedDataSize = ingestedDataSize;
            return this;
        }

        public final Instant getDataStartTime() {
            return dataStartTime;
        }

        public final void setDataStartTime(Instant dataStartTime) {
            this.dataStartTime = dataStartTime;
        }

        @Override
        public final Builder dataStartTime(Instant dataStartTime) {
            this.dataStartTime = dataStartTime;
            return this;
        }

        public final Instant getDataEndTime() {
            return dataEndTime;
        }

        public final void setDataEndTime(Instant dataEndTime) {
            this.dataEndTime = dataEndTime;
        }

        @Override
        public final Builder dataEndTime(Instant dataEndTime) {
            this.dataEndTime = dataEndTime;
            return this;
        }

        public final String getSourceDatasetArn() {
            return sourceDatasetArn;
        }

        public final void setSourceDatasetArn(String sourceDatasetArn) {
            this.sourceDatasetArn = sourceDatasetArn;
        }

        @Override
        public final Builder sourceDatasetArn(String sourceDatasetArn) {
            this.sourceDatasetArn = sourceDatasetArn;
            return this;
        }

        @Override
        public DescribeDataIngestionJobResponse build() {
            return new DescribeDataIngestionJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
