/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutequipment.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lookoutequipment.model.LookoutEquipmentRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeModelVersionRequest
extends LookoutEquipmentRequest
implements ToCopyableBuilder<Builder, DescribeModelVersionRequest> {
    private static final SdkField<String> MODEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelName").getter(DescribeModelVersionRequest.getter(DescribeModelVersionRequest::modelName)).setter(DescribeModelVersionRequest.setter(Builder::modelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelName").build()}).build();
    private static final SdkField<Long> MODEL_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ModelVersion").getter(DescribeModelVersionRequest.getter(DescribeModelVersionRequest::modelVersion)).setter(DescribeModelVersionRequest.setter(Builder::modelVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_NAME_FIELD, MODEL_VERSION_FIELD));
    private final String modelName;
    private final Long modelVersion;

    private DescribeModelVersionRequest(BuilderImpl builder) {
        super(builder);
        this.modelName = builder.modelName;
        this.modelVersion = builder.modelVersion;
    }

    public final String modelName() {
        return this.modelName;
    }

    public final Long modelVersion() {
        return this.modelVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.modelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeModelVersionRequest)) {
            return false;
        }
        DescribeModelVersionRequest other = (DescribeModelVersionRequest)((Object)obj);
        return Objects.equals(this.modelName(), other.modelName()) && Objects.equals(this.modelVersion(), other.modelVersion());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeModelVersionRequest").add("ModelName", (Object)this.modelName()).add("ModelVersion", (Object)this.modelVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ModelName": {
                return Optional.ofNullable(clazz.cast(this.modelName()));
            }
            case "ModelVersion": {
                return Optional.ofNullable(clazz.cast(this.modelVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeModelVersionRequest, T> g) {
        return obj -> g.apply((DescribeModelVersionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LookoutEquipmentRequest.BuilderImpl
    implements Builder {
        private String modelName;
        private Long modelVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeModelVersionRequest model) {
            super(model);
            this.modelName(model.modelName);
            this.modelVersion(model.modelVersion);
        }

        public final String getModelName() {
            return this.modelName;
        }

        public final void setModelName(String modelName) {
            this.modelName = modelName;
        }

        @Override
        public final Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public final Long getModelVersion() {
            return this.modelVersion;
        }

        public final void setModelVersion(Long modelVersion) {
            this.modelVersion = modelVersion;
        }

        @Override
        public final Builder modelVersion(Long modelVersion) {
            this.modelVersion = modelVersion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeModelVersionRequest build() {
            return new DescribeModelVersionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LookoutEquipmentRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeModelVersionRequest> {
        public Builder modelName(String var1);

        public Builder modelVersion(Long var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

