/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutequipment.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ModelQuality {
    QUALITY_THRESHOLD_MET("QUALITY_THRESHOLD_MET"),
    CANNOT_DETERMINE_QUALITY("CANNOT_DETERMINE_QUALITY"),
    POOR_QUALITY_DETECTED("POOR_QUALITY_DETECTED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ModelQuality> VALUE_MAP;
    private final String value;

    private ModelQuality(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ModelQuality fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ModelQuality> knownValues() {
        EnumSet<ModelQuality> knownValues = EnumSet.allOf(ModelQuality.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ModelQuality.class, ModelQuality::toString);
    }
}

